/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseTerminalDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.DeviceType;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class TerminalDAO
extends BaseTerminalDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDrawerAssigned(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminal.getId()));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ASSIGNED_USER_ID));
            Object object = criteria.uniqueResult();
            boolean bl = object != null;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public String createNewTerminalName() {
        Session session = null;
        try {
            session = this.getSession();
            String string = this.createNewTerminalName(session);
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Integer createNewTerminalId(String string) {
        return Math.abs(string.hashCode());
    }

    public String createNewTerminalName(Session session) {
        String string;
        Criteria criteria;
        Object object;
        if (session == null) {
            return this.createNewTerminalName();
        }
        Random random = new Random();
        do {
            string = String.valueOf(random.nextInt(10000) + 1);
            criteria = session.createCriteria(this.getClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)string));
        } while ((object = criteria.uniqueResult()) != null);
        return string;
    }

    public Terminal createNewTerminal(String string, Outlet outlet) {
        return this.createNewTerminal(string, outlet, null);
    }

    public Terminal createNewTerminal(String string, Outlet outlet, Session session) {
        Terminal terminal = new Terminal();
        terminal.setId(this.createNewTerminalId(string));
        terminal.setName(this.createNewTerminalName(session));
        terminal.setTerminalKey(string);
        if (outlet != null) {
            terminal.setOutletId(outlet.getId());
        }
        if (session == null) {
            this.save(terminal);
        } else {
            this.save(terminal, session);
        }
        return terminal;
    }

    public void refresh(Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            session.refresh((Object)terminal);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findOpenTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNotNull((String)Terminal.PROP_ASSIGNED_USER_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findCashDrawerTerminals() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_HAS_CASH_DRAWER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void performBatchSave(Object ... objectArray) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Object object : objectArray) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void performBatchSave(List<String> list, Object ... objectArray) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Object object : objectArray) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            if (list != null) {
                for (String string : list) {
                    Query query = session.createQuery(string);
                    query.executeUpdate();
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetCashDrawer(CashDrawer cashDrawer, Terminal terminal, User user, double d) throws Exception {
        Session session = null;
        Transaction transaction = null;
        cashDrawer.setClosedBy(user);
        cashDrawer.setReportTime(new Date());
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            terminal.setAssignedUserId(null);
            terminal.setCurrentCashDrawer(null);
            this.update(terminal, session);
            this.saveOrUpdate(cashDrawer, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User user, CashDrawer cashDrawer) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.resetStaffBank(user, cashDrawer, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void resetStaffBank(User user, CashDrawer cashDrawer, Session session) throws Exception {
        User user2;
        cashDrawer.setClosedBy(user);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        String string = cashDrawer.getAssignedUserId();
        if (StringUtils.isNotEmpty((String)string) && (user2 = UserDAO.getInstance().get(string)) != null) {
            user2.setStaffBankStarted(false);
            user2.setCurrentCashDrawer(null);
            UserDAO.getInstance().update(user2, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal initialize(Terminal terminal) {
        if (terminal == null || terminal.getId() == null) {
            return terminal;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)terminal);
            Terminal terminal2 = terminal;
            return terminal2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal getByTerminalKey(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Terminal terminal = this.getByTerminalKey(string, session);
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Terminal getByTerminalKey(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)string));
        List list = criteria.list();
        if (list.size() > 0) {
            return (Terminal)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal findByAssignedUser(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            List list = criteria.list();
            if (list.size() > 0) {
                Terminal terminal = (Terminal)list.get(0);
                return terminal;
            }
            Terminal terminal = null;
            return terminal;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVersionEqual(Class clazz, Object object, long l) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)object));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            Object object2 = criteria.uniqueResult();
            if (object2 instanceof Number) {
                boolean bl = ((Number)object2).longValue() == l;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getVersion(Class clazz, String string, Object object) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)string, (Object)object));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            long l = (Long)criteria.uniqueResult();
            return l;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSqlQuery(List<String> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (String string : list) {
                SQLQuery sQLQuery = session.createSQLQuery(string);
                sQLQuery.executeUpdate();
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List executeSqlQuery(String string) {
        return this.executeSqlQuery(string, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeSqlQuery(String string, long l, long l2) {
        Session session = null;
        try {
            session = this.createNewSession();
            SQLQuery sQLQuery = session.createSQLQuery(string);
            if (l2 > 0L) {
                sQLQuery.setFirstResult((int)l);
                sQLQuery.setMaxResults((int)l2);
            }
            List list = sQLQuery.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findTerminalsByDeviceType(int n, int n2) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_DEVICE_TYPE, (Object)n));
            if (n2 > 0) {
                criteria.setMaxResults(n2);
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List findDataList(Class clazz, Date date) {
        return this.findDataList(clazz, date, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findDataList(Class clazz, Date date, Criterion criterion) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(clazz);
            if (criterion != null) {
                criteria.add(criterion);
            }
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getActiveTerminalCount() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.neOrIsNotNull((String)Terminal.PROP_TERMINAL_KEY, (Object)""));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean deactivateAllActiveTerminal() {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String string = "UPDATE " + Terminal.REF + " T SET T." + Terminal.PROP_ACTIVE + "=:newValue WHERE T." + Terminal.PROP_ACTIVE + "=:oldValue";
            Query query = session.createQuery(string);
            query.setParameter("newValue", (Object)Boolean.FALSE);
            query.setParameter("oldValue", (Object)Boolean.TRUE);
            query.executeUpdate();
            transaction.commit();
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getReferenceClass(), exception);
            return Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Terminal> findMasterTerminal(Terminal terminal) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(Terminal.class);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_MASTER_TERMINAL, (Object)true));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.ne((String)Terminal.PROP_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMasterTerminal(List<Terminal> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (list != null && !list.isEmpty()) {
                for (Terminal terminal : list) {
                    terminal.setMasterTerminal(false);
                    this.update(terminal, session);
                }
            }
            transaction.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getMasterTerminalId() {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(Terminal.class);
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_MASTER_TERMINAL, (Object)true));
            criteria.setMaxResults(1);
            Number number = (Number)criteria.uniqueResult();
            Integer n = number == null ? null : Integer.valueOf(number.intValue());
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFieldValueByTerminalKey(String string, String string2) {
        Session session = this.createNewSession();
        try {
            Criteria criteria = session.createCriteria(Terminal.class);
            criteria.setProjection((Projection)Projections.property((String)string2));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)string));
            criteria.setMaxResults(1);
            Object object = criteria.uniqueResult();
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateTerminal(List<Terminal> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Terminal terminal : list) {
                TerminalDAO terminalDAO = TerminalDAO.getInstance();
                Terminal terminal2 = terminalDAO.getByTerminalKey(terminal.getTerminalKey());
                if (terminal2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(terminal.getLastUpdateTime(), terminal2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), terminal.getName() + " already updated");
                        continue;
                    }
                    long l = terminal2.getVersion();
                    PropertyUtils.copyProperties((Object)terminal2, (Object)terminal);
                    terminal2.setVersion(l);
                    terminal2.setUpdateLastUpdateTime(bl);
                    terminal2.setUpdateSyncTime(bl2);
                    terminalDAO.update(terminal2);
                    continue;
                }
                terminal.setUpdateLastUpdateTime(bl);
                terminal.setUpdateSyncTime(bl2);
                terminalDAO.save(terminal);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getActiveTerminalKeys() {
        return this.getActiveTerminalKeys(null);
    }

    public List<String> getActiveTerminalKeys(DeviceType deviceType) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_ACTIVE, (Object)true));
            criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_DELETED, (Object)false));
            if (deviceType != null) {
                criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_DEVICE_TYPE, (Object)deviceType.getDeviceType()));
            }
            criteria.add(Restrictions.neOrIsNotNull((String)Terminal.PROP_TERMINAL_KEY, (Object)""));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_TERMINAL_KEY));
            List list = criteria.list();
            return list;
        }
    }
}

