/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.print.PosPrintService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.collections.map.HashedMap;

public class StoreSessionReportModel
extends AbstractTableModel {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd-MM-yy hh:mm a");
    private String[] b = new String[]{"openTime", "closeTime", "openedBy", "closedBy", "totalAmount", "salesTax", "totalRevenues", "creditCardReceipt", "grossReceipt", "cashAccountable"};
    private List<StoreSession> c;
    private Map<String, CashDrawer> d = new HashedMap();

    @Override
    public int getRowCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        StoreSession storeSession = this.c.get(n);
        CashDrawer cashDrawer = this.d.get(storeSession.getId());
        switch (n2) {
            case 0: {
                Date date = storeSession.getOpenTime();
                if (date == null) {
                    return "";
                }
                return a.format(date);
            }
            case 1: {
                Date date = storeSession.getCloseTime();
                if (date == null) {
                    return "";
                }
                return a.format(date);
            }
            case 2: {
                User user = storeSession.getOpenedBy();
                if (user == null) {
                    return "";
                }
                return user.getFirstName();
            }
            case 3: {
                User user = storeSession.getClosedBy();
                if (user == null) {
                    return "";
                }
                return user.getFirstName();
            }
            case 4: {
                return cashDrawer.getNetSales();
            }
            case 5: {
                return cashDrawer.getSalesTax();
            }
            case 6: {
                return cashDrawer.getTotalRevenue();
            }
            case 7: {
                return cashDrawer.getCreditCardReceiptAmount();
            }
            case 8: {
                return cashDrawer.getGrossReceipts();
            }
            case 9: {
                return cashDrawer.getDrawerAccountable();
            }
        }
        return null;
    }

    public List<StoreSession> getItems() {
        return this.c;
    }

    public void setItems(List<StoreSession> list) {
        this.c = list;
        if (list != null) {
            for (StoreSession storeSession : list) {
                List<CashDrawer> list2 = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession, null);
                if (list2 == null) continue;
                CashDrawer cashDrawer = PosPrintService.populateCashDrawerReportSummary(list2);
                this.d.put(storeSession.getId(), cashDrawer);
            }
        }
    }
}

