/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.NumberUtil;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public class SalesBalanceReportService {
    public static JasperPrint createSalesBalanceReport(Date date, Date date2, User user) throws JRException {
        ReportService reportService = new ReportService();
        SalesBalanceReport salesBalanceReport = reportService.getSalesBalanceReport(date, date2, user);
        String string = user == null ? POSConstants.ALL : user.getFullName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, null, date, date2, null);
        hashMap.put("userName", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_WITH_CLONE) + " " + string);
        hashMap.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf((int)((double)(date2.getTime() - date.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1));
        hashMap.put("grossTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getGrossTaxableSalesAmount()));
        hashMap.put("grossNonTaxableSales", NumberUtil.formatNumber(salesBalanceReport.getGrossNonTaxableSalesAmount()));
        hashMap.put("discounts", NumberUtil.formatNumber(salesBalanceReport.getDiscountAmount()));
        hashMap.put("netSales", NumberUtil.formatNumber(salesBalanceReport.getNetSalesAmount()));
        hashMap.put("salesTaxes", NumberUtil.formatNumber(salesBalanceReport.getSalesTaxAmount()));
        hashMap.put("totalRevenues", NumberUtil.formatNumber(salesBalanceReport.getTotalRevenueAmount()));
        hashMap.put("giftCertSold", NumberUtil.formatNumber(salesBalanceReport.getGiftCertSalesAmount()));
        hashMap.put("payIns", NumberUtil.formatNumber(salesBalanceReport.getPayInsAmount()));
        hashMap.put("cashTips", NumberUtil.formatNumber(salesBalanceReport.getCashTipsAmount()));
        hashMap.put("chargedTips", NumberUtil.formatNumber(salesBalanceReport.getChargedTipsAmount()));
        hashMap.put("grossReceipts", NumberUtil.formatNumber(salesBalanceReport.getGrossReceiptsAmount()));
        hashMap.put("cashReceipts", NumberUtil.formatNumber(salesBalanceReport.getCashReceiptsAmount()));
        hashMap.put("creditCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getCreditCardReceiptsAmount()));
        hashMap.put("debitCardReceipts", NumberUtil.formatNumber(salesBalanceReport.getDebitCardReceiptsAmount()));
        hashMap.put("memberPaymentReceipts", NumberUtil.formatNumber(salesBalanceReport.getMemberPaymentAmount()));
        hashMap.put("customPayment", NumberUtil.formatNumber(salesBalanceReport.getCustomPaymentAmount()));
        hashMap.put("grossTipsPaid", NumberUtil.formatNumber(salesBalanceReport.getGrossTipsPaidAmount()));
        hashMap.put("arReceipts", NumberUtil.formatNumber(salesBalanceReport.getArReceiptsAmount()));
        hashMap.put("giftCertReceipts", NumberUtil.formatNumber(salesBalanceReport.getGiftCertReceipts()));
        hashMap.put("cashBack", NumberUtil.formatNumber(salesBalanceReport.getCashBackAmount()));
        hashMap.put("cashRefund", NumberUtil.formatNumber(salesBalanceReport.getCashRefundAmount()));
        hashMap.put("receiptDiff", NumberUtil.formatNumber(salesBalanceReport.getReceiptDiffAmount()));
        hashMap.put("cashPayout", NumberUtil.formatNumber(salesBalanceReport.getCashPayoutAmount()));
        hashMap.put("cashAccountable", NumberUtil.formatNumber(salesBalanceReport.getCashAccountableAmount()));
        hashMap.put("drawerPulls", NumberUtil.formatNumber(salesBalanceReport.getDrawerPullsAmount()));
        hashMap.put("coCurrent", NumberUtil.formatNumber(salesBalanceReport.getCoCurrentAmount()));
        hashMap.put("coPrevious", NumberUtil.formatNumber(salesBalanceReport.getCoPreviousAmount()));
        hashMap.put("coOverShort", NumberUtil.formatNumber(salesBalanceReport.getOverShortAmount()));
        hashMap.put("serviceCharge", NumberUtil.formatNumber(salesBalanceReport.getServiceChargeAmnt()));
        hashMap.put("toleranceAmount", NumberUtil.formatNumber(salesBalanceReport.getToleranceAmount(), true));
        hashMap.put("visaCreditCardSum", NumberUtil.formatNumber(salesBalanceReport.getVisaCreditCardAmount()));
        hashMap.put("mastercardSum", NumberUtil.formatNumber(salesBalanceReport.getMasterCardAmount()));
        hashMap.put("amexSum", NumberUtil.formatNumber(salesBalanceReport.getAmexAmount()));
        hashMap.put("discoverySum", NumberUtil.formatNumber(salesBalanceReport.getDiscoveryAmount()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_balance_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }
}

