/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class OrderInfoDialog
extends POSDialog {
    private OrderInfoView a;
    private boolean b = false;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private JPanel h;

    public OrderInfoDialog(OrderInfoView orderInfoView) {
        this.a = orderInfoView;
        this.setTitle(Messages.getString("OrderInfoDialog.0"));
        this.createUI();
    }

    public void createUI() {
        this.add(this.a);
        this.h = new JPanel();
        this.getContentPane().add((Component)this.h, "South");
        this.c = new PosButton(Messages.getString("OrderInfoDialog.5"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketReorderAction ticketReorderAction = new TicketReorderAction(OrderInfoDialog.this.a.getTickets().get(0), UserPermission.CREATE_TICKET);
                ticketReorderAction.execute();
                if (!ticketReorderAction.isReorder()) {
                    return;
                }
                OrderInfoDialog.this.b = true;
                OrderInfoDialog.this.setCanceled(false);
                OrderInfoDialog.this.dispose();
            }
        });
        this.g = new PosButton(Messages.getString("OrderInfoDialog.6"));
        this.g.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return OrderInfoDialog.this.a.getTickets().get(0);
            }
        });
        this.h.add(this.g);
        this.h.add(this.c);
        this.d = new PosButton();
        this.d.setText(Messages.getString("OrderInfoDialog.3"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TicketTransferAction ticketTransferAction = new TicketTransferAction(OrderInfoDialog.this.a.getTickets().get(0), Application.getCurrentUser());
                    ticketTransferAction.execute();
                    if (!ticketTransferAction.isTransfered()) {
                        return;
                    }
                    OrderInfoDialog.this.a.getReportPanel().removeAll();
                    OrderInfoDialog.this.a.createReport();
                    OrderInfoDialog.this.a.revalidate();
                    OrderInfoDialog.this.a.repaint();
                    OrderInfoDialog.this.setCanceled(false);
                    OrderInfoDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(Messages.getString("MessageDialog.0"));
                    PosLog.error(this.getClass(), exception);
                }
            }
        });
        this.h.add(this.d);
        this.e = new PosButton();
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderInfoDialog.this.doPrint();
            }
        });
        this.e.setText(Messages.getString("OrderInfoDialog.1"));
        this.h.add(this.e);
        this.f = new PosButton();
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderInfoDialog.this.a();
            }
        });
        this.f.setText("Print (Driver Copy)");
        this.f.setVisible(false);
        this.h.add(this.f);
        PosButton posButton = new PosButton();
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderInfoDialog.this.dispose();
            }
        });
        posButton.setText(Messages.getString("Close"));
        this.h.add(posButton);
    }

    private void a() {
        try {
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            this.a.printCopy("Driver Copy");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    public void updateView() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(true);
        this.e.setText("Print (Customer Copy)");
    }

    protected void doPrint() {
        try {
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            this.a.printCopy("Customer Copy");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    public void setReorder(boolean bl) {
        this.b = bl;
    }

    public boolean isReorder() {
        return this.b;
    }

    public void showOnlyPrintButton() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(false);
    }

    public OrderInfoView getOrderInfoView() {
        return this.a;
    }

    public JPanel getButtonPanel() {
        return this.h;
    }
}

