/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;

public class CachedImageService {
    public static final String IMAGE_EXTENSION = "jpeg";
    private String a = System.getProperty("java.io.tmpdir") + "/orocube/pos/image-resources/";
    private static CachedImageService b;

    private CachedImageService() {
        try {
            File file = new File(this.a);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public static CachedImageService getInstance() {
        return b == null ? (b = new CachedImageService()) : b;
    }

    public String getMenuImagesDirectory() {
        return this.a;
    }

    public boolean cacheImage(ImageResource imageResource, String string) {
        boolean bl = false;
        try {
            if (string == null) {
                string = this.buildImageFileName(imageResource);
            }
            File file = new File(this.a + string);
            BufferedImage bufferedImage = new BufferedImage(imageResource.getImage().getWidth(null), imageResource.getImage().getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(imageResource.getImage(), 0, 0, null);
            graphics2D.dispose();
            ImageIO.write((RenderedImage)bufferedImage, IMAGE_EXTENSION, file);
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    public byte[] getImageAsByteArray(String string) {
        byte[] byArray = null;
        File file = new File(this.a + string);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return byArray;
    }

    public String buildImageFileName(ImageResource imageResource) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (imageResource != null) {
            stringBuilder.append(imageResource.getId());
            stringBuilder.append("_");
            stringBuilder.append(imageResource.getVersion());
            stringBuilder.append(".");
            stringBuilder.append(IMAGE_EXTENSION);
        }
        return stringBuilder.toString();
    }

    public boolean isImageCached(String string) {
        boolean bl = false;
        try {
            File file = new File(this.a + string);
            bl = file.exists();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }
}

