/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.Session;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.Rotation;

public class DashboardUtil {
    private JFreeChart a;
    private JFreeChart b;
    private JFreeChart c;
    private JFreeChart d;
    private JFreeChart e;

    public DashboardUtil() {
        this.a();
    }

    private void a() {
        TerminalDAO terminalDAO = new TerminalDAO();
        try (Session session = terminalDAO.createNewSession();){
            this.a = this.a(this.createBarChartDataSet(session));
            this.b = this.a(this.createPieChartDataSet(session));
            this.c = this.b(this.createRingChartDataSet(session));
            this.d = this.a(this.a(session));
            this.e = this.a((PieDataset)this.b(session));
        }
    }

    public JFreeChart getBarChart() {
        return this.a;
    }

    public JFreeChart getPieChart() {
        return this.b;
    }

    public JFreeChart getRingChart() {
        return this.c;
    }

    public JFreeChart getTicketInvoiceChart() {
        return this.d;
    }

    public JFreeChart getPaymentTypeChart() {
        return this.e;
    }

    private JFreeChart a(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)POSConstants.TICKET_INVOICE, (String)POSConstants.DATE, (String)POSConstants.NUMBER_OF_TICKETS, (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        categoryPlot.setOutlineVisible(false);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer(false);
        stackedBarRenderer.setBaseItemLabelsVisible(true);
        stackedBarRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        stackedBarRenderer.setMaximumBarWidth(0.05);
        jFreeChart.getCategoryPlot().setRenderer((CategoryItemRenderer)stackedBarRenderer);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.0471975511965976));
        return jFreeChart;
    }

    private JFreeChart a(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createRingChart((String)POSConstants.TOP_FIVE_PAYMENT_TYPES, (PieDataset)pieDataset, (boolean)true, (boolean)true, (boolean)false);
        RingPlot ringPlot = (RingPlot)jFreeChart.getPlot();
        ringPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        ringPlot.setSectionDepth(0.35);
        ringPlot.setOutlineVisible(false);
        ringPlot.setLabelGenerator(null);
        ringPlot.setCircular(true);
        ringPlot.setShadowPaint(null);
        ringPlot.setSectionOutlinesVisible(false);
        ringPlot.setLabelGap(0.05);
        ringPlot.setStartAngle(60.0);
        ringPlot.setDirection(Rotation.CLOCKWISE);
        ringPlot.setSeparatorsVisible(false);
        ringPlot.setIgnoreZeroValues(true);
        ringPlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(CurrencyUtil.getCurrencySymbol() + "{1}"));
        return jFreeChart;
    }

    private JFreeChart b(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createRingChart((String)POSConstants.TOP_FIVE_EMPLOYEES, (PieDataset)pieDataset, (boolean)false, (boolean)true, (boolean)true);
        RingPlot ringPlot = (RingPlot)jFreeChart.getPlot();
        ringPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        ringPlot.setSectionDepth(0.5);
        ringPlot.setOutlineVisible(false);
        ringPlot.setCircular(true);
        ringPlot.setShadowPaint(null);
        ringPlot.setSectionOutlinesVisible(false);
        ringPlot.setLabelGap(0.02);
        ringPlot.setStartAngle(290.0);
        ringPlot.setDirection(Rotation.ANTICLOCKWISE);
        ringPlot.setSeparatorsVisible(false);
        ringPlot.setIgnoreZeroValues(true);
        return jFreeChart;
    }

    private JFreeChart a(DefaultPieDataset defaultPieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D((String)POSConstants.TOP_TEN_ITEMS, (PieDataset)defaultPieDataset, (boolean)false, (boolean)true, (boolean)true);
        PiePlot3D piePlot3D = (PiePlot3D)jFreeChart.getPlot();
        piePlot3D.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        piePlot3D.setStartAngle(290.0);
        piePlot3D.setDirection(Rotation.CLOCKWISE);
        piePlot3D.setOutlineVisible(false);
        return jFreeChart;
    }

    private JFreeChart a(DefaultCategoryDataset defaultCategoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)POSConstants.SALES_REPORT_BY_DATE, (String)POSConstants.DATE, (String)(POSConstants.SALES + CurrencyUtil.getCurrencySymbolWithBracket()), (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage(Messages.getString("DashboardUtil.0"));
        categoryPlot.setOutlineVisible(false);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(false);
        stackedBarRenderer3D.setMaximumBarWidth(0.02);
        stackedBarRenderer3D.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        stackedBarRenderer3D.setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER));
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.0471975511965976));
        return jFreeChart;
    }

    private CategoryDataset a(Session session) {
        Map<String, Integer> map;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(5, -6);
        Date date2 = calendar.getTime();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        List<Date> list = TicketDAO.getInstance().findTicketWithinDate(date2, date, session);
        if (list != null && !(map = ReportService.prepareTicketForDashBoard(list)).isEmpty()) {
            map.keySet().forEach(string -> {
                Integer n = (Integer)map.get(string);
                defaultCategoryDataset.addValue((Number)n, (Comparable)n, (Comparable)((Object)string));
            });
        }
        return defaultCategoryDataset;
    }

    private DefaultPieDataset b(Session session) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(5, -6);
        Date date2 = calendar.getTime();
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        Map<PaymentType, PosTransaction> map = PosTransactionDAO.getInstance().findAmountByPaymentTypes(session, date2, date, Integer.MAX_VALUE);
        if (!map.isEmpty()) {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(map.values());
            Collections.sort(arrayList, (posTransaction, posTransaction2) -> posTransaction.getPaymentTypeString().compareTo(posTransaction2.getPaymentTypeString()));
            arrayList.forEach(posTransaction -> {
                Double d = Math.round(posTransaction.getAmount());
                defaultPieDataset.setValue((Comparable)((Object)posTransaction.getPaymentTypeString()), (Number)d);
            });
        }
        return defaultPieDataset;
    }

    public DefaultCategoryDataset createBarChartDataSet(Session session) {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        calendar.add(5, -14);
        Date date3 = calendar.getTime();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Map<Date, Double> map = PosTransactionDAO.getInstance().findTransactionsAmntGroupByDate(date3, date2, session);
        if (map != null) {
            map.keySet().forEach(date -> {
                Double d = Math.round((Double)map.get(date));
                defaultCategoryDataset.addValue((Number)d, (Comparable)d, (Comparable)((Object)DateUtil.formatAsDefaultMonthDate(date)));
            });
        }
        return defaultCategoryDataset;
    }

    public DefaultPieDataset createPieChartDataSet(Session session) {
        SalesReportModel salesReportModel;
        List<ReportItem> list;
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(5, -14);
        Date date2 = calendar.getTime();
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        List<TicketItem> list2 = TicketItemDAO.getInstance().findTicketItemWithinDateForDashboard(date2, date, Integer.MAX_VALUE, Boolean.FALSE, session);
        if (list2 != null && (list = (salesReportModel = ReportService.prepareItemSalesReportModel(list2)).getItems()) != null) {
            list.forEach(reportItem -> reportItem.setQuantity(Math.abs(reportItem.getQuantity())));
            Collections.sort(list, (reportItem, reportItem2) -> new Double(reportItem2.getQuantity()).compareTo(new Double(reportItem.getQuantity())));
            for (int i = 0; i < 10 && i < list.size(); ++i) {
                defaultPieDataset.setValue((Comparable)((Object)list.get(i).getName()), list.get(i).getQuantity());
            }
        }
        return defaultPieDataset;
    }

    public PieDataset createRingChartDataSet(Session session) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(5, -6);
        Date date2 = calendar.getTime();
        TreeMap<PosTransaction, User> treeMap = new TreeMap<PosTransaction, User>(new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getAmount().compareTo(posTransaction2.getAmount());
            }
        });
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        Map<PosTransaction, User> map = UserDAO.getInstance().findTopSellers(session, date2, date, 5);
        treeMap.putAll(map);
        if (treeMap != null) {
            ArrayList arrayList = new ArrayList(treeMap.keySet());
            for (int i = 0; i < treeMap.size(); ++i) {
                defaultPieDataset.setValue((Comparable)((Object)((User)treeMap.get(arrayList.get(i))).getFullName()), (Number)((PosTransaction)arrayList.get(i)).getAmount());
            }
        }
        return defaultPieDataset;
    }
}

