/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.SplitTicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ManuallySplitTicketDialog;
import com.floreantpos.ui.views.SplitTypeSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SplitTicketAction
extends PosAction {
    private Ticket a;
    private boolean b = false;

    public SplitTicketAction() {
        super(POSConstants.SPLIT_TICKET);
    }

    public SplitTicketAction(boolean bl) {
        super(POSConstants.SPLIT_TICKET);
        this.b = bl;
    }

    public SplitTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, dataChangeListener);
    }

    public SplitTicketAction(DataChangeListener dataChangeListener, boolean bl) {
        super(POSConstants.SPLIT_TICKET_BUTTON_TEXT, dataChangeListener);
        this.b = bl;
    }

    public SplitTicketAction(Ticket ticket) {
        super(POSConstants.SPLIT_TICKET);
        this.a = ticket;
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null || this.a.getTicketItems() == null || this.a.getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            if (this.a.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            if (StringUtils.isNotEmpty((String)this.a.getId())) {
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            }
            if (((BaseTicket)(object = (Ticket)CopyUtil.deepCopy(this.a))).getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SplitTicketAction.2"));
                return;
            }
            if (((BaseTicket)object).getGratuity() != null) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SplitTicketAction.4"));
                return;
            }
            if (this.a((Ticket)object) && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.5"), POSConstants.CONFIRM) != 0) {
                return;
            }
            SplitTypeSelectionDialog splitTypeSelectionDialog = new SplitTypeSelectionDialog((Ticket)object);
            splitTypeSelectionDialog.pack();
            splitTypeSelectionDialog.open();
            if (splitTypeSelectionDialog.isCanceled()) {
                return;
            }
            int n = splitTypeSelectionDialog.getSelectedSplitType();
            List<Ticket> list = this.a(n, (Ticket)object);
            if (list != null) {
                boolean bl = false;
                for (Ticket ticket : list) {
                    if (!StringUtils.isNotEmpty((String)ticket.getId())) continue;
                    bl = true;
                }
                if (!bl) {
                    object = this.a;
                }
            }
            if (this.listener != null) {
                this.listener.dataChanged(object);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private boolean a(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getDiscounts() == null || ticketItem.getDiscounts().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Ticket> a(int n, Ticket ticket) throws Exception {
        List<Ticket> list = null;
        if (n == 0) {
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("SplitTicketAction.3"));
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return null;
            }
            int n2 = (int)numberSelectionDialog2.getValue();
            if (n2 > 0) {
                list = SplitTicketService.doEquallySplit(ticket, n2);
                ticket.addProperty("SPLIT_TYPE", String.valueOf(0));
            }
        } else if (n == 1) {
            list = SplitTicketService.doSplitBySeatNumber(ticket);
            ticket.addProperty("SPLIT_TYPE", String.valueOf(1));
        } else {
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
            numberSelectionDialog2.setTitle(Messages.getString("SplitTicketAction.3"));
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return null;
            }
            int n3 = (int)numberSelectionDialog2.getValue();
            if (n3 <= 1) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.6"));
                return null;
            }
            ManuallySplitTicketDialog manuallySplitTicketDialog = new ManuallySplitTicketDialog();
            manuallySplitTicketDialog.allowCustomerSelection(this.b);
            manuallySplitTicketDialog.setTicket(ticket, n3);
            manuallySplitTicketDialog.open();
            if (manuallySplitTicketDialog.isCanceled()) {
                if (StringUtils.isNotEmpty((String)ticket.getId())) {
                    ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                }
                return null;
            }
            list = manuallySplitTicketDialog.getSplitTickets();
            ticket.addProperty("SPLIT_TYPE", String.valueOf(2));
        }
        if (list == null || list.isEmpty() || list.size() == 1) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SplitTicketAction.7"));
            return null;
        }
        this.a(list);
        return list;
    }

    private void a(List<Ticket> list) {
        SplitedTicketSelectionDialog splitedTicketSelectionDialog = new SplitedTicketSelectionDialog(list);
        splitedTicketSelectionDialog.setDefaultCloseOperation(2);
        splitedTicketSelectionDialog.allowCustomerSelection(this.b);
        splitedTicketSelectionDialog.setSize(PosUIManager.getSize(800, 600));
        splitedTicketSelectionDialog.open();
    }
}

