/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.GiftCardExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class GiftCardBrowserAction
extends AbstractAction {
    public GiftCardBrowserAction() {
        super(Messages.getString("GiftCardBrowserAction.0"));
    }

    public GiftCardBrowserAction(String string) {
        super(string);
    }

    public GiftCardBrowserAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            GiftCardExplorer giftCardExplorer;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(Messages.getString("GiftCardBrowserAction.1"));
            if (n == -1) {
                giftCardExplorer = new GiftCardExplorer();
                jTabbedPane.addTab(Messages.getString("GiftCardBrowserAction.1"), giftCardExplorer);
            } else {
                giftCardExplorer = (GiftCardExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(giftCardExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

