/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.MenuUsageReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class MenuUsageReportAction
extends AbstractAction {
    public MenuUsageReportAction() {
        super(POSConstants.MENU_USAGE_REPORT);
    }

    public MenuUsageReportAction(String string) {
        super(string);
    }

    public MenuUsageReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            MenuUsageReportView menuUsageReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.MENU_USAGE_REPORT);
            if (n == -1) {
                menuUsageReportView = new MenuUsageReportView();
                jTabbedPane.addTab(POSConstants.MENU_USAGE_REPORT, menuUsageReportView);
            } else {
                menuUsageReportView = (MenuUsageReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(menuUsageReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

