/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesignView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuPageForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class MenuPageDesigner
extends TransparentPanel
implements PageSelectionListener,
RefreshableView {
    private JList<MenuCategory> a;
    private JList<MenuGroup> b;
    private JComboBox<Object> c;
    private MenuPageDesignView d;
    private JList<MenuPage> e;
    private ComboBoxModel f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;
    private JButton n;
    private JButton o;
    private JButton p;
    private JButton q;

    public MenuPageDesigner() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(PosUIManager.getSize(300, 0));
        jPanel2.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.0")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(PosUIManager.getSize(130, 82));
        this.add((Component)jPanel3, "East");
        this.a = new JList(new ComboBoxModel());
        this.a.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.e();
            }
        });
        this.b = new JList(new ComboBoxModel());
        this.b.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.f();
            }
        });
        this.c = new JComboBox(new ComboBoxModel());
        this.c.setMinimumSize(PosUIManager.getSize(150, 25));
        this.c.addItem(POSConstants.ALL);
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        if (list != null && list.size() > 0) {
            for (OrderType serializable2 : list) {
                this.c.addItem(serializable2);
            }
        }
        this.c.setSelectedIndex(0);
        this.o = new JButton(Messages.getString("MenuPageDesigner.1"));
        this.p = new JButton(Messages.getString("MenuPageDesigner.1"));
        this.k = new JButton(Messages.getString("MenuPageDesigner.3"));
        this.l = new JButton(Messages.getString("MenuPageDesigner.4"));
        this.j = new JButton(Messages.getString("MenuPageDesigner.5"));
        this.n = new JButton(Messages.getString("MenuPageDesigner.6"));
        this.m = new JButton(Messages.getString("MenuPageDesigner.7"));
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.c();
            }
        });
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.d();
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPage menuPage = (MenuPage)MenuPageDesigner.this.e.getSelectedValue();
                if (menuPage == null) {
                    return;
                }
                menuPage.setVisible(menuPage.isVisible() == false);
                MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                MenuPageDesigner.this.j.setText(menuPage.isVisible() != false ? Messages.getString("MenuPageDesigner.8") : Messages.getString("MenuPageDesigner.9"));
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.j();
            }
        });
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.k();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.n();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.p();
            }
        });
        this.i = new JButton(Messages.getString("MenuPageDesigner.10"));
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.m();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.11")));
        jPanel.add((Component)jScrollPane, String.format("grow, h %s", 200));
        JScrollPane jScrollPane2 = new JScrollPane(this.b);
        jScrollPane2.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.13")));
        jPanel.add((Component)jScrollPane2, String.format("newline, grow, h %s", 200));
        this.f = new ComboBoxModel();
        this.e = new JList(this.f);
        this.e.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.i();
            }
        });
        JScrollPane jScrollPane3 = new JScrollPane(this.e);
        jScrollPane3.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.15")));
        jPanel.add((Component)jScrollPane3, String.format("newline, grow, wrap", new Object[0]));
        jPanel2.add(jPanel);
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel4.add((Component)this.i, "growx");
        jPanel4.add((Component)this.k, "growx");
        jPanel4.add((Component)this.l, "growx,wrap");
        jPanel4.add((Component)this.j, "growx");
        jPanel4.add((Component)this.n, "growx");
        jPanel4.add((Component)this.m, "growx");
        this.m.setEnabled(false);
        jPanel2.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.d = new MenuPageDesignView();
        this.d.setPageListener(this);
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx"));
        JButton jButton = new JButton(Messages.getString("MenuPageDesigner.25"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.l();
            }
        });
        this.g = new JButton(Messages.getString("MenuPageDesigner.26"));
        this.g.setEnabled(false);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.doSaveMenuPage();
            }
        });
        this.h = new JButton(Messages.getString("Cancel"));
        this.h.setEnabled(false);
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPage menuPage = (MenuPage)MenuPageDesigner.this.e.getSelectedValue();
                menuPage = MenuPageDAO.getInstance().get(menuPage.getId());
                MenuPageDesigner.this.b(menuPage);
                MenuPageDesigner.this.h.setEnabled(false);
                MenuPageDesigner.this.g.setEnabled(false);
                MenuPageDesigner.this.d.setMenuPage(menuPage);
            }
        });
        this.q = new JButton(Messages.getString("MenuPageDesigner.28"));
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.q();
            }
        });
        jPanel6.add((Component)new JSeparator(), "grow,span");
        jPanel6.add((Component)this.g, "split 4");
        jPanel6.add(this.h);
        jPanel6.add(this.q);
        this.d.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel((LayoutManager)new MigLayout("center"));
        jPanel7.add((Component)new JLabel(POSConstants.ORDER_TYPE), "split 2");
        jPanel7.add(this.c);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel7, "North");
        jPanel8.add(this.d);
        jPanel5.add(jPanel8);
        this.add((Component)jPanel2, "West");
        this.add(jPanel5);
        this.a(false);
        this.c.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                MenuPageDesigner.this.g.setEnabled(true);
                MenuPageDesigner.this.h.setEnabled(true);
            }
        });
    }

    private void b() {
        if (this.g.isEnabled()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.31"), Messages.getString("CONFIRM")) == 0) {
                this.doSaveMenuPage();
            } else {
                this.d.resetPage();
                this.g.setEnabled(false);
                this.h.setEnabled(false);
            }
        }
    }

    protected void doSaveMenuPage() {
        MenuPage menuPage = this.e.getSelectedValue();
        try {
            this.a(menuPage);
            menuPage.setOrderTypeId(this.g());
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.g.setEnabled(false);
            this.h.setEnabled(false);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void a(MenuPage menuPage) {
        List<MenuPageItem> list = menuPage.getPageItems();
        if (list != null) {
            Iterator<MenuPageItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                MenuPageItem menuPageItem = iterator.next();
                if (menuPageItem.getMenuItemId() != null) continue;
                iterator.remove();
            }
        }
    }

    private void c() {
        try {
            MenuPage menuPage = this.e.getSelectedValue();
            if (menuPage == null) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.33"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            MenuPageDAO.getInstance().delete(menuPage);
            this.f.removeElement(menuPage);
            if (this.f.getSize() > 0) {
                this.e.setSelectedIndex(this.f.getSize() - 1);
            } else {
                this.i();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    private void d() {
        try {
            List list = this.f.getDataList();
            if (list == null || list.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.35") + this.b.getSelectedValue() + Messages.getString("MenuPageDesigner.36"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            MenuPageDAO.getInstance().deleteAll(list);
            this.f.removeAllElements();
            this.m.setEnabled(false);
            this.i();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void initData() {
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
        comboBoxModel.setDataList(list);
    }

    private void e() {
        MenuCategory menuCategory = this.a.getSelectedValue();
        if (menuCategory == null) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
        comboBoxModel.removeAllElements();
        this.f.removeAllElements();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
        if (list != null) {
            comboBoxModel.setDataList(list);
            if (list.size() > 0) {
                this.b.setSelectedIndex(0);
            }
        }
        this.e.setSelectedValue(null, false);
        this.d.reset();
        this.d.revalidate();
        this.d.repaint();
    }

    private void f() {
        this.f.removeAllElements();
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup != null) {
            List<MenuPage> list = MenuPageDAO.getInstance().findByGroup(menuGroup);
            if (list != null && list.size() > 0) {
                this.f.setDataList(list);
                this.m.setEnabled(true);
            } else {
                this.m.setEnabled(false);
            }
        }
        this.i();
    }

    private String g() {
        OrderType orderType = this.h();
        if (orderType == null) {
            return null;
        }
        return orderType.getId();
    }

    private OrderType h() {
        Object object = this.c.getSelectedItem();
        OrderType orderType = null;
        if (object instanceof OrderType) {
            orderType = (OrderType)object;
        }
        return orderType;
    }

    private void i() {
        MenuPage menuPage = null;
        if (this.f.getSize() > 0) {
            menuPage = this.e.getSelectedValue();
            if (menuPage != null) {
                this.j.setText(menuPage.isVisible() != false ? Messages.getString("MenuPageDesigner.38") : Messages.getString("MenuPageDesigner.39"));
                this.a(true);
                this.m.setEnabled(true);
                this.b(menuPage);
                this.g.setEnabled(false);
                this.h.setEnabled(false);
            } else {
                this.a(false);
            }
        } else {
            this.a(false);
        }
        this.d.setMenuPage(menuPage);
    }

    private void b(MenuPage menuPage) {
        String string = menuPage.getOrderTypeId();
        if (StringUtils.isEmpty((String)string)) {
            this.c.setSelectedItem(POSConstants.ALL);
        } else {
            this.c.setSelectedItem(DataProvider.get().getOrderType(string));
        }
    }

    private void a(boolean bl) {
        this.l.setEnabled(bl);
        this.j.setEnabled(bl);
        this.n.setEnabled(bl);
        this.q.setEnabled(bl);
    }

    public void doCreateNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.40"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        int n = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("MenuPageDesigner.42"));
        if (n < 1) {
            return;
        }
        ArrayList<MenuPage> arrayList = new ArrayList<MenuPage>();
        for (int i = 0; i < n; ++i) {
            MenuPage menuPage = new MenuPage();
            menuPage.setName("Page " + (i + 1));
            arrayList.add(menuPage);
        }
        try {
            MenuPageDAO.getInstance().saveOrUpdatePages(arrayList);
            this.f.setDataList(arrayList);
            this.e.setSelectedIndex(0);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    protected List<MenuItem> getSelectedMenuItems(List<MenuItem> list) {
        MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
        menuItemSelectionDialog.setSelectionMode(1);
        menuItemSelectionDialog.setSize(PosUIManager.getSize(750, 515));
        menuItemSelectionDialog.open();
        if (menuItemSelectionDialog.isCanceled()) {
            return null;
        }
        List<MenuItem> list2 = menuItemSelectionDialog.getSelectedItems();
        MenuPage menuPage = this.e.getSelectedValue();
        int n = menuPage.getCols() * menuPage.getRows();
        if (list2 != null && list2.size() > n) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.44") + n);
            return this.getSelectedMenuItems(list2);
        }
        return list2;
    }

    private void j() {
        try {
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
            comboBoxModel.addElement(menuCategory);
            this.a.setSelectedValue(menuCategory, true);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void k() {
        try {
            MenuGroup menuGroup = new MenuGroup();
            MenuCategory menuCategory = this.a.getSelectedValue();
            if (menuCategory != null) {
                menuGroup.setMenuCategoryId(menuCategory.getId());
            } else {
                menuGroup.setMenuCategoryId(null);
            }
            MenuGroupForm menuGroupForm = new MenuGroupForm(menuGroup);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuGroup menuGroup2 = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
            comboBoxModel.addElement(menuGroup2);
            this.a.setSelectedValue(menuGroup2, true);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void l() {
        Serializable serializable;
        Object object;
        MenuPage menuPage = this.e.getSelectedValue();
        if (menuPage == null) {
            POSMessageDialog.showMessage(Messages.getString("MenuPageDesigner.45"));
            return;
        }
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        if (menuPage.getPageItems() != null) {
            object = menuPage.getPageItems().iterator();
            while (object.hasNext()) {
                serializable = (MenuPageItem)object.next();
                if (((MenuPageItem)serializable).getMenuItem() == null) continue;
                hashMap.put(((MenuPageItem)serializable).getMenuItem().getId(), serializable);
                arrayList.add(((MenuPageItem)serializable).getMenuItem());
            }
        }
        if ((object = this.getSelectedMenuItems(arrayList)) == null) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        serializable = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = (MenuItem)iterator.next();
            MenuPageItem menuPageItem = (MenuPageItem)hashMap.get(menuItem.getId());
            if (menuPageItem == null) {
                menuPageItem = new MenuPageItem();
                menuPageItem.setMenuItem(menuItem);
                menuPageItem.setMenuPage(menuPage);
                serializable.add(menuPageItem);
                continue;
            }
            menuPage.addTopageItems(menuPageItem);
        }
        this.g.setEnabled(true);
        this.h.setEnabled(true);
        this.d.fillSelectedPageItems((List<MenuPageItem>)((Object)serializable));
    }

    private void m() {
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.46"));
            return;
        }
        List<MenuItem> list = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
        if (list == null || list.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.47"));
            return;
        }
        MenuPageForm menuPageForm = new MenuPageForm(new MenuPage(), true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuPage menuPage = (MenuPage)menuPageForm.getBean();
        int n = menuPage.getRows();
        int n2 = menuPage.getCols();
        int n3 = list.size();
        int n4 = (int)Math.ceil((double)n3 / (double)(n2 * n));
        int n5 = n4 == 0 ? 1 : n4;
        ArrayList<MenuPageItem> arrayList = new ArrayList<MenuPageItem>();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            try {
                int n8;
                int n9;
                int n10 = this.f.getSize();
                MenuPage menuPage2 = null;
                if (menuPage2 == null) {
                    menuPage2 = new MenuPage();
                    menuPage2.setMenuGroupId(menuGroup.getId());
                    menuPage2.setName(Messages.getString("MenuPageDesigner.48") + (n10 + 1));
                    menuPage2.setRows(n);
                    menuPage2.setCols(n2);
                    menuPage2.setSortOrder(i);
                    menuPage2.setFlixibleButtonSize(menuPage.isFlixibleButtonSize());
                    menuPage2.setButtonHeight(menuPage.getButtonHeight());
                    menuPage2.setButtonWidth(menuPage.getButtonWidth());
                    MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                    this.f.addElement(menuPage2);
                }
                if (n3 < (n9 = n2 * n)) {
                    while (n6 < list.size()) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n6;
                    }
                } else {
                    n8 = 0;
                    while (n8 < n9) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n8;
                        ++n6;
                    }
                }
                n3 -= n9;
                for (n8 = 0; n8 < n; ++n8) {
                    for (int j = 0; j < n2 && n7 <= arrayList.size() - 1 && arrayList.get(n7) != null; ++n7, ++j) {
                        ((MenuPageItem)arrayList.get(n7)).setRow(n8);
                        ((MenuPageItem)arrayList.get(n7)).setCol(j);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                this.e.setSelectedValue(menuPage2, true);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BOMessageDialog.showError(exception.getMessage());
            }
        }
        this.d.repaint();
        this.d.revalidate();
    }

    private void n() {
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.49"));
            return;
        }
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setCols(4);
            menuPage.setRows(4);
            int n = this.o();
            menuPage.setName("Page " + n);
            menuPage.setSortOrder(n);
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.f.addElement(menuPage);
            this.e.setSelectedValue(menuPage, true);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private int o() {
        Serializable serializable;
        String string = "";
        if (this.f.getSize() > 0) {
            serializable = (MenuPage)this.f.getElementAt(this.f.getSize() - 1);
            string = ((BaseMenuPage)serializable).getName();
        }
        serializable = Pattern.compile(".* ([0-9]+)");
        Matcher matcher = ((Pattern)serializable).matcher(string);
        int n = this.f.getSize() + 1;
        if (matcher.find()) {
            try {
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 + 1 > n) {
                    n = n2 + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private void p() {
        MenuPage menuPage = this.e.getSelectedValue();
        if (menuPage == null) {
            return;
        }
        MenuPageForm menuPageForm = new MenuPageForm(menuPage, false);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuPage menuPage2 = (MenuPage)menuPageForm.getBean();
        MenuPageDAO menuPageDAO = new MenuPageDAO();
        menuPageDAO.saveOrUpdate(menuPage2);
        this.e.setSelectedValue(menuPage2, true);
        this.i();
    }

    private void q() {
        MenuPage menuPage = this.e.getSelectedValue();
        if (menuPage == null || menuPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.53"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.54"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        MenuPageDAO.getInstance().saveOrUpdate(menuPage);
        this.d.setMenuPage(menuPage);
    }

    @Override
    public void itemSelected(Object object) {
        this.g.setEnabled(true);
        this.h.setEnabled(true);
    }

    @Override
    public void refresh() {
        MenuPage menuPage = this.d.getMenuPage();
        MenuPage menuPage2 = MenuPageDAO.getInstance().get(menuPage.getId());
        this.d.setMenuPage(menuPage2);
    }

    @Override
    public void uiUpdate() {
        this.g.setEnabled(true);
        this.h.setEnabled(true);
    }
}

