/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LabelConfigurationView
extends TransparentPanel {
    private Store a;
    private JCheckBox b;
    private JCheckBox c;
    private JCheckBox d;
    private JComboBox<PriceTable> e;
    private JLabel f;
    private PosButton g;

    public LabelConfigurationView() {
        this.c();
        this.a();
        this.updateView();
        this.b();
    }

    private void a() {
        ArrayList<PriceTable> arrayList = new ArrayList<PriceTable>();
        arrayList.add(null);
        arrayList.addAll(PriceTableDAO.getInstance().findAll());
        this.e.setModel(new ComboBoxModel(arrayList));
    }

    private void b() {
        this.d.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                LabelConfigurationView.this.e.setVisible(jCheckBox.isSelected());
                LabelConfigurationView.this.f.setVisible(jCheckBox.isSelected());
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LabelConfigurationView.this.save();
            }
        });
    }

    private void c() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 31);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("LabelConfigurationView.3"), 2, 0);
        jPanel.setBorder(titledBorder);
        this.b = new JCheckBox(Messages.getString("LabelConfigurationView.4"));
        this.c = new JCheckBox(Messages.getString("LabelConfigurationView.5"));
        this.d = new JCheckBox(Messages.getString("LabelConfigurationView.6"));
        this.e = new JComboBox();
        this.f = new JLabel(Messages.getString("LabelConfigurationView.7"));
        jPanel.add((Component)this.b, "wrap");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)this.d, "wrap");
        jPanel.add((Component)this.f, "gapleft 20");
        jPanel.add(this.e, "w 100!");
        this.e.setVisible(false);
        this.f.setVisible(false);
        jScrollPane.setBorder(null);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center"));
        this.g = new PosButton(Messages.getString("LabelConfigurationView.14"));
        jPanel2.add(this.g);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            StoreDAO.getInstance().saveOrUpdate(this.a);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("LabelConfigurationView.15"));
            return true;
        }
        catch (Exception exception) {
            PosLog.error(LabelConfigurationView.class, exception.getMessage(), exception);
            POSMessageDialog.showError(exception.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            this.a = Application.getInstance().getStore();
            boolean bl = this.a.getProperty("label.barcode") == null ? true : Boolean.valueOf(this.a.getProperty("label.barcode"));
            boolean bl2 = this.a.getProperty("label.member.price") == null ? true : Boolean.valueOf(this.a.getProperty("label.member.price"));
            boolean bl3 = this.a.getProperty("label.isPrint.retail.price") == null ? true : Boolean.valueOf(this.a.getProperty("label.isPrint.retail.price"));
            String string = this.a.getProperty("label.retail.price");
            this.b.setSelected(bl);
            this.c.setSelected(bl2);
            this.d.setSelected(bl3);
            this.f.setVisible(bl3);
            this.e.setVisible(bl3);
            if (StringUtils.isNotEmpty((String)string)) {
                PriceTable priceTable = PriceTableDAO.getInstance().get(string);
                this.e.setSelectedItem(priceTable);
            }
        }
        catch (Exception exception) {
            PosLog.error(LabelConfigurationView.class, exception);
        }
    }

    public boolean updateModel() {
        try {
            boolean bl = this.b.isSelected();
            boolean bl2 = this.c.isSelected();
            boolean bl3 = this.d.isSelected();
            PriceTable priceTable = (PriceTable)this.e.getSelectedItem();
            this.a.addProperty("label.barcode", String.valueOf(bl));
            this.a.addProperty("label.member.price", String.valueOf(bl2));
            this.a.addProperty("label.isPrint.retail.price", String.valueOf(bl3));
            this.a.addProperty("label.retail.price", priceTable.getId());
        }
        catch (Exception exception) {
            PosLog.error(LabelConfigurationView.class, exception.getMessage(), exception);
        }
        return true;
    }

    @Override
    public String getName() {
        return Messages.getString("LabelConfigurationView.16");
    }
}

