/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutoLogOffAlertDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PosWindow
extends JFrame
implements WindowListener {
    private static final String a = "extendedstate";
    private static final String b = "wlocy";
    private static final String c = "wlocx";
    private static final String d = "wheight";
    private static final String e = "wwidth";
    private GlassPane f;
    private JLabel g;
    private static final SimpleDateFormat h = new SimpleDateFormat("hh:mm:ss aaa");
    private JLabel i;
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private Timer o;
    private Timer p;
    private Timer q;
    private AutoLogoffHandler r;

    public void initComponents() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.f = new GlassPane();
        this.f.setOpacity(0.6f);
        this.setGlassPane(this.f);
        this.g = new JLabel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(0), "North");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 5 3 5 5", "[][][]", "[]"));
        jPanel2.setOpaque(true);
        Font font = this.g.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.i = new JLabel();
        this.k = new JLabel(Messages.getString("PosWindow.3") + TerminalConfig.getTerminalId());
        this.j = new JLabel();
        this.l = new JLabel();
        this.m = new JLabel("");
        this.m.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.n = new JLabel("");
        this.n.setForeground(Color.RED);
        this.i.setFont(font);
        this.j.setFont(font);
        this.k.setFont(font);
        this.l.setFont(font);
        this.m.setFont(font);
        this.n.setFont(font);
        jPanel2.add(this.i);
        jPanel2.add(this.k);
        jPanel2.add(this.j);
        jPanel2.add((Component)this.l, "grow");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("right, filly, ins 0 0 0 0"));
        jPanel3.add(this.n);
        jPanel3.add((Component)new JSeparator(1), "growy");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)this.m, "East");
        this.getContentPane().add((Component)jPanel, "South");
        this.a();
    }

    public void initTimers() {
        this.o = new Timer(1000, new ClockTimerHandler());
        this.o.start();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.q = new Timer(900000, new UpdateCheckHandler());
            this.q.start();
        }
    }

    private void a() {
        this.addWindowListener(this);
        this.n.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PosWindow.this.e();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                PosWindow.this.n.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                PosWindow.this.n.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void rendererUserInfo() {
        User user = Application.getCurrentUser();
        if (user != null) {
            this.j.setText(Messages.getString("PosWindow.6") + user.getFullName() + " (" + user.getType().getName() + ")");
        } else {
            this.j.setText("");
        }
    }

    public void setRestaurantName(String string) {
        this.i.setText(string);
    }

    public void setStatus(String string) {
        this.g.setText(string);
    }

    public void setupSizeAndLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(AppConfig.getInt(e, (int)dimension.getWidth()), AppConfig.getInt(d, (int)dimension.getHeight()));
        this.setLocation(AppConfig.getInt(c, dimension.width - this.getWidth() >> 1), AppConfig.getInt(b, dimension.height - this.getHeight() >> 1));
        this.setMinimumSize(new Dimension(1024, 724));
        this.setDefaultCloseOperation(0);
        int n = AppConfig.getInt(a, -1);
        if (n != -1) {
            this.setExtendedState(n);
        }
    }

    public void enterFullScreenMode() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.setLocation(0, 0);
    }

    public void leaveFullScreenMode() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        this.setUndecorated(false);
        graphicsDevice.setFullScreenWindow(null);
    }

    public void saveSizeAndLocation() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        AppConfig.putInt(e, n);
        AppConfig.putInt(d, n2);
        Point point = this.getLocationOnScreen();
        AppConfig.putInt(c, point.x);
        AppConfig.putInt(b, point.y);
        AppConfig.putInt(a, this.getExtendedState());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.b();
        } else {
            this.c();
        }
    }

    private void b() {
        if (this.o != null) {
            this.o.start();
        }
    }

    private void c() {
        if (this.o != null) {
            this.o.stop();
        }
    }

    public void startAutoLogoffTimer() {
        Terminal terminal;
        if (this.r == null) {
            this.r = new AutoLogoffHandler();
        }
        if ((terminal = Application.getInstance().getTerminal()) != null && terminal.isIsAutoLogOffEnabled().booleanValue()) {
            this.p = new Timer(terminal.getAutoLogOffSec() * 1000, this.r);
            this.p.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.r, 56L);
        }
    }

    public void stopAutoLogoffTimer() {
        if (this.p != null) {
            this.p.stop();
            this.p = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.r);
        }
    }

    private void d() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(h.format(Calendar.getInstance().getTime()));
        this.m.setText(stringBuilder.toString());
    }

    public void checkForUpdate() {
        UpdateManager updateManager = Application.getInstance().getUpdateManager();
        if (!updateManager.isUpdateAvailble()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("PosWindow.0"));
        this.n.setText(stringBuilder.toString());
        if (this.q != null) {
            this.q.stop();
        }
    }

    public void setGlassPaneVisible(boolean bl) {
        this.f.setVisible(bl);
    }

    public void updateView() {
        this.k.setText(Messages.getString("PosWindow.10") + TerminalConfig.getTerminalId());
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (Application.getCurrentUser() != null) {
            new ShutDownAction().actionPerformed(null);
        } else {
            Application.getInstance().shutdownPOS();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void e() {
        try {
            if (this.q != null && this.q.isRunning()) {
                this.q.stop();
            }
            Application.getInstance().checkForUpdate();
            if (this.q != null) {
                this.q.start();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private class AutoLogoffHandler
    implements AWTEventListener,
    ActionListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            this.reset();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PosWindow.this.p.stop();
            if (!PosWindow.this.isShowing()) {
                return;
            }
            if (PosGuiUtil.isModalDialogShowing()) {
                this.reset();
                return;
            }
            AutoLogOffAlertDialog autoLogOffAlertDialog = new AutoLogOffAlertDialog();
            autoLogOffAlertDialog.pack();
            autoLogOffAlertDialog.open();
            if (autoLogOffAlertDialog.isCanceled()) {
                this.reset();
                return;
            }
            Application.getInstance().doAutoLogout();
        }

        public void reset() {
            if (PosWindow.this.p != null) {
                PosWindow.this.p.restart();
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(PosWindow.this.r);
            }
        }
    }

    private class UpdateCheckHandler
    implements ActionListener {
        private UpdateCheckHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PosWindow.this.checkForUpdate();
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PosWindow.this.isShowing()) {
                PosWindow.this.o.stop();
                return;
            }
            PosWindow.this.d();
        }
    }
}

