/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.base.BasePriceShift;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"dayOfWeekAsString", "formattedStartTime", "formattedEndTime"})
@XmlRootElement
public class PriceShift
extends BasePriceShift {
    private static final long serialVersionUID = 1L;
    private String dayOfWeekAsString;
    private String formattedStartTime;
    private String formattedEndTime;

    public PriceShift() {
    }

    public PriceShift(String string) {
        super(string);
    }

    public PriceShift(String string, String string2) {
        super(string, string2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PriceShift)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((PriceShift)object).getName());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getDayOfWeekAsString() {
        String string = "";
        String string2 = this.getDaysOfWeek();
        if (StringUtils.isNotEmpty((String)string2)) {
            String[] stringArray = string2.split(",");
            if (stringArray.length == 7) {
                return Messages.getString("PriceShift.2");
            }
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = Integer.valueOf(stringArray[i]);
                    DayOfWeek dayOfWeek = DayOfWeek.getDayOfWeek(n);
                    string = string + dayOfWeek.name();
                    if (i == stringArray.length - 1) continue;
                    string = string + ",";
                }
            }
        }
        return string;
    }

    public boolean isAnyDay() {
        String[] stringArray;
        String string = this.getDaysOfWeek();
        return string != null && (stringArray = string.split(",")).length == 7;
    }

    public void setAnyDay(boolean bl) {
        if (bl) {
            this.setDaysOfWeek("1,2,3,4,5,6,7");
        }
    }

    public String getFormattedStartTime() {
        this.formattedStartTime = new SimpleDateFormat("hh:mm a").format(this.getStartTime());
        return this.formattedStartTime;
    }

    public String getFormattedEndTime() {
        this.formattedEndTime = new SimpleDateFormat("hh:mm a").format(this.getEndTime());
        return this.formattedEndTime;
    }
}

