/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopFloor;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"foregroundColor", "backgroundColor", "floorSize"})
public class ShopFloor
extends BaseShopFloor
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    @XmlTransient
    private Color foregroundColor;
    @XmlTransient
    private Color backgroundColor;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ShopFloor() {
    }

    public ShopFloor(String string) {
        super(string);
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasTableWithNumber(String string) {
        Set<ShopTable> set = this.getTables();
        if (set == null) {
            return false;
        }
        for (ShopTable shopTable : set) {
            if (!shopTable.getTableNumber().equals(string)) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public Color getForegroundColor() {
        if (this.getForegroundColorCode() == null) {
            return null;
        }
        if (this.foregroundColor != null) {
            return this.foregroundColor;
        }
        this.foregroundColor = new Color(this.getForegroundColorCode());
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        if (color != null) {
            this.setForegroundColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Color getBackgroundColor() {
        if (this.getBackgroundColorCode() == null) {
            return null;
        }
        if (this.backgroundColor != null) {
            return this.backgroundColor;
        }
        this.backgroundColor = new Color(this.getBackgroundColorCode());
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (color != null) {
            this.setBackgroundColorCode(color.getRGB());
        }
    }

    public Dimension getFloorSize() {
        Integer n = this.getHeight();
        Integer n2 = this.getWidth();
        if (n2 <= 0) {
            n2 = 850;
        }
        if (n <= 0) {
            n = 500;
        }
        return new Dimension(n2, n);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

