/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseShopSeat;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"shopTable", "member"})
public class ShopSeat
extends BaseShopSeat {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private Customer member;
    private ShopTable shopTable;

    public ShopSeat() {
    }

    public ShopSeat(String string) {
        super(string);
    }

    public ShopSeat(ShopTable shopTable, int n, int n2, int n3) {
        this.setTableId(shopTable.getId());
        this.setSeatNumber(n);
        this.setPosX(n2);
        this.setPosY(n3);
    }

    @Override
    public String toString() {
        return String.valueOf(super.getSeatNumber());
    }

    public TicketItemSeat convertTicketItemSeat() {
        TicketItemSeat ticketItemSeat = new TicketItemSeat();
        ticketItemSeat.setShopSeat(this);
        return ticketItemSeat;
    }

    public Customer getMember() {
        return this.member;
    }

    public void setMember(Customer customer) {
        this.member = customer;
    }

    public ShopTable getShopTable() {
        return this.shopTable;
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(string);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

