/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseMenuModifierDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuModifierDAO
extends BaseMenuModifierDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        MenuModifier menuModifier = (MenuModifier)object;
        if (menuModifier == null) {
            throw new PosException(Messages.getString("MenuModifierDAO.0"));
        }
        menuModifier.setDeleted(true);
        this.update(menuModifier, session);
        this.deleteModifierFromModifierGroup(menuModifier, session);
        this.deleteModifierFromModifierPageItem(menuModifier, session);
        this.deleteModifierFromDefaultModifierList(menuModifier, session);
    }

    private void deleteModifierFromModifierPageItem(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPageItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPageItem.PROP_MENU_MODIFIER_ID, (Object)menuModifier.getId()));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItemModifierPageItem menuItemModifierPageItem : list) {
            this.deletePageItemFromPage(menuItemModifierPageItem, session);
        }
    }

    private void deletePageItemFromPage(MenuItemModifierPageItem menuItemModifierPageItem, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPage.class);
        criteria.createAlias("pageItems", "pageItem");
        criteria.add((Criterion)Restrictions.eq((String)("pageItem." + MenuItemModifierPage.PROP_ID), (Object)menuItemModifierPageItem.getId()));
        List list = criteria.list();
        for (MenuItemModifierPage menuItemModifierPage : list) {
            menuItemModifierPage.getPageItems().remove(menuItemModifierPageItem);
            MenuItemModifierPageDAO.getInstance().update(menuItemModifierPage, session);
        }
    }

    private void deleteModifierFromDefaultModifierList(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
        criteria.createAlias("defaultModifierList", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.modifier", (Object)menuModifier));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            List<DefaultMenuModifier> list2 = menuItemModifierSpec.getDefaultModifierList();
            if (list2 != null && list2.size() > 0) {
                Iterator<DefaultMenuModifier> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    DefaultMenuModifier defaultMenuModifier = iterator.next();
                    if (!defaultMenuModifier.getModifier().getId().equals(menuModifier.getId())) continue;
                    iterator.remove();
                }
            }
            MenuItemModifierSpecDAO.getInstance().update(menuItemModifierSpec, session);
        }
    }

    private void deleteModifierFromModifierGroup(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(ModifierGroup.class);
        this.addDeletedFilter(criteria);
        criteria.createAlias("modifiers", "modifier");
        criteria.add((Criterion)Restrictions.eq((String)("modifier." + MenuModifier.PROP_ID), (Object)menuModifier.getId()));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ModifierGroup modifierGroup : list) {
            modifierGroup.getModifiers().remove(menuModifier);
            ModifierGroupDAO.getInstance().update(modifierGroup, session);
        }
    }

    public void initialize(MenuModifier menuModifier) {
        if (menuModifier == null || menuModifier.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(menuModifier.getPizzaModifierPriceList()) && Hibernate.isInitialized(menuModifier.getMultiplierPriceList()) && Hibernate.isInitialized(menuModifier.getModifierGroups())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuModifier);
            Hibernate.initialize(menuModifier.getPizzaModifierPriceList());
            Hibernate.initialize(menuModifier.getMultiplierPriceList());
            Hibernate.initialize(menuModifier.getModifierGroups());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuModifier> getModifierList(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_TAG, (Object)string));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuModifier> getMenuModifiers(String string) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public int getRowCount(String string, boolean bl) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        return 0;
    }

    public void loadItems(String string, boolean bl, PaginatedListModel paginatedListModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
    }

    public void loadItems(String string, boolean bl, boolean bl2, BeanTableModel<MenuModifier> beanTableModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            beanTableModel.setRows(criteria.list());
        }
    }

    public List<MenuModifier> getComboModifiers() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_COMBO_MODIFIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    public MenuModifier findName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuModifier menuModifier = (MenuModifier)list.get(0);
                return menuModifier;
            }
            MenuModifier menuModifier = null;
            return menuModifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuModifier(PaginationSupport paginationSupport, String string, ModifierGroup modifierGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(string, modifierGroup, criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginationSupport.setNumRows(number.intValue());
            }
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(string, modifierGroup, criteria);
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(String string, ModifierGroup modifierGroup, Criteria criteria) {
        this.addDeletedFilter(criteria);
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (modifierGroup != null) {
            criteria.createAlias("modifierGroups", "groups");
            criteria.add((Criterion)Restrictions.eq((String)("groups." + ModifierGroup.PROP_ID), (Object)modifierGroup.getId()));
        }
    }
}

