/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.BaseUserTypeDAO;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class UserTypeDAO
extends BaseUserTypeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        UserType userType = (UserType)object;
        if (userType == null) {
            throw new PosException(Messages.getString("UserTypeDAO.0"));
        }
        this.ensureUserTypeNotInUse(session, userType);
        userType.setDeleted(true);
        this.update(userType, session);
    }

    private void ensureUserTypeNotInUse(Session session, UserType userType) {
        Criteria criteria = session.createCriteria(User.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_USER_TYPE_ID, (Object)userType.getId()));
        List list = criteria.list();
        if (list != null && list.size() > 0) {
            throw new PosException(Messages.getString("UserTypeDAO.1"));
        }
    }

    @Override
    public List<UserType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserType> findAllUnSyncUserType() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression simpleExpression = Restrictions.eq((String)UserType.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)UserType.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateUserTypes(List<UserType> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        for (UserType userType : list) {
            UserType userType2 = this.get(userType.getId());
            if (userType2 != null) {
                String string = userType2.getId();
                long l = userType2.getVersion();
                PropertyUtils.copyProperties((Object)userType2, (Object)userType);
                userType2.setId(string);
                userType2.setVersion(l);
                userType2.setUpdateLastUpdateTime(bl);
                userType2.setUpdateSyncTime(bl2);
                this.update(userType2);
                continue;
            }
            userType.setUpdateLastUpdateTime(bl);
            userType.setUpdateSyncTime(bl2);
            this.save(userType);
        }
    }
}

