/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.util.NumberUtil;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class KitchenTicketDataSource
extends AbstractReportDataSource {
    private Store a = Application.getInstance().getStore();

    public KitchenTicketDataSource(KitchenTicket kitchenTicket) {
        super(new String[]{"courseIcon", "groupId", "groupName", "itemNo", "itemName", "itemQty", "colorCode", "isVoidItem", "isModifier"});
        this.a(kitchenTicket);
    }

    private void a(KitchenTicket kitchenTicket) {
        Terminal terminal;
        OrderType orderType = kitchenTicket.getOrderType();
        if (orderType != null && !orderType.isAllowSeatBasedOrder().booleanValue() && (terminal = Application.getInstance().getTerminal()) != null && terminal.isGroupByCatagoryKitReceipt().booleanValue()) {
            Collections.sort(kitchenTicket.getTicketItems(), new Comparator<KitchenTicketItem>(){

                @Override
                public int compare(KitchenTicketItem kitchenTicketItem, KitchenTicketItem kitchenTicketItem2) {
                    return kitchenTicketItem.getMenuItemGroupName().compareTo(kitchenTicketItem2.getMenuItemGroupName());
                }
            });
        }
        this.setRows(kitchenTicket.getTicketItems());
    }

    @Override
    public Object getValueAt(int n, int n2) {
        KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)this.rows.get(n);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return kitchenTicketItem.getMenuItemGroupName();
            }
            case 2: {
                return kitchenTicketItem.getMenuItemGroupName();
            }
            case 3: {
                return kitchenTicketItem.getMenuItemCode();
            }
            case 4: {
                return kitchenTicketItem.getMenuItemNameDisplay();
            }
            case 5: {
                return NumberUtil.trimDecilamIfNotNeeded(kitchenTicketItem.getQuantity());
            }
            case 6: {
                Ticket ticket = kitchenTicketItem.getKitchenTicket().getParentTicket();
                String string = "";
                if (ticket != null && ticket.getOrderType() != null && StringUtils.isNotEmpty((String)(string = ticket.getOrderType().getId()))) {
                    string = string + ".";
                }
                if (kitchenTicketItem.isModifierItem().booleanValue()) {
                    return this.a.getProperty(string + "kitchen_ticket.modifier.color");
                }
                if (kitchenTicketItem.isCookingInstruction().booleanValue()) {
                    return this.a.getProperty(string + "kitchen_ticket.instruction.color");
                }
                if (kitchenTicketItem.getMenuItemName().contains("Seat**")) {
                    return this.a.getProperty(string + "kitchen_ticket.seat.color");
                }
                return Messages.getString("KitchenTicketDataSource.7");
            }
            case 7: {
                return kitchenTicketItem.isVoided();
            }
            case 8: {
                return kitchenTicketItem.isModifierItem();
            }
        }
        return null;
    }
}

