/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.VoidItemReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.calendar.DateUtils;

public class VoidItemReport
extends Report {
    private VoidItemReportModel a;
    private VoidItemReportModel b;

    @Override
    public void refresh() throws Exception {
        boolean bl = this.createModels();
        if (!bl) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("VoidItemReport.0"));
            this.viewer = null;
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport("deleteItem_sub_report");
        JasperReport jasperReport2 = ReportUtil.getReport("deleteItem_ticket_sub_report");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("VoidItemReport.4"));
        hashMap.put("reportTime", DateUtil.formatDateWithTime(new Date()));
        hashMap.put("dateRange", DateUtil.formatDateWithTime(this.getStartDate()) + Messages.getString("VoidItemReport.7") + DateUtil.formatDateWithTime(this.getEndDate()));
        hashMap.put("terminalName", this.getTerminal() == null ? POSConstants.ALL : this.getTerminal().getName());
        hashMap.put("currency", Messages.getString("SalesReport.8") + " " + CurrencyUtil.getCurrencyName() + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("itemDataSource", (String)new JRTableModelDataSource((TableModel)this.a));
        hashMap.put("ticketDataSource", (String)new JRTableModelDataSource((TableModel)this.b));
        if (this.b.getRowCount() != 0) {
            hashMap.put("ticketSection", Messages.getString("VoidItemReport.16"));
            hashMap.put("ticketReport", (String)jasperReport2);
        }
        hashMap.put("itemSection", Messages.getString("VoidItemReport.18"));
        hashMap.put("itemReport", (String)jasperReport);
        JasperReport jasperReport3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("void_item_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport3, hashMap, (JRDataSource)new JREmptyDataSource());
        this.viewer = new JRViewer(jasperPrint);
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public boolean createModels() {
        Object object;
        DeletedItem deletedItem;
        Date date = DateUtils.startOfDay((Date)this.getStartDate());
        Date date2 = DateUtils.endOfDay((Date)this.getEndDate());
        List<VoidItem> list = VoidItemDAO.getInstance().findByDate(date, date2, this.getTerminal());
        if (list == null || list.isEmpty()) {
            return false;
        }
        List<Ticket> list2 = TicketDAO.getInstance().findVoidTicketByDate(date, date2, this.getTerminal());
        ArrayList<DeletedItem> arrayList = new ArrayList<DeletedItem>();
        ArrayList<DeletedItem> arrayList2 = new ArrayList<DeletedItem>();
        for (VoidItem comparable : list) {
            deletedItem = new DeletedItem();
            deletedItem.setId(comparable.getId());
            deletedItem.setVoidDate(comparable.getVoidDate());
            deletedItem.setTicketId(comparable.getTicketId());
            deletedItem.setQuantity(comparable.getQuantity());
            deletedItem.setName(comparable.getMenuItemName());
            deletedItem.setTotal(comparable.getTotalPrice());
            deletedItem.setVoidReason(comparable.getVoidReason());
            deletedItem.setItemWasted(comparable.isItemWasted());
            object = TicketDAO.getInstance().findOwner(comparable.getTicketId());
            deletedItem.setOwner((User)object);
            deletedItem.setVoidUser(comparable.getVoidByUser());
            arrayList.add(deletedItem);
        }
        this.a = new VoidItemReportModel();
        this.a.setItems(arrayList);
        for (Ticket ticket : list2) {
            deletedItem = new DeletedItem();
            deletedItem.setId(ticket.getId());
            deletedItem.setVoidDate(ticket.getClosingDate());
            deletedItem.setTicketId(ticket.getId());
            object = VoidItemDAO.getInstance().getVoidItems(ticket.getId());
            double d = 0.0;
            double d2 = 0.0;
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    VoidItem voidItem = (VoidItem)iterator.next();
                    d += voidItem.getTotalPrice().doubleValue();
                    d2 += voidItem.getQuantity().doubleValue();
                }
                deletedItem.setQuantity(d2);
                deletedItem.setTotal(d);
            }
            deletedItem.setVoidReason(ticket.getVoidReason());
            deletedItem.setItemWasted(ticket.isWasted());
            deletedItem.setOwner(ticket.getOwner());
            deletedItem.setVoidUser(ticket.getVoidedBy());
            arrayList2.add(deletedItem);
        }
        this.b = new VoidItemReportModel();
        this.b.setItems(arrayList2);
        return true;
    }
}

