/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;

public class IntegerDocument
extends PlainDocument {
    public IntegerDocument() {
        this.setDocumentFilter(new IntegerDocumentFilter());
    }

    class IntegerDocumentFilter
    extends DocumentFilter {
        IntegerDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(document.getText(0, document.getLength()));
            stringBuilder.insert(n, string);
            if (this.a(stringBuilder.toString())) {
                super.insertString(filterBypass, n, string, attributeSet);
            }
        }

        private boolean a(String string) {
            try {
                if (StringUtils.isNotBlank((String)string)) {
                    Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            Document document = filterBypass.getDocument();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(document.getText(0, document.getLength()));
            stringBuilder.replace(n, n + n2, string);
            if (this.a(stringBuilder.toString())) {
                super.replace(filterBypass, n, n2, string, attributeSet);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            Document document = filterBypass.getDocument();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(document.getText(0, document.getLength()));
            stringBuilder.delete(n, n + n2);
            if (stringBuilder.toString().length() == 0) {
                super.replace(filterBypass, n, n2, "", null);
            } else if (this.a(stringBuilder.toString())) {
                super.remove(filterBypass, n, n2);
            }
        }
    }
}

