/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.teminaltype;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.model.TerminalType;
import com.floreantpos.teminaltype.TerminalTypeForm;
import com.floreantpos.ui.BeanEditor;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;

public class TerminalTypeModelBrowser<E>
extends ModelBrowser {
    private BeanEditor a;
    private JButton b = new JButton(Messages.getString("ShopTableModelBrowser.1"));

    public TerminalTypeModelBrowser(BeanEditor<E> beanEditor) {
        super(beanEditor);
        this.a = beanEditor;
    }

    @Override
    public void init(TableModel tableModel) {
        super.init(tableModel);
        this.buttonPanel.add(this.b);
        this.b.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Command command = Command.fromString(actionEvent.getActionCommand());
        try {
            switch (command) {
                case NEW: {
                    this.a.createNew();
                    this.a.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.browserTable.clearSelection();
                    break;
                }
                case EDIT: {
                    this.a.edit();
                    this.a.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    break;
                }
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.a.save()) break;
                    this.a.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    this.a();
                    break;
                }
                case DELETE: {
                    if (!this.a.delete()) break;
                    this.a.setBean(null);
                    this.a.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    break;
                }
            }
            this.handleAdditionaButtonActionIfApplicable(actionEvent);
            TerminalTypeForm terminalTypeForm = (TerminalTypeForm)this.a;
            if (actionEvent.getSource() == this.b) {
                if (!terminalTypeForm.deleteAllTables()) {
                    return;
                }
                this.refreshTable();
                this.btnNew.setEnabled(true);
                this.btnEdit.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnDelete.setEnabled(false);
                this.btnCancel.setEnabled(false);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.b.setEnabled(true);
    }

    @Override
    public void doCancelEditing() {
        super.doCancelEditing();
        if (this.browserTable.getSelectedRow() != -1) {
            // empty if block
        }
    }

    private void a() {
        TerminalTypeForm terminalTypeForm = (TerminalTypeForm)this.a;
        TerminalType terminalType = (TerminalType)terminalTypeForm.getBean();
        if (terminalType == null) {
            return;
        }
        int n = this.a(this.browserTable.getModel(), terminalType);
        this.browserTable.setRowSelectionInterval(n, n);
    }

    private int a(TableModel tableModel, TerminalType terminalType) {
        for (int i = 0; i <= tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            if (!string.equals(terminalType.getName())) continue;
            return i;
        }
        return -1;
    }
}

