/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.google.gson.GsonBuilder;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.PosResponse;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hibernate.Hibernate;

public class PosWebService {
    public List getDataList(String string) throws Exception {
        ClientResponse clientResponse = this.a("/entity", null);
        return (List)clientResponse.getEntity((GenericType)new GenericType<List>(){});
    }

    public List<OrderType> getOrderTypes() throws Exception {
        ClientResponse clientResponse = this.a("/ordertype", this.a(OrderType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<OrderType>>(){});
    }

    public List<Outlet> getOutlets() throws Exception {
        ClientResponse clientResponse = this.a("/outlet", this.a(Outlet.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Outlet>>(){});
    }

    public List<Customer> getCustomers() throws Exception {
        ClientResponse clientResponse = this.a("/customer", this.a(Customer.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Customer>>(){});
    }

    public List<SalesArea> getSalesArea() throws Exception {
        ClientResponse clientResponse = this.a("/salesarea", this.a(SalesArea.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<SalesArea>>(){});
    }

    public List<Department> getDepartments() throws Exception {
        ClientResponse clientResponse = this.a("/department", this.a(Department.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Department>>(){});
    }

    public List<TerminalType> getTerminalTypes() throws Exception {
        ClientResponse clientResponse = this.a("/terminaltype", this.a(TerminalType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<TerminalType>>(){});
    }

    public List<Terminal> getTerminals() throws Exception {
        ClientResponse clientResponse = this.a("/terminal", this.a(Terminal.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Terminal>>(){});
    }

    public List<Currency> getCurrencies() throws Exception {
        ClientResponse clientResponse = this.a("/currency", this.a(Currency.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Currency>>(){});
    }

    public List<UserPermission> getUserPermissions() throws Exception {
        ClientResponse clientResponse = this.a("/userpermission", this.a(UserPermission.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserPermission>>(){});
    }

    public List<UserType> getUserTypes() throws Exception {
        ClientResponse clientResponse = this.a("/usertype", this.a(UserType.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserType>>(){});
    }

    public List<User> getUsers() throws Exception {
        ClientResponse clientResponse = this.a("/user", this.a(User.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<User>>(){});
    }

    public List<Tax> getTaxes() throws Exception {
        ClientResponse clientResponse = this.a("/tax", this.a(Tax.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Tax>>(){});
    }

    public List<TaxGroup> getTaxGroups() throws Exception {
        ClientResponse clientResponse = this.a("/taxgroup", this.a(TaxGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<TaxGroup>>(){});
    }

    public List<MenuCategory> getMenuCategories() throws Exception {
        ClientResponse clientResponse = this.a("/MenuCategory", this.a(MenuCategory.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuCategory>>(){});
    }

    public List<MenuGroup> getMenuGroups() throws Exception {
        ClientResponse clientResponse = this.a("/MenuGroup", this.a(MenuGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuGroup>>(){});
    }

    public List<MenuItem> getMenuItems() throws Exception {
        ClientResponse clientResponse = this.a("/MenuItem", this.a(MenuItem.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItem>>(){});
    }

    public List<ModifierGroup> getModifierGroups() throws Exception {
        ClientResponse clientResponse = this.a("/ModifierGroup", this.a(ModifierGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<ModifierGroup>>(){});
    }

    public List<MenuModifier> getMenuModifiers() throws Exception {
        ClientResponse clientResponse = this.a("/MenuModifier", this.a(MenuModifier.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuModifier>>(){});
    }

    public List<PriceRule> getPriceRules() throws Exception {
        ClientResponse clientResponse = this.a("/PriceRule", this.a(PriceRule.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceRule>>(){});
    }

    public List<PriceTable> getPriceList() throws Exception {
        ClientResponse clientResponse = this.a("/PriceTable", this.a(PriceTable.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceTable>>(){});
    }

    public List<PriceShift> getPriceShift() throws Exception {
        ClientResponse clientResponse = this.a("/PriceShift", this.a(PriceShift.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceShift>>(){});
    }

    public List<InventoryVendor> getInventoryVendors() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryVendor", this.a(InventoryVendor.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryVendor>>(){});
    }

    public List<InventoryVendorItems> getInventoryVendorItems() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryVendorItem", this.a(InventoryVendorItems.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryVendorItems>>(){});
    }

    public List<InventoryLocation> getInventoryLocations() throws Exception {
        ClientResponse clientResponse = this.a("/inventorylocation", this.a(InventoryLocation.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryLocation>>(){});
    }

    public List<InventoryTransaction> getInventoryTransactions() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryTransaction", this.a(InventoryTransaction.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryTransaction>>(){});
    }

    public List<MenuItemInventoryStatus> getMenuItemInvStatus() throws Exception {
        ClientResponse clientResponse = this.a("/menuItemInvStatus", this.a(MenuItemInventoryStatus.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItemInventoryStatus>>(){});
    }

    public List<InventoryStockUnit> getInventoryStockUnits() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryStockUnits", this.a(InventoryStockUnit.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryStockUnit>>(){});
    }

    public List<InventoryStock> getInventoryStocks() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryStock", this.a(InventoryStock.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryStock>>(){});
    }

    public List<InventoryUnitGroup> getAllInventoryUnitGroups() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryUnitGroup", this.a(InventoryUnitGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryUnitGroup>>(){});
    }

    public List<InventoryUnit> getAllInventoryUnits() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryUnit", this.a(InventoryUnit.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryUnit>>(){});
    }

    public List<PackagingUnit> getAllPackagingUnits() throws Exception {
        ClientResponse clientResponse = this.a("/packagingUnit", this.a(PackagingUnit.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PackagingUnit>>(){});
    }

    public List<InventoryClosingBalance> getInventoryClosingBalance() throws Exception {
        ClientResponse clientResponse = this.a("/inventoryClosingBlance", this.a(InventoryClosingBalance.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<InventoryClosingBalance>>(){});
    }

    public List<ShopFloor> getShopFloors() throws Exception {
        ClientResponse clientResponse = this.a("/shopFloors", this.a(ShopFloor.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<ShopFloor>>(){});
    }

    public List<ShopTable> getShopTables() throws Exception {
        ClientResponse clientResponse = this.a("/shopTables", this.a(ShopTable.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<ShopTable>>(){});
    }

    public List<BookingInfo> getBookingInfos() throws Exception {
        ClientResponse clientResponse = this.a("/bookingInfos", this.a(BookingInfo.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<BookingInfo>>(){});
    }

    public List<ShopTableStatus> getAllShopTableStatus() throws Exception {
        ClientResponse clientResponse = this.a("/shopTableStatus", this.a(ShopTableStatus.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<ShopTableStatus>>(){});
    }

    public List<CashBreakdown> getAllCashBreakdown() throws Exception {
        ClientResponse clientResponse = this.a("/cashBreakdown", this.a(CashBreakdown.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<CashBreakdown>>(){});
    }

    public List<StoreSession> getAllStoreSession() throws Exception {
        ClientResponse clientResponse = this.a("/storeSession", this.a(StoreSession.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<StoreSession>>(){});
    }

    public List<CashDrawer> getAllCashDrawer() throws Exception {
        ClientResponse clientResponse = this.a("/allCashDrawer", this.a(CashDrawer.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<CashDrawer>>(){});
    }

    public List<Ticket> getAllTickets() throws Exception {
        ClientResponse clientResponse = this.a("/ticket", this.a(Ticket.class));
        GenericType<List<Ticket>> genericType = new GenericType<List<Ticket>>(){};
        return (List)clientResponse.getEntity((GenericType)genericType);
    }

    public List<Shift> getAllShifts() throws Exception {
        ClientResponse clientResponse = this.a("/shift", this.a(Shift.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Shift>>(){});
    }

    public List<Address> getAllAddress() throws Exception {
        ClientResponse clientResponse = this.a("/address", this.a(Address.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Address>>(){});
    }

    public List<AttendenceHistory> getAllAttendenceHistories() throws Exception {
        ClientResponse clientResponse = this.a("/attendencehistory", this.a(AttendenceHistory.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<AttendenceHistory>>(){});
    }

    public List<AttributeGroup> getAttributeGroups() throws Exception {
        ClientResponse clientResponse = this.a("/attributegroup", this.a(AttributeGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<AttributeGroup>>(){});
    }

    public List<Attribute> getAttributes() throws Exception {
        ClientResponse clientResponse = this.a("/attribute", this.a(Attribute.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Attribute>>(){});
    }

    public List<CookingInstruction> getCookingInstructions() throws Exception {
        ClientResponse clientResponse = this.a("/cookingInstruction", this.a(CookingInstruction.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<CookingInstruction>>(){});
    }

    public List<Course> getCourses() throws Exception {
        ClientResponse clientResponse = this.a("/courses", this.a(Course.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Course>>(){});
    }

    public List<CustomerGroup> getCustomerGroup() throws Exception {
        ClientResponse clientResponse = this.a("/CustomerGroup", this.a(CustomerGroup.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<CustomerGroup>>(){});
    }

    public List<CustomPayment> getCustomPayment() throws Exception {
        ClientResponse clientResponse = this.a("/CustomPayment", this.a(CustomPayment.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<CustomPayment>>(){});
    }

    public List<DeclaredTips> getDeclaredTips() throws Exception {
        ClientResponse clientResponse = this.a("/DeclaredTips", this.a(DeclaredTips.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<DeclaredTips>>(){});
    }

    public List<DeliveryAddress> getDeliveryAddress() throws Exception {
        ClientResponse clientResponse = this.a("/DeliveryAddress", this.a(DeliveryAddress.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<DeliveryAddress>>(){});
    }

    public List<DeliveryCharge> getDeliveryCharge() throws Exception {
        ClientResponse clientResponse = this.a("/DeliveryCharge", this.a(DeliveryCharge.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<DeliveryCharge>>(){});
    }

    public List<Discount> getDiscount() throws Exception {
        ClientResponse clientResponse = this.a("/Discount", this.a(Discount.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Discount>>(){});
    }

    public List<GiftCard> getGiftCard() throws Exception {
        ClientResponse clientResponse = this.a("/GiftCard", this.a(GiftCard.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<GiftCard>>(){});
    }

    public List<GratuityPaymentHistory> getGratuityPaymentHistory() throws Exception {
        ClientResponse clientResponse = this.a("/GratuityPaymentHistory", this.a(GratuityPaymentHistory.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<GratuityPaymentHistory>>(){});
    }

    public List<DeliveryInstruction> getDeliveryInstruction() throws Exception {
        ClientResponse clientResponse = this.a("/DeliveryInstruction", this.a(DeliveryInstruction.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<DeliveryInstruction>>(){});
    }

    public List<Multiplier> getMultiplier() throws Exception {
        ClientResponse clientResponse = this.a("/Multiplier", this.a(Multiplier.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<Multiplier>>(){});
    }

    public List<MenuItemModifierSpec> getMenuItemModifierSpec() throws Exception {
        ClientResponse clientResponse = this.a("/MenuItemModifierSpec", this.a(MenuItemModifierSpec.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItemModifierSpec>>(){});
    }

    public List<MenuItemModifierPage> getMenuItemModifierPage() throws Exception {
        ClientResponse clientResponse = this.a("/MenuItemModifierPage", this.a(MenuItemModifierPage.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItemModifierPage>>(){});
    }

    public List<PizzaCrust> getPizzaCrust() throws Exception {
        ClientResponse clientResponse = this.a("/PizzaCrust", this.a(PizzaCrust.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PizzaCrust>>(){});
    }

    public List<PizzaPrice> getPizzaPrice() throws Exception {
        ClientResponse clientResponse = this.a("/PizzaPrice", this.a(PizzaPrice.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<PizzaPrice>>(){});
    }

    public List<MenuPage> getMenuPage() throws Exception {
        ClientResponse clientResponse = this.a("/MenuPage", this.a(MenuPage.class));
        return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuPage>>(){});
    }

    public PosResponse register(String string, String string2, String string3, String string4) throws Exception {
        Client client = this.b();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"store_name", (Object)string2);
        multivaluedMapImpl.add((Object)"user_email", (Object)string3);
        multivaluedMapImpl.add((Object)"password", (Object)string4);
        WebResource webResource = client.resource(string + "/service/store/register");
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMapImpl);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException(Messages.getString("PosWebService.68") + clientResponse.getStatus());
        }
        PosResponse posResponse = this.a(clientResponse);
        return posResponse;
    }

    private String a() {
        return Store.getWebServiceUrl();
    }

    private ClientResponse a(String string, Date date) throws Exception {
        return this.a(string, this.b(), this.a(date));
    }

    private ClientResponse a(String string, Client client, List<NameValuePair> list) throws Exception {
        String string2 = URLEncodedUtils.format(list, (String)"utf-8");
        WebResource webResource = client.resource(this.a() + string + "?" + string2);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException(Messages.getString("PosWebService.72") + clientResponse.getStatus());
        }
        return clientResponse;
    }

    private ClientResponse a(String string, Client client, MultivaluedMap multivaluedMap) throws Exception {
        WebResource webResource = client.resource(this.a() + string);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMap);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException(Messages.getString("PosWebService.72") + clientResponse.getStatus());
        }
        return clientResponse;
    }

    private PosResponse a(ClientResponse clientResponse) {
        String string = (String)clientResponse.getEntity(String.class);
        PosResponse posResponse = null;
        if (StringUtils.isNotEmpty((String)string)) {
            posResponse = (PosResponse)new GsonBuilder().create().fromJson(string, PosResponse.class);
        }
        return posResponse;
    }

    public PosResponse login(String string, String string2, String string3, String string4) throws Exception {
        Client client = this.b();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"device_id", (Object)TerminalUtil.getSystemUID());
        multivaluedMapImpl.add((Object)"user_email", (Object)string2);
        multivaluedMapImpl.add((Object)"password", (Object)string3);
        multivaluedMapImpl.add((Object)"terminalId", (Object)string4);
        WebResource webResource = client.resource(string + "/service/store/login");
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMapImpl);
        if (clientResponse.getStatus() != 200) {
            throw new RuntimeException(Messages.getString("PosWebService.72") + clientResponse.getStatus());
        }
        PosResponse posResponse = this.a(clientResponse);
        return posResponse;
    }

    public PosResponse checkConnection() throws Exception {
        Store store = StoreDAO.getRestaurant();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = store.getProperty("web.service.url");
        String string2 = store.getProperty("web.service.username");
        String string3 = store.getProperty("web.service.password");
        return this.login(string, string2, string3, String.valueOf(terminal.getId()));
    }

    public PosResponse checkConnection(String string, String string2, String string3, String string4) throws Exception {
        return this.login(string, string2, string3, string4);
    }

    public boolean isConnected() {
        try {
            PosResponse posResponse = this.checkConnection();
            return posResponse != null & posResponse.getResponseCode() == 200;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception.getMessage());
            return false;
        }
    }

    public boolean isCloudConfigured() {
        try {
            Store store = StoreDAO.getRestaurant();
            String string = store.getProperty("web.service.url");
            String string2 = store.getProperty("web.service.username");
            String string3 = store.getProperty("web.service.password");
            if (StringUtils.isNotEmpty((String)string) && StringUtils.isNotEmpty((String)string2) && StringUtils.isNotEmpty((String)string3)) {
                return true;
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception.getMessage());
        }
        return false;
    }

    private Client b() {
        Client client = Client.create();
        client.getProperties();
        return client;
    }

    private MultivaluedMap<String, Object> c() {
        Store store = StoreDAO.getRestaurant();
        MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
        multivaluedMapImpl.add((Object)"device_id", (Object)TerminalUtil.getSystemUID());
        multivaluedMapImpl.add((Object)"user_email", (Object)store.getProperty("web.service.username"));
        multivaluedMapImpl.add((Object)"password", (Object)store.getProperty("web.service.password"));
        return multivaluedMapImpl;
    }

    private List<NameValuePair> a(Date date) {
        Store store = StoreDAO.getRestaurant();
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("device_id", TerminalUtil.getSystemUID()));
        arrayList.add((NameValuePair)new BasicNameValuePair("customer_id", store.getProperty("web.service.customer.id")));
        arrayList.add((NameValuePair)new BasicNameValuePair("user_email", store.getProperty("web.service.username")));
        arrayList.add((NameValuePair)new BasicNameValuePair("password", store.getProperty("web.service.password")));
        if (date != null) {
            arrayList.add((NameValuePair)new BasicNameValuePair("lastUpdateTime", String.valueOf(date.getTime())));
        }
        return arrayList;
    }

    public void uploadStoreSessionData() throws Exception {
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(StoreSession.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (StoreSession storeSession : list) {
                if (storeSession.getCloseTime() != null) {
                    arrayList.add(storeSession.getId());
                }
                this.uploadStoreSessionData(storeSession);
            }
        }
        genericDAO.updateItemsLastSyncTime(arrayList, StoreSession.REF);
    }

    public void uploadStoreSessionData(StoreSession storeSession) throws Exception {
        StoreSession storeSession2 = new StoreSession();
        PropertyUtils.copyProperties((Object)storeSession2, (Object)storeSession);
        storeSession2.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
        this.a(Arrays.asList(storeSession2));
        this.a(storeSession2);
        try {
            this.b(storeSession2);
        }
        catch (Exception exception) {
            String string = Messages.getString("PosWebService.89");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
        }
    }

    private void a(List<StoreSession> list) {
        try {
            GenericEntity<List<StoreSession>> genericEntity = new GenericEntity<List<StoreSession>>(list){};
            this.uploadData((GenericEntity)genericEntity, "storesession");
        }
        catch (Exception exception) {
            String string = Messages.getString("PosWebService.91");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
        }
    }

    public void uploadTerminal() {
        List<Terminal> list = TerminalDAO.getInstance().findAll();
        if (list != null && !list.isEmpty()) {
            for (Terminal object : list) {
                this.a(object);
            }
            try {
                this.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
            }
            catch (Exception exception) {
                String string = Messages.getString("PosWebService.93");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(StoreSession storeSession) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByUnSyncStoreOperationData(storeSession);
        if (list != null && !list.isEmpty()) {
            for (CashDrawer cashDrawer : list) {
                CashDrawer cashDrawer2 = new CashDrawer();
                PropertyUtils.copyProperties((Object)cashDrawer2, (Object)cashDrawer);
                if (cashDrawer.getReportTime() != null) {
                    arrayList.add(cashDrawer2.getId());
                }
                if (cashDrawer.getStartTime() == null) continue;
                CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                cashDrawerReportService.populateReport();
            }
        }
    }

    private void a(Terminal terminal) {
        if (terminal == null) {
            return;
        }
        terminal.setCurrentCashDrawer(null);
        terminal.setAssignedUser(null);
    }

    public List initializeTicket(List list) {
        if (list == null) {
            return null;
        }
        for (Ticket ticket : list) {
            TicketDAO.getInstance().loadFullTicket(ticket);
            this.a(ticket);
        }
        return list;
    }

    private void b(StoreSession storeSession) throws Exception {
        TicketDAO ticketDAO = TicketDAO.getInstance();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        List list = ticketDAO.findAllUnSyncTicket(storeSession);
        Store store = DataProvider.get().getStore();
        String string = store.getDefaultOutletId();
        if (list != null && !list.isEmpty()) {
            for (Ticket ticket : list) {
                ticketDAO.loadFullTicket(ticket);
                this.a(ticket);
                ticket.setOutletId(string);
                arrayList.add(ticket);
            }
        }
        this.doSendTicketToCloud(arrayList);
    }

    public void doSendTicketToCloud(List<Ticket> list) throws Exception {
        GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(list){};
        this.uploadData((GenericEntity)genericEntity, "tickets");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Ticket ticket : list) {
            arrayList.add(ticket.getId());
        }
        GenericDAO.getInstance().updateItemsLastSyncTime(arrayList, Ticket.REF);
    }

    private void a(Ticket ticket) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ticket.setProperties(null);
        ticket.setDepartment(null);
        List<TicketDiscount> list = ticket.getDiscounts();
        if (list != null && list.size() > 0) {
            object4 = list.iterator();
            while (object4.hasNext()) {
                object3 = (TicketDiscount)object4.next();
                this.a((TicketDiscount)object3);
            }
        }
        if ((object4 = ticket.getOrderType()) != null) {
            this.a((OrderType)object4);
        }
        if ((object3 = ticket.getTicketItems()) != null) {
            Hibernate.initialize(object3);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (TicketItem)object2.next();
                this.a((TicketItem)object);
            }
        }
        object2 = new ArrayList<PosTransaction>(ticket.getTransactions());
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            PosTransaction posTransaction = (PosTransaction)object.next();
            try {
                String string = posTransaction.getTicketId();
                posTransaction.setTicket(null);
                posTransaction.setTicketId(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void a(TicketDiscount ticketDiscount) {
        ticketDiscount.setTicket(null);
    }

    private void a(TicketItem ticketItem) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ticketItem.setTicket(null);
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            object4 = list.iterator();
            while (object4.hasNext()) {
                object3 = (TicketItemModifier)object4.next();
                this.a((TicketItemModifier)object3);
            }
        }
        if (((Boolean)(object4 = ticketItem.isComboItem())).booleanValue() && (object3 = ticketItem.getComboItems()) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (TicketItem)object2.next();
                this.a((TicketItem)object);
            }
        }
        object3 = ticketItem.getMenuItemId();
        ticketItem.setMenuItem(null);
        ticketItem.setMenuItemId((String)object3);
        object2 = ticketItem.getDiscounts();
        if (object2 != null && object2.size() > 0) {
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)object.next();
                this.a(ticketItemDiscount);
            }
        }
    }

    private void a(TicketItemModifier ticketItemModifier) {
        ticketItemModifier.setTicketItem(null);
    }

    private void a(TicketItemDiscount ticketItemDiscount) {
        ticketItemDiscount.setTicketItem(null);
    }

    private void a(OrderType orderType) {
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    public void uploadData(GenericEntity genericEntity, String string) throws Exception {
        Client client = this.b();
        String string2 = URLEncodedUtils.format(this.a((Date)null), (String)"utf-8");
        WebResource webResource = client.resource(this.a() + "/" + string + "/save?" + string2);
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)genericEntity);
        if (clientResponse.getStatus() == 200) {
            PosLog.info(this.getClass(), string + " uploaded... ");
        } else if (clientResponse.getStatus() == 500) {
            throw new Exception(Messages.getString("PosWebService.100"));
        }
    }

    public static PosWebService get() {
        return new PosWebService();
    }

    private Date a(Class clazz) throws Exception {
        String string = StoreDAO.getRestaurant().getProperty(clazz.getSimpleName() + "." + Store.PROP_LAST_UPDATE_TIME);
        if (string != null) {
            return DateUtil.formatDateWithDefaultTimeAndSec(string);
        }
        return null;
    }

    private void a(InventoryTransaction inventoryTransaction) {
        MenuItem menuItem = inventoryTransaction.getMenuItem();
        if (menuItem != null) {
            this.a(menuItem);
        }
    }

    private void a(MenuItem menuItem) {
        MenuItemDAO.getInstance().initialize(menuItem);
        String string = menuItem.getParentMenuItemId();
        menuItem.setStockUnits(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setParentMenuItem(null);
        menuItem.setParentMenuItemId(string);
        menuItem.setPizzaPriceList(null);
        menuItem.setAttributes(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setPrinterGroup(null);
        menuItem.setVariants(null);
        MenuGroup menuGroup = menuItem.getParent();
        if (menuGroup != null) {
            MenuCategory menuCategory = menuGroup.getParent();
            MenuCategory menuCategory2 = new MenuCategory();
            if (menuCategory != null) {
                try {
                    PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                    menuCategory2.setDepartments(null);
                    menuCategory2.setOrderTypes(null);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            menuGroup.setParent(menuCategory2);
        }
    }

    public void doUploadTicketToCloud(Ticket ticket) throws Exception {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        this.a(ticket);
        String string = DataProvider.get().getStore().getDefaultOutletId();
        ticket.setOutletId(string);
        arrayList.add(ticket);
        List<InventoryTransaction> list = InventoryTransactionDAO.getInstance().findUnsyncedByTicketId(ticket.getId());
        if (list != null) {
            for (InventoryTransaction serializable2 : list) {
                this.a(serializable2);
            }
        }
        GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(arrayList){};
        this.uploadData((GenericEntity)genericEntity, "tickets");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Ticket ticket2 : arrayList) {
            arrayList2.add(ticket2.getId());
        }
        ArrayList arrayList3 = new ArrayList();
        for (InventoryTransaction inventoryTransaction : list) {
            arrayList3.add(inventoryTransaction.getId());
        }
        GenericDAO genericDAO = GenericDAO.getInstance();
        genericDAO.updateItemsLastSyncTime(arrayList2, Ticket.REF);
        genericDAO.updateItemsLastSyncTime(arrayList3, InventoryLocation.REF);
    }
}

