/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;

public class TicketCloseAction
extends PosAction {
    private Object a;

    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    public TicketCloseAction(DataChangeListener dataChangeListener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.a = this.getSelectedObject();
        if (this.a instanceof Ticket) {
            Ticket ticket = (Ticket)this.a;
            if (ticket.getDueAmount() != 0.0) {
                super.actionPerformed(actionEvent);
            } else {
                this.execute();
            }
        }
    }

    @Override
    public void execute() {
        this.a();
    }

    private void a() {
        try {
            if (this.a != null) {
                if (!this.hasPermissionToAccessTicket((Ticket)this.a)) {
                    return;
                }
                this.a(this.a);
            } else {
                this.b();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void b() {
        List<Ticket> list = TicketDAO.getInstance().getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO, Ticket.PROP_TICKET_TABLE_NUMBERS);
        TicketSelectionDialog ticketSelectionDialog = new TicketSelectionDialog(list);
        ticketSelectionDialog.setCaption(Messages.getString("TicketCloseAction.0"));
        ticketSelectionDialog.openFullScreen();
        if (ticketSelectionDialog.isCanceled()) {
            return;
        }
        List<Ticket> list2 = ticketSelectionDialog.getSelectedTickets();
        if (list2 == null) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("TicketCloseAction.1"), Messages.getString("TicketCloseAction.2"));
        if (n == 0) {
            TicketDAO.closeOrders(list2.toArray(new Ticket[list2.size()]));
        }
    }

    private void a(Object object) {
        int n;
        Ticket ticket = null;
        ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
        if (ticket == null) {
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int n2 = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (n2 != 0 && (n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("TicketCloseAction.3"), Messages.getString("CONFIRM"))) != 0) {
            return;
        }
        n = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (n != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }
}

