/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TransferTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;

public class TransferTicketItemsAction
extends PosAction {
    public TransferTicketItemsAction() {
        super(Messages.getString("TransferTicketItemsAction.0"));
    }

    @Override
    public void execute() {
        try {
            StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog();
            styledTicketSelectionDialog.setCaption(Messages.getString("TransferTicketItemsAction.1"));
            styledTicketSelectionDialog.setRequiredNumber(2);
            styledTicketSelectionDialog.openFullScreen();
            if (styledTicketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> list = styledTicketSelectionDialog.getSelectedTickets();
            if (list.size() <= 0) {
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list) {
                arrayList.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            TransferTicketDialog transferTicketDialog = new TransferTicketDialog(arrayList);
            transferTicketDialog.setTitle(Messages.getString("TransferTicketItemsAction.2"));
            transferTicketDialog.openFullScreen();
            if (transferTicketDialog.isCanceled()) {
                return;
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketItemsAction.3"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private boolean a(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getDiscounts() == null || ticketItem.getDiscounts().size() <= 0) continue;
            return true;
        }
        return false;
    }
}

