/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.CurrencyForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class CurrencyExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<Currency> b = new BeanTableModel(Currency.class);

    public CurrencyExplorer() {
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(Messages.getString("CurrencyExplorer.0"), "code");
        this.b.addColumn(Messages.getString("CurrencyExplorer.2"), "symbol");
        this.b.addColumn(Messages.getString("CurrencyExplorer.4"), "exchangeRate");
        this.b.addColumn(Messages.getString("CurrencyExplorer.6"), "main");
        this.b.addColumn(Messages.getString("CurrencyExplorer.8"), "tolerance");
        this.b.addRows(CurrencyDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CurrencyForm currencyForm = new CurrencyForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)currencyForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    CurrencyExplorer.this.b.addRow((Currency)currencyForm.getBean());
                    CurrencyExplorer.this.a();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = CurrencyExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    n = CurrencyExplorer.this.a.convertRowIndexToModel(n);
                    Currency currency = (Currency)CurrencyExplorer.this.b.getRow(n);
                    CurrencyForm currencyForm = new CurrencyForm(currency);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)currencyForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    CurrencyExplorer.this.a();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CurrencyExplorer.this.b();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    protected BeanTableModel<Currency> getModel() {
        return this.b;
    }

    private void a() {
        List<Currency> list = CurrencyDAO.getInstance().findAll();
        this.b.getRows().clear();
        this.b.addRows(list);
        this.a.repaint();
    }

    private void b() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Currency currency = this.b.getRow(n);
                CurrencyDAO.getInstance().delete(currency);
                this.b.removeRow(currency);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

