/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.BaseCustomerGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CustomerGroupDAO
extends BaseCustomerGroupDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void initialize(CustomerGroup customerGroup) {
        if (customerGroup == null || customerGroup.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(customerGroup.getCustomers())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customerGroup);
            Hibernate.initialize(customerGroup.getCustomers());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCustomerGroupList(List<CustomerGroup> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CustomerGroup customerGroup : list) {
                CustomerGroup customerGroup2 = this.get(customerGroup.getId());
                if (customerGroup2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(customerGroup.getLastUpdateTime(), customerGroup2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), customerGroup.getName() + " already updated");
                        continue;
                    }
                    long l = customerGroup2.getVersion();
                    PropertyUtils.copyProperties((Object)customerGroup2, (Object)customerGroup);
                    customerGroup2.setVersion(l);
                    customerGroup2.setUpdateLastUpdateTime(bl);
                    customerGroup2.setUpdateSyncTime(bl2);
                    this.update(customerGroup2, session);
                    continue;
                }
                customerGroup.setUpdateLastUpdateTime(bl);
                customerGroup.setUpdateSyncTime(bl2);
                this.save(customerGroup, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

