/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.BaseKitchenTicketDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class KitchenTicketDAO
extends BaseKitchenTicketDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastUpdateDate() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_LAST_UPDATE_TIME));
            criteria.setMaxResults(1);
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, List<Printer> list, List<OrderType> list2, boolean bl, PaginatedListModel paginatedListModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            int n;
            List<String> list3;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_VOIDED, (Object)Boolean.FALSE));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            }
            if (list2 != null) {
                list3 = new ArrayList<String>();
                for (n = 0; n < list2.size(); ++n) {
                    list3.add(list2.get(n).getId());
                }
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_ORDER_TYPE_ID, list3));
            }
            if (list != null) {
                list3 = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    list3.add(list.get(n).getVirtualPrinter().getName());
                }
                criteria.add(Restrictions.in((String)KitchenTicket.PROP_PRINTER_NAME, list3));
            }
            criteria.add(Restrictions.isNotEmpty((String)"ticketItems"));
            paginatedListModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            list3 = criteria.list();
            if (list3 == null) {
                list3 = new ArrayList();
            }
            paginatedListModel.setData(list3);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findAllOpen() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findAllOpen(Date date) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.WAITING.name()));
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)date)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void dispatchAll() {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_STATUS, (Object)KitchenStatus.BUMP.name()));
            List list = criteria.list();
            if (list.isEmpty()) {
                transaction.rollback();
                throw new PosException("No data to dispatch");
            }
            for (KitchenTicket kitchenTicket : list) {
                this.delete(kitchenTicket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicket> findByParentId(String string) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)string));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KitchenTicket findByLastOrderParentId(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicket.PROP_TICKET_ID, (Object)string));
            criteria.addOrder(Order.desc((String)KitchenTicket.PROP_CREATE_DATE));
            List list = criteria.list();
            if (list.size() > 0) {
                KitchenTicket kitchenTicket = (KitchenTicket)list.get(0);
                return kitchenTicket;
            }
            KitchenTicket kitchenTicket = null;
            return kitchenTicket;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextKitchenTickets(PaginatedTableModel paginatedTableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int n = paginatedTableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousKitchenTickets(PaginatedTableModel paginatedTableModel) {
        List list;
        Session session = null;
        Criteria criteria = null;
        try {
            int n = paginatedTableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(List<KitchenTicket> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (KitchenTicket kitchenTicket : list) {
                session.saveOrUpdate((Object)kitchenTicket);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date isDataUpdated(Date date) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)KitchenTicket.PROP_CREATE_DATE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.gt((String)KitchenTicket.PROP_CREATE_DATE, (Object)date));
            }
            if ((object = criteria.uniqueResult()) == null) {
                Date date2 = null;
                return date2;
            }
            Date date3 = (Date)object;
            return date3;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        Date date = StoreDAO.getServerTimestamp();
        KitchenTicket kitchenTicket = (KitchenTicket)object;
        kitchenTicket.setLastUpdateTime(date);
        session.saveOrUpdate((Object)kitchenTicket);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, KitchenStatus kitchenStatus, KitchenStatus kitchenStatus2, boolean bl) {
        this.bumpOrUnbump(kitchenTicket, null, kitchenStatus, kitchenStatus2, bl);
    }

    public void bumpOrUnbump(KitchenTicket kitchenTicket, Ticket ticket, KitchenStatus kitchenStatus, KitchenStatus kitchenStatus2, boolean bl) {
        if (ticket == null) {
            ticket = TicketDAO.getInstance().loadFullTicket(kitchenTicket.getTicketId());
        }
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            block5: for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
                kitchenTicketItem.setStatus(kitchenStatus.name());
                double d = kitchenTicketItem.getQuantity();
                if (ticket == null) continue;
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    if (kitchenTicketItem.getMenuItemCode() == null || !kitchenTicketItem.getMenuItemCode().equals(ticketItem.getMenuItemId()) || ticketItem.getKitchenStatusValue() == kitchenStatus2) continue;
                    if (d == 0.0) continue block5;
                    ticketItem.setKitchenStatusValue(kitchenStatus2);
                    d -= ticketItem.getQuantity().doubleValue();
                }
            }
            kitchenTicket.setStatus(kitchenStatus.name());
            Date date = StoreDAO.getServerTimestamp();
            if (bl) {
                kitchenTicket.setClosingDate(date);
            } else {
                kitchenTicket.setClosingDate(null);
            }
            this.saveOrUpdate(kitchenTicket, session);
            if (ticket != null) {
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
    }
}

