/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CashDrawerTransactionReportModel
extends AbstractTableModel {
    private String[] a = new String[]{"transTime", "ticketId", "member", "totalAmount", "transType"};
    private List<PosTransaction> b;

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = this.b.get(n);
        Ticket ticket = posTransaction.getTicket();
        switch (n2) {
            case 0: {
                return DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime());
            }
            case 1: {
                if (ticket != null) {
                    return ticket.getId();
                }
                return null;
            }
            case 2: {
                String string = posTransaction.getCustomerId();
                if (string == null) {
                    return Messages.getString("GUEST");
                }
                Customer customer = CustomerDAO.getInstance().findById(string);
                return customer == null ? Messages.getString("GUEST") : customer.getName();
            }
            case 3: {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof CashDropTransaction || posTransaction instanceof PayOutTransaction) {
                    return posTransaction.getAmount() * -1.0;
                }
                return posTransaction.getAmount();
            }
            case 4: {
                return posTransaction.getPaymentTypeString().replaceAll("_", " ");
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.b;
    }

    public void setItems(List<PosTransaction> list) {
        this.b = list;
    }
}

