/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.DailySummaryReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class DailySummaryReportView
extends TransparentPanel {
    private JButton a;
    private JComboBox b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JPanel e;
    private JComboBox f;

    public DailySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        DailySummaryReportData dailySummaryReportData;
        CashDrawer cashDrawer;
        Object object;
        StoreSession storeSession2;
        Date date;
        Date date2 = this.c.getDate();
        if (date2.after(date = this.d.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User user = null;
        if (this.f.getSelectedItem() instanceof User) {
            user = (User)this.f.getSelectedItem();
        }
        Terminal terminal = null;
        if (this.b.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.b.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        date2 = calendar.getTime();
        calendar.clear();
        calendar2.setTime(date);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        date = calendar.getTime();
        List<StoreSession> list = StoreSessionDAO.getInstance().findSessions(date2, date);
        ArrayList<DailySummaryReportData> arrayList = new ArrayList<DailySummaryReportData>();
        for (StoreSession storeSession2 : list) {
            object = CashDrawerDAO.getInstance().findByStoreOperationData(storeSession2);
            cashDrawer = PosPrintService.populateCashDrawerReportSummary(object);
            cashDrawer.setStartTime(storeSession2.getOpenTime());
            cashDrawer.setAssignedBy(storeSession2.getOpenedBy());
            cashDrawer.setReportTime(storeSession2.getCloseTime());
            cashDrawer.setClosedBy(storeSession2.getClosedBy());
            dailySummaryReportData = new DailySummaryReportData();
            dailySummaryReportData.setPeriod(DateUtil.formatFullDateAsString(cashDrawer.getStartTime()));
            String string = storeSession2.getId();
            String string2 = string.substring(string.length() - 4, string.length());
            dailySummaryReportData.setSessionID(string2);
            double d = CashDrawerDAO.getInstance().getSumOfOpeningBalance(storeSession2);
            dailySummaryReportData.setOpeningBalance(d);
            dailySummaryReportData.setDeposit(cashDrawer.getCashToDeposit());
            dailySummaryReportData.setOverOutage(cashDrawer.getCashToDeposit() - cashDrawer.getDrawerAccountable());
            dailySummaryReportData.setCash(cashDrawer.getCashReceiptAmount());
            dailySummaryReportData.setTips(cashDrawer.getTipsPaid());
            dailySummaryReportData.setOnAccount(cashDrawer.getCashReceiptAmount() - d);
            double d2 = cashDrawer.getCustomPaymentAmount() != null ? cashDrawer.getCustomPaymentAmount() : 0.0;
            dailySummaryReportData.setOtherPayment(d2 + cashDrawer.getGiftCardAddBalance() + cashDrawer.getCreditCardReceiptAmount() + cashDrawer.getDebitCardReceiptAmount());
            dailySummaryReportData.setPayInOut(0.0 + cashDrawer.getPayOutAmount() * -1.0);
            dailySummaryReportData.setVoids(cashDrawer.getTotalVoid());
            int n = StoreSessionDAO.getInstance().getStoreSessionTotalGuest(storeSession2);
            dailySummaryReportData.setTotalGuest(n);
            arrayList.add(dailySummaryReportData);
        }
        if (arrayList.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("DailySummaryReportView.0"));
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("daily_summary_subreport"));
        storeSession2 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("daily_summary_report"));
        object = new HashMap();
        ReportUtil.populateRestaurantProperties((Map)object);
        ((HashMap)object).put("reportTitle", POSConstants.DAILY_SUMMARY_REPORT);
        ((HashMap)object).put("reportTime", ReportService.formatFullDate(new Date()));
        ((HashMap)object).put("fromDay", ReportService.formatFullDate(date2));
        ((HashMap)object).put("toDay", ReportService.formatFullDate(date));
        ((HashMap)object).put(POSConstants.TYPE, POSConstants.BY_RANGE_ACTUAL);
        ((HashMap)object).put("type", user == null ? POSConstants.ALL : user.getFullName());
        ((HashMap)object).put("cntr", terminal == null ? POSConstants.ALL : terminal.getName());
        ((HashMap)object).put("dailySummaryReport", jasperReport);
        ((HashMap)object).put("dailySummaryReportDatasource", new JRTableModelDataSource((TableModel)new DailySummaryReportModel(arrayList)));
        cashDrawer = JasperFillManager.fillReport((JasperReport)storeSession2, (Map)object, (JRDataSource)new JREmptyDataSource());
        dailySummaryReportData = new JRViewer((JasperPrint)cashDrawer);
        this.e.removeAll();
        this.e.add((Component)((Object)dailySummaryReportData));
        this.e.revalidate();
    }

    private void b() {
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DailySummaryReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.b = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list2 = terminalDAO.findAll();
        list2.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list2));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        jPanel.add(this.b);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.e = new JPanel(new BorderLayout());
        jPanel2.add(this.e);
        this.add(jPanel2);
    }

    public static class DailySummaryReportData {
        private String a;
        private String b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private int l;
        private double m;
        private double n;

        public String getPeriod() {
            return this.a;
        }

        public void setPeriod(String string) {
            this.a = string;
        }

        public double getDeposit() {
            return this.d;
        }

        public void setDeposit(double d) {
            this.d = d;
        }

        public double getOverOutage() {
            return this.e;
        }

        public void setOverOutage(double d) {
            this.e = d;
        }

        public double getCash() {
            return this.f;
        }

        public void setCash(double d) {
            this.f = d;
        }

        public double getOnAccount() {
            return this.h;
        }

        public void setOnAccount(double d) {
            this.h = d;
        }

        public double getOtherPayment() {
            return this.i;
        }

        public void setOtherPayment(double d) {
            this.i = d;
        }

        public double getPayInOut() {
            return this.j;
        }

        public void setPayInOut(double d) {
            this.j = d;
        }

        public double getVoids() {
            return this.k;
        }

        public void setVoids(double d) {
            this.k = d;
        }

        public int getTotalGuest() {
            return this.l;
        }

        public void setTotalGuest(int n) {
            this.l = n;
        }

        public double getAvgChk() {
            return this.m;
        }

        public void setAvgChk(double d) {
            this.m = d;
        }

        public String getSessionID() {
            return this.b;
        }

        public void setSessionID(String string) {
            this.b = string;
        }

        public double getOpeningBalance() {
            return this.c;
        }

        public void setOpeningBalance(double d) {
            this.c = d;
        }

        public double getTips() {
            return this.g;
        }

        public void setTips(double d) {
            this.g = d;
        }

        public double getRefund() {
            return this.n;
        }

        public void setRefund(double d) {
            this.n = d;
        }
    }
}

