/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class MenuUsageReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public MenuUsageReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuUsageReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(MenuUsageReportView.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void a() throws Exception {
        Date date;
        Date date2 = this.a.getDate();
        if (date2.after(date = this.b.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        date2 = DateUtil.startOfDay(date2);
        date = DateUtil.endOfDay(date);
        ReportService reportService = new ReportService();
        MenuUsageReport menuUsageReport = reportService.getMenuUsageReport(date2, date);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("MENU_USAGE_REPORT"));
        hashMap.put("fromDate", ReportService.formatShortDate(date2));
        hashMap.put("toDate", ReportService.formatShortDate(date));
        hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
        hashMap.put("currency", CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("menu_usage_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)menuUsageReport.getTableModel()));
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.d.removeAll();
        this.d.add((Component)jRViewer);
        this.d.revalidate();
    }
}

