/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReceiptPrintService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    private static Log a = LogFactory.getLog(ReportUtil.class);
    private static final String b = "/printerlayouts/";
    private static final String c = "/com/floreantpos/report/template/";

    public static void populateRestaurantProperties(Map map) {
        ReportUtil.populateRestaurantProperties(map, false);
    }

    public static void populateRestaurantProperties(Map map, boolean bl) {
        JasperReport jasperReport = null;
        jasperReport = bl ? ReportUtil.getReport("report_header_portrait") : ReportUtil.getReport(PaperSize.getReportNameAccording2Size("report_header"));
        Store store = StoreDAO.getRestaurant();
        if (store != null) {
            map.put("restaurantName", store.getName());
            map.put("addressLine1", store.getAddressLine1());
            map.put("addressLine2", store.getAddressLine2());
            map.put("addressLine3", store.getAddressLine3());
            map.put("phone", store.getTelephone());
            map.put("reportHeader", jasperReport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JasperReport getReport(String string) {
        JasperReport jasperReport;
        InputStream inputStream = null;
        try {
            inputStream = ReceiptPrintService.class.getResourceAsStream(b + string + ".jasper");
            if (inputStream == null) {
                if (new File(ReceiptPrintService.class.getResource(b + string + ".jrxml").getFile()) != null) {
                    JasperReport jasperReport2 = ReportUtil.a(string);
                    IOUtils.closeQuietly((InputStream)inputStream);
                    return jasperReport2;
                }
                throw new Exception();
            }
            jasperReport = (JasperReport)JRLoader.loadObject((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (Exception exception) {
            JasperReport jasperReport3 = ReportUtil.b(string);
            return jasperReport3;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return jasperReport;
    }

    private static JasperReport a(String string) throws Exception {
        JasperReport jasperReport;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            File file2 = new File(ReceiptPrintService.class.getResource(b + string + ".jrxml").getFile());
            File file3 = file2.getParentFile();
            file = new File(file3, string + ".jasper");
            inputStream = ReceiptPrintService.class.getResourceAsStream(b + string + ".jrxml");
            fileOutputStream = new FileOutputStream(file);
            JasperCompileManager.compileReportToStream((InputStream)inputStream, (OutputStream)fileOutputStream);
            inputStream2 = ReceiptPrintService.class.getResourceAsStream(b + string + ".jasper");
            jasperReport = (JasperReport)JRLoader.loadObject((InputStream)inputStream2);
        }
        catch (Exception exception) {
            try {
                PosLog.info(ReportUtil.class, exception + "");
                IOUtils.closeQuietly(fileOutputStream);
                if (file != null) {
                    file.delete();
                }
                throw exception;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(inputStream2);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)inputStream2);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        return jasperReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperReport b(String string) {
        InputStream inputStream = null;
        try {
            inputStream = ReceiptPrintService.class.getResourceAsStream(c + string + ".jasper");
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return jasperReport;
        }
        catch (Exception exception) {
            a.error((Object)exception);
            JasperReport jasperReport = null;
            return jasperReport;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void main(String[] stringArray) {
        URL uRL = ReceiptPrintService.class.getResource("/printerlayouts/ticket-receipt.jrxml");
        String string = uRL.getFile();
        PosLog.info(ReportUtil.class, uRL.getProtocol());
        PosLog.info(ReportUtil.class, string);
    }
}

