/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.SalesSummaryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXDatePicker;

public class ShiftwiseSalesSummaryReportView
extends JPanel {
    public static final int REPORT_KEY_STATISTICS = 1;
    public static final int REPORT_SALES_ANALYSIS = 2;
    private int a;
    private JButton b;
    private JComboBox c;
    private JComboBox d;
    private JXDatePicker e;
    private JLabel f;
    private JLabel g;
    private JLabel h;
    private JLabel i;
    private JSeparator j;
    private JPanel k;
    private JXDatePicker l;
    private SimpleDateFormat m = new SimpleDateFormat("dd MMM yyyy, hh:mm a");
    private SimpleDateFormat n = new SimpleDateFormat("dd MMM yyyy");
    private Date o;
    private Date p;
    private int q;
    private UserType r;
    private Terminal s;

    public ShiftwiseSalesSummaryReportView() {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        Vector<UserType> vector = new Vector<UserType>();
        vector.add(null);
        vector.addAll(list);
        this.d.setModel(new DefaultComboBoxModel(vector));
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list2 = terminalDAO.findAll();
        list2.add(0, (Terminal)((Object)POSConstants.ALL));
        this.c.setModel(new ListComboBoxModel(list2));
    }

    private void a() {
        this.f = new JLabel();
        this.g = new JLabel();
        this.h = new JLabel();
        this.i = new JLabel();
        this.e = UiUtil.getCurrentMonthStart();
        this.l = UiUtil.getCurrentMonthEnd();
        this.d = new JComboBox();
        this.c = new JComboBox();
        this.b = new JButton();
        this.j = new JSeparator();
        this.k = new JPanel();
        this.f.setText(POSConstants.FROM + ":");
        this.g.setText(POSConstants.TO + ":");
        this.h.setText(POSConstants.EMPLOYEE_TYPE + ":");
        this.i.setText(POSConstants.TERMINAL_LABEL + ":");
        this.b.setText(POSConstants.GO);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShiftwiseSalesSummaryReportView.this.a(actionEvent);
            }
        });
        this.k.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.j, -1, 502, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.f).add((Component)this.g)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.l, -1, -1, Short.MAX_VALUE).add((Component)this.e, -1, -1, Short.MAX_VALUE)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.h).add((Component)this.i)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.c, 0, -1, Short.MAX_VALUE).add((Component)this.d, 0, 137, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.b, -2, 72, -2)).add((Component)this.k, -1, 502, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.h).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.d, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.i).add((Component)this.c, -2, -1, -2).add((Component)this.b))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.f).add((Component)this.e, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.g).add((Component)this.l, -2, -1, -2)))).addPreferredGap(0).add((Component)this.j, -2, 10, -2).addPreferredGap(0).add((Component)this.k, -1, 303, Short.MAX_VALUE).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.c, this.d, this.h, this.i}, 2);
        groupLayout.linkSize(new Component[]{this.e, this.f, this.g, this.l}, 2);
    }

    private boolean b() {
        this.o = this.e.getDate();
        this.p = this.l.getDate();
        if (this.o.after(this.p)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return false;
        }
        this.q = (int)((double)(this.p.getTime() - this.o.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1;
        this.r = (UserType)this.d.getSelectedItem();
        this.s = null;
        if (this.c.getSelectedItem() instanceof Terminal) {
            this.s = (Terminal)this.c.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.o);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.o = calendar.getTime();
        calendar.clear();
        calendar2.setTime(this.p);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        this.p = calendar.getTime();
        return true;
    }

    private void a(ActionEvent actionEvent) {
        try {
            if (!this.b()) {
                return;
            }
            if (this.a == 1) {
                this.d();
            } else if (this.a == 2) {
                this.c();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> list = salesSummaryDAO.findSalesAnalysis(this.o, this.p, this.r, this.s);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        hashMap.put("reportTime", DateUtil.formatFullDateAndTimeAsString(new Date()));
        hashMap.put("fromDate", DateUtil.formatFullDateAsString(this.o));
        hashMap.put("toDate", DateUtil.formatFullDateAsString(this.p));
        hashMap.put("currency", CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        if (this.r == null) {
            hashMap.put("reportType", POSConstants.SYSTEM_TOTAL);
        } else {
            hashMap.put("reportType", this.r.getName());
        }
        hashMap.put("terminal", this.s == null ? POSConstants.ALL : this.s.getName());
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("shiftwise_sales_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new ShiftwiseSalesSummaryReportModel(list)));
        this.a(jasperPrint);
    }

    private void d() throws Exception {
        SalesSummaryDAO salesSummaryDAO = new SalesSummaryDAO();
        SalesStatistics salesStatistics = salesSummaryDAO.findKeyStatistics(this.o, this.p, this.r, this.s);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        hashMap.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerSeat", NumberUtil.formatNumber(salesStatistics.getGuestPerSeat()));
        hashMap.put("reportTime", this.m.format(new Date()));
        hashMap.put("fromDate", this.n.format(this.o));
        hashMap.put("toDate", this.n.format(this.p));
        hashMap.put("currency", CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        if (this.r == null) {
            hashMap.put("reportType", POSConstants.SYSTEM_TOTAL);
        } else {
            hashMap.put("reportType", this.r.getName());
        }
        hashMap.put("shift", POSConstants.ALL);
        hashMap.put("centre", this.s == null ? POSConstants.ALL : this.s.getName());
        hashMap.put("days", String.valueOf(this.q));
        hashMap.put("Capacity", String.valueOf(salesStatistics.getCapacity()));
        hashMap.put("GuestCount", String.valueOf(salesStatistics.getGuestCount()));
        hashMap.put("GuestPerSeat", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("TableTrnOvr", NumberUtil.formatNumber(salesStatistics.getTableTurnOver()));
        hashMap.put("AVGGuest", NumberUtil.formatNumber(salesStatistics.getAvgGuest()));
        hashMap.put("OpenChecks", String.valueOf(salesStatistics.getOpenChecks()));
        hashMap.put("VOIDChecks", String.valueOf(salesStatistics.getVoidChecks()));
        hashMap.put("OPPDChecks", String.valueOf(" "));
        hashMap.put("TRNGChecks", String.valueOf(" "));
        hashMap.put("ROPNChecks", String.valueOf(salesStatistics.getRopnChecks()));
        hashMap.put("MergeChecks", String.valueOf(" "));
        hashMap.put("LaborHour", NumberUtil.formatNumber(salesStatistics.getLaborHour()));
        hashMap.put("LaborSales", NumberUtil.formatNumber(salesStatistics.getGrossSale()));
        hashMap.put("Tables", String.valueOf(salesStatistics.getTables()));
        hashMap.put("CheckCount", String.valueOf(salesStatistics.getCheckCount()));
        hashMap.put("GuestPerChecks", NumberUtil.formatNumber(salesStatistics.getGuestPerCheck()));
        hashMap.put("TrnOvrTime", String.valueOf(" "));
        hashMap.put("AVGChecks", NumberUtil.formatNumber(salesStatistics.getAvgCheck()));
        hashMap.put("OPENAmount", NumberUtil.formatNumber(salesStatistics.getOpenAmount()));
        hashMap.put("VOIDAmount", NumberUtil.formatNumber(salesStatistics.getVoidAmount()));
        hashMap.put("PAIDChecks", String.valueOf(salesStatistics.getPaidChecks()));
        hashMap.put("TRNGAmount", String.valueOf(" "));
        hashMap.put("ROPNAmount", NumberUtil.formatNumber(salesStatistics.getRopnAmount()));
        hashMap.put("NTaxChecks", String.valueOf(salesStatistics.getNtaxChecks()));
        hashMap.put("NTaxAmount", NumberUtil.formatNumber(salesStatistics.getNtaxAmount()));
        hashMap.put("MergeAmount", String.valueOf(" "));
        hashMap.put("Labor", NumberUtil.formatNumber(salesStatistics.getLaborCost()));
        hashMap.put("LaborCost", NumberUtil.formatNumber(salesStatistics.getLaborCost() / salesStatistics.getGrossSale() * 100.0));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("key_statistics_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new SalesStatistics.ShiftwiseDataTableModel(salesStatistics.getSalesTableDataList())));
        this.a(jasperPrint);
    }

    private void a(JasperPrint jasperPrint) {
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.k.removeAll();
        this.k.add((Component)jRViewer);
        this.k.revalidate();
    }

    public int getReportType() {
        return this.a;
    }

    public void setReportType(int n) {
        this.a = n;
    }
}

