/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.StaffBankReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class StaffBankReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JComboBox<Date> d;
    private JComboBox<Date> e;
    private JPanel f;
    private JPanel g;
    private AutoCompletionComboBox h;

    public StaffBankReportView() {
        this.setLayout(new BorderLayout());
        this.a();
    }

    private void a() {
        TimeComboBox timeComboBox = new TimeComboBox();
        this.d = timeComboBox.getDefaultTimeComboBox();
        this.e = timeComboBox.getDefaultTimeComboBox();
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    StaffBankReportView.this.b();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.h = new AutoCompletionComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.h.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(Messages.getString("StaffBankReportView.0") + ":"));
        jPanel.add((Component)this.h, "width 160!");
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        jPanel.add((Component)this.b);
        jPanel.add(this.d);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        jPanel.add((Component)this.c);
        jPanel.add(this.e);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.f = new JPanel(new BorderLayout());
        jPanel2.add(this.f);
        this.add(jPanel2);
    }

    private void b() throws Exception {
        List<CashDrawer> list;
        Date date = this.b.getDate();
        Date date2 = this.c.getDate();
        Date date3 = (Date)this.d.getSelectedItem();
        Date date4 = (Date)this.e.getSelectedItem();
        date = DateUtil.copyTime(date, date3);
        date2 = DateUtil.copyTime(date2, date4);
        if (date == null || date2 == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("StaffBankReportView.2"));
            return;
        }
        if (date.after(date2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Object object = this.h.getSelectedItem();
        User user = null;
        if (object instanceof User) {
            user = (User)object;
        }
        if ((list = CashDrawerDAO.getInstance().findStaffBank(date, date2, user)) == null || list.size() < 1) {
            this.f.removeAll();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("StaffBankReportView.3"));
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("staff-bank-report"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("StaffBankReportView.5"));
        hashMap.put("reportDate", Messages.getString("StaffBankReportView.6") + ReportService.formatFullDate(new Date()));
        hashMap.put("startDate", Messages.getString("StaffBankReportView.7") + ReportService.formatFullDate(date));
        hashMap.put("endDate", Messages.getString("StaffBankReportView.8") + ReportService.formatFullDate(date2));
        hashMap.put("netSalesHeader", Messages.getString("StaffBankReportView.10") + "(" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("cashToDepositeHeader", Messages.getString("StaffBankReportView.14") + "(" + CurrencyUtil.getCurrencySymbol() + ")");
        StaffBankReportModel staffBankReportModel = new StaffBankReportModel();
        staffBankReportModel.setRows(list);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)staffBankReportModel));
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.f.removeAll();
        this.f.add((Component)jRViewer);
        this.f.revalidate();
    }

    public JComponent $$$getRootComponent$$$() {
        return this.g;
    }
}

