/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TicketReportModel
extends AbstractTableModel {
    private static DecimalFormat a = new DecimalFormat("#,##0.00");
    private String[] b = new String[]{"id", "date", "orderType", "owner", "total", "due"};
    private List<Ticket> c;
    private double d;
    private double e;

    @Override
    public int getRowCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Ticket ticket = this.c.get(n);
        switch (n2) {
            case 0: {
                return String.valueOf(ticket.getId());
            }
            case 1: {
                return DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate());
            }
            case 2: {
                return ticket.getOrderType().getName();
            }
            case 3: {
                return ticket.getOwner().getFullName();
            }
            case 4: {
                return NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            }
            case 5: {
                return NumberUtil.formatNumber(ticket.getDueAmount());
            }
        }
        return null;
    }

    public List<Ticket> getItems() {
        return this.c;
    }

    public void setItems(List<Ticket> list) {
        this.c = list;
    }

    public String getGrandTotalAsString() {
        return a.format(this.d);
    }

    public void setGrandTotal(double d) {
        this.d = d;
    }

    public void calculateGrandTotal() {
        this.d = 0.0;
        if (this.c == null) {
            return;
        }
        for (Ticket ticket : this.c) {
            this.d += ticket.getDueAmount().doubleValue();
        }
    }

    public String getTotalDueAsString() {
        return a.format(this.e);
    }

    public void setTotalDue(double d) {
        this.e = d;
    }

    public void calculateTotalDue() {
        this.e = 0.0;
        if (this.c == null) {
            return;
        }
        for (Ticket ticket : this.c) {
            this.e += ticket.getDueAmount().doubleValue();
        }
    }
}

