/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TracTipsReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jdesktop.swingx.JXDatePicker;

public class TracTipsReportView
extends TransparentPanel {
    private JButton a;
    private JComboBox b;
    private JXDatePicker c;
    private JXDatePicker d;
    private JPanel e;
    private JComboBox f;
    private Session g;

    public TracTipsReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        Object object;
        Object object22;
        Object object3;
        Date date;
        GenericDAO genericDAO = new GenericDAO();
        Date date2 = DateUtil.startOfDay(this.c.getDate());
        if (date2.after(date = DateUtil.endOfDay(this.d.getDate()))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User user = null;
        if (this.f.getSelectedItem() instanceof User) {
            user = (User)this.f.getSelectedItem();
        }
        Terminal terminal = null;
        if (this.b.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.b.getSelectedItem();
        }
        this.g = genericDAO.createNewSession();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<User> arrayList2 = new ArrayList<User>();
        if (user == null) {
            object3 = (ComboBoxModel)this.f.getModel();
            List serializable2 = ((ComboBoxModel)object3).getDataList();
            for (Object object22 : serializable2) {
                if (!(object22 instanceof User)) continue;
                arrayList2.add((User)object22);
            }
        } else {
            arrayList2.add(user);
        }
        for (User user2 : arrayList2) {
            if (!this.b(this.g, date2, date, user2) && !this.a(this.g, date2, date, user2)) continue;
            object = new TracTipsReportData();
            ((TracTipsReportData)object).setEmployeeID(user2.getId());
            ((TracTipsReportData)object).setEmployeeName(user2.getFullName());
            this.a((TracTipsReportData)object, this.g, date2, date, user2);
            this.b((TracTipsReportData)object, this.g, date2, date, user2);
            this.c((TracTipsReportData)object, this.g, date2, date, user2);
            this.d((TracTipsReportData)object, this.g, date2, date, user2);
            ((TracTipsReportData)object).setNetTips(((TracTipsReportData)object).getCreditCardTips() + ((TracTipsReportData)object).getTracCashTips() + ((TracTipsReportData)object).getDeclareTips());
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("TracTipsReportView.0"));
            return;
        }
        object3 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("track_tips_report"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        hashMap.put("reportTitle", Messages.getString("TracTipsReportView.2"));
        hashMap.put("reportTime", ReportService.formatFullDate(new Date()));
        hashMap.put("fromDay", ReportService.formatFullDate(date2));
        hashMap.put("toDay", ReportService.formatFullDate(date));
        hashMap.put("type", user == null ? POSConstants.ALL : user.getFullName());
        hashMap.put("cntr", terminal == null ? POSConstants.ALL : terminal.getName());
        object = new TracTipsReportModel();
        ((ListTableModel)object).setRows(arrayList);
        object22 = JasperFillManager.fillReport((JasperReport)object3, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)object));
        JRViewer jRViewer = new JRViewer(object22);
        this.e.removeAll();
        this.e.add((Component)jRViewer);
        this.e.revalidate();
    }

    private void b() {
        this.c = UiUtil.getCurrentMonthStart();
        this.d = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TracTipsReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new ComboBoxModel(vector));
        this.b = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> list2 = terminalDAO.findAll();
        list2.add(0, (Terminal)((Object)POSConstants.ALL));
        this.b.setModel(new ListComboBoxModel(list2));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.d.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.d);
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        jPanel.add(this.b);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.e = new JPanel(new BorderLayout());
        jPanel2.add(this.e);
        this.add(jPanel2);
    }

    private boolean a(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        if (number != null) {
            return number.intValue() > 0;
        }
        return false;
    }

    private boolean b(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        if (number != null) {
            return number.intValue() > 0;
        }
        return false;
    }

    private void a(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double d = (Double)criteria.uniqueResult();
        if (d != null) {
            tracTipsReportData.setGrossSales(d);
        }
    }

    private void b(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CreditCardTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double d = (Double)criteria.uniqueResult();
        criteria.setProjection(null);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double d2 = (Double)criteria.uniqueResult();
        if (d == null) {
            d = 0.0;
        }
        if (d2 == null) {
            d2 = 0.0;
        }
        double d3 = d - d2;
        Criteria criteria2 = session.createCriteria(DebitCardTransaction.class);
        criteria2.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria2.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double d4 = (Double)criteria2.uniqueResult();
        criteria2.setProjection(null);
        criteria2.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double d5 = (Double)criteria2.uniqueResult();
        if (d4 == null) {
            d4 = 0.0;
        }
        if (d5 == null) {
            d5 = 0.0;
        }
        double d6 = d4 - d5;
        double d7 = d3 + d6;
        tracTipsReportData.setCreditCardTips(d2 + d5);
        if (d2 <= 0.0 || d <= 0.0) {
            tracTipsReportData.setTracCreditCardTipsRate(0.0);
        }
        if (d7 > 0.0) {
            tracTipsReportData.setTracCreditCardTipsRate(tracTipsReportData.getCreditCardTips() * 100.0 / d7);
        }
        tracTipsReportData.setCreditCardSalesWithoutTips(d7);
    }

    private void c(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CashTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        Double d = (Double)criteria.uniqueResult();
        criteria.setProjection(null);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double d2 = (Double)criteria.uniqueResult();
        if (d == null) {
            d = 0.0;
        }
        if (d2 == null) {
            d2 = 0.0;
        }
        double d3 = d - d2;
        tracTipsReportData.setTracCashTips(d2);
        if (d2 <= 0.0 || d <= 0.0) {
            tracTipsReportData.setTracCashTipsRate(0.0);
        }
        if (d > 0.0) {
            tracTipsReportData.setTracCashTipsRate(d2 * 100.0 / d);
        }
        tracTipsReportData.setTracCashSalesWithoutTips(d3);
    }

    private void d(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
        Double d = (Double)criteria.uniqueResult();
        if (d != null) {
            tracTipsReportData.setDeclareTips(d);
        }
    }

    public static class TracTipsReportData {
        private String a;
        private String b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;

        public String getEmployeeID() {
            return this.a;
        }

        public void setEmployeeID(String string) {
            this.a = string;
        }

        public String getEmployeeName() {
            return this.b;
        }

        public void setEmployeeName(String string) {
            this.b = string;
        }

        public double getGrossSales() {
            return this.c;
        }

        public void setGrossSales(double d) {
            this.c = d;
        }

        public double getCreditCardTips() {
            return this.e;
        }

        public void setCreditCardTips(double d) {
            this.e = d;
        }

        public double getTracCreditCardTipsRate() {
            return this.f;
        }

        public void setTracCreditCardTipsRate(double d) {
            this.f = d;
        }

        public double getTracCashTips() {
            return this.h;
        }

        public void setTracCashTips(double d) {
            this.h = d;
        }

        public double getTracCashTipsRate() {
            return this.i;
        }

        public void setTracCashTipsRate(double d) {
            this.i = d;
        }

        public double getTipsPaid() {
            return this.j;
        }

        public void setTipsPaid(double d) {
            this.j = d;
        }

        public double getNetTips() {
            return this.k;
        }

        public void setNetTips(double d) {
            this.k = d;
        }

        public double getCreditCardSalesWithoutTips() {
            return this.d;
        }

        public void setCreditCardSalesWithoutTips(double d) {
            this.d = d;
        }

        public double getTracCashSalesWithoutTips() {
            return this.g;
        }

        public void setTracCashSalesWithoutTips(double d) {
            this.g = d;
        }

        public double getDeclareTips() {
            return this.l;
        }

        public void setDeclareTips(double d) {
            this.l = d;
        }
    }
}

