/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class UserTypeForm
extends BeanEditor {
    private JLabel a;
    private JLabel b;
    private JScrollPane c;
    private CheckBoxList<UserPermission> d;
    private JTextField e;
    private JPanel f;
    private JPanel g;

    public UserTypeForm() {
        this(new UserType());
    }

    public UserTypeForm(UserType userType) {
        this.a();
        this.d.setModel((UserPermission[])UserPermission.permissions);
        this.setBean(userType);
    }

    private void a() {
        this.a = new JLabel();
        this.e = new JTextField();
        this.b = new JLabel();
        this.c = new JScrollPane();
        this.d = new CheckBoxList();
        this.d.setTableHeaderHide(true);
        this.f = new JPanel(new BorderLayout(5, 5));
        this.f.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.g = new JPanel(new BorderLayout(5, 5));
        this.g.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.a.setText(POSConstants.TYPE_NAME + ":");
        this.b.setText(POSConstants.PERMISSIONS + ":");
        this.c.setViewportView(this.d);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.f.add((Component)this.a, "West");
        this.f.add(this.e);
        this.g.add((Component)this.b, "West");
        this.g.add((Component)this.c, "Center");
        this.add((Component)this.f, "North");
        this.add((Component)this.g, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(illegalModelStateException.getMessage());
            return false;
        }
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        userTypeDAO.saveOrUpdate(this.getUserType());
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        UserType userType = this.getUserType();
        if (userType == null) {
            userType = new UserType();
        }
        String string = this.e.getText();
        GenericDAO.getInstance().checkIdOrNameExists(userType.getId(), string, UserType.class);
        userType.setName(string);
        userType.clearPermissions();
        List<UserPermission> list = this.d.getCheckedValues();
        for (int i = 0; i < list.size(); ++i) {
            userType.addTopermissions(list.get(i));
        }
        this.setBean(userType);
        return true;
    }

    @Override
    protected void updateView() {
        UserType userType = this.getUserType();
        if (userType.getId() == null) {
            this.d.clearSelection();
            return;
        }
        this.e.setText(userType.getName());
        Set<UserPermission> set = userType.getPermissions();
        if (set == null) {
            this.d.clearSelection();
            return;
        }
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.d.getModel();
        for (UserPermission userPermission : set) {
            for (int i = 0; i < checkBoxListModel.getItems().size(); ++i) {
                CheckBoxList.Entry entry = checkBoxListModel.getItems().get(i);
                if (!entry.getValue().equals(userPermission)) continue;
                entry.setChecked(true);
            }
        }
        checkBoxListModel.fireTableDataChanged();
    }

    public UserType getUserType() {
        return (UserType)this.getBean();
    }

    @Override
    public String getDisplayText() {
        UserType userType = (UserType)this.getBean();
        if (userType == null || userType.getId() == null) {
            return Messages.getString("UserTypeForm.0");
        }
        return Messages.getString("UserTypeForm.1");
    }
}

