/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.DataUpdateInfo;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.DataUpdateInfoDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.OrderFilterPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.TicketListTableModel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TicketListView
extends JPanel
implements ITicketList,
DataChangeListener {
    private JXTable a;
    private TicketListTableModel b;
    private OrderFilterPanel c;
    private PosBlinkButton d;
    private PosButton e;
    private PosButton f;
    private TableColumnModelExt g;
    private ArrayList<TicketListUpdateListener> h = new ArrayList();
    private boolean i;
    private Date j;
    private String k;
    private POSToggleButton l;

    public TicketListView() {
        this.setLayout(new BorderLayout());
        this.c = new OrderFilterPanel(this);
        this.add((Component)((Object)this.c), "North");
        this.a();
        this.updateTicketList();
    }

    public TicketListView(String string, boolean bl) {
        this.i = bl;
        this.setLayout(new BorderLayout());
        this.a();
        this.updateTicketList();
    }

    private void a() {
        this.a = new JXTable();
        this.a.setSortable(true);
        this.a.setSelectionMode(0);
        this.a.setColumnControlVisible(true);
        this.b = new TicketListTableModel();
        this.a.setModel((TableModel)this.b);
        this.b.setPageSize(TerminalConfig.getOrderViewPageSize());
        this.a.setRowHeight(PosUIManager.getSize(60));
        this.a.setAutoResizeMode(3);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setGridColor(Color.LIGHT_GRAY);
        this.a.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.g = (TableColumnModelExt)this.a.getColumnModel();
        this.g.getColumn(0).setPreferredWidth(65);
        this.g.getColumn(1).setPreferredWidth(30);
        this.g.getColumn(2).setPreferredWidth(20);
        this.g.getColumn(3).setPreferredWidth(100);
        this.g.getColumn(4).setPreferredWidth(100);
        if (this.i) {
            this.g.getColumnExt(1).setVisible(false);
            this.g.getColumnExt(1).setVisible(false);
            this.g.getColumnExt(6).setVisible(false);
            this.g.getColumnExt(8).setVisible(false);
            this.e();
            return;
        }
        this.c();
        this.b();
        this.e();
    }

    private void b() {
        this.g.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                TicketListView.this.d();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                TicketListView.this.d();
            }
        });
    }

    private void c() {
        String string = TerminalConfig.getTicketListViewHiddenColumns();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.a.getColumnModel();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\*");
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = Integer.parseInt(stringArray[i]);
            tableColumnModelExt.getColumnExt(n - i).setVisible(false);
        }
    }

    private void d() {
        List list = this.g.getColumns(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumn tableColumn : list) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            if (tableColumnExt.isVisible()) continue;
            arrayList.add(tableColumnExt.getModelIndex());
        }
        this.a(arrayList);
    }

    private void e() {
        if (!this.i) {
            this.l = new POSToggleButton();
            this.l.setIcon(IconFactory.getIcon("/ui_icons/", "filter-16.png"));
            this.a(TerminalConfig.isOrderFilterPanelVisible());
        }
        this.d = new PosBlinkButton(IconFactory.getIcon("/ui_icons/", "refresh-16.png"));
        this.e = new PosButton(IconFactory.getIcon("/ui_icons/", "previous-24.png"));
        this.f = new PosButton(IconFactory.getIcon("/ui_icons/", "next-24.png"));
        this.createActionHandlers();
        PosScrollPane posScrollPane = new PosScrollPane((Component)this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setUI(new CustomScrollbarUI());
        int n = PosUIManager.getSize(40);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        ColumnControlButton columnControlButton = new ColumnControlButton(this.a);
        if (!this.i) {
            jPanel.add((Component)columnControlButton, "h " + n + "!, grow, wrap");
        }
        jPanel.add((Component)this.d, "h " + n + "!, grow, wrap");
        jPanel.add((Component)this.e, "h " + n + "!, grow, wrap");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        jPanel2.add((Component)this.f, "h " + n + "!, grow,gaptop 5, wrap");
        if (!this.i) {
            jPanel2.add((Component)this.l, "h " + n + "!,grow, wrap");
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel3.setPreferredSize(PosUIManager.getSize(48, 0));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        JScrollBar jScrollBar = posScrollPane.getVerticalScrollBar();
        jPanel3.add(jScrollBar);
        this.add(posScrollPane);
        this.add((Component)jPanel3, "East");
    }

    public void createActionHandlers() {
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TicketListView.this.b.hasPrevious()) {
                    TicketListView.this.b.setCurrentRowIndex(TicketListView.this.b.getPreviousRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.b);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TicketListView.this.b.hasNext()) {
                    TicketListView.this.b.setCurrentRowIndex(TicketListView.this.b.getNextRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.b);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketListView.this.getTableModel().setCurrentRowIndex(0);
                if (TicketListView.this.k != null) {
                    TicketListView.this.updateCustomerTicketList(TicketListView.this.k);
                } else {
                    TicketListView.this.updateTicketList();
                }
            }
        });
        if (!this.i) {
            this.l.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TicketListView.this.c.setCollapsed(!TicketListView.this.c.isCollapsed());
                    TerminalConfig.setOrderFilterPanelVisible(TicketListView.this.l.isSelected());
                }
            });
        }
    }

    public void updateButtonStatus() {
        this.f.setEnabled(this.b.hasNext());
        this.e.setEnabled(this.b.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        try {
            this.b.setCurrentRowIndex(0);
            this.b.setNumRows(TicketDAO.getInstance().getNumTickets());
            TicketDAO.getInstance().loadTickets(this.b);
            this.d.setBlinking(false);
            this.updateButtonStatus();
            for (int i = 0; i < this.h.size(); ++i) {
                TicketListUpdateListener ticketListUpdateListener = this.h.get(i);
                ticketListUpdateListener.ticketListUpdated();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateCustomerTicketList(String string) {
        this.k = string;
        try {
            Application.getPosWindow().setGlassPaneVisible(true);
            TicketListTableModel ticketListTableModel = this.getTableModel();
            List<Ticket> list = TicketDAO.getInstance().findCustomerTickets(string, ticketListTableModel);
            this.setTickets(list);
            this.d.setBlinking(false);
            for (int i = 0; i < this.h.size(); ++i) {
                TicketListUpdateListener ticketListUpdateListener = this.h.get(i);
                ticketListUpdateListener.ticketListUpdated();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), exception);
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
    }

    public void addTicketListUpateListener(TicketListUpdateListener ticketListUpdateListener) {
        this.h.add(ticketListUpdateListener);
    }

    public void setTickets(List<Ticket> list) {
        this.b.setRows(list);
    }

    public void addTicket(Ticket ticket) {
        this.b.addItem(ticket);
    }

    @Override
    public Ticket getSelectedTicket() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (Ticket)this.b.getRowData(this.a.convertRowIndexToModel(n));
    }

    public List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            return null;
        }
        arrayList.add(ticket);
        return arrayList;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> list = this.getSelectedTickets();
        if (list.size() == 0 || list.size() > 1) {
            POSMessageDialog.showMessage(Messages.getString("TicketListView.14"));
            return null;
        }
        Ticket ticket = list.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JXTable getTable() {
        return this.a;
    }

    public TicketListTableModel getTableModel() {
        return this.b;
    }

    public void setCurrentRowIndexZero() {
        this.getTableModel().setCurrentRowIndex(0);
    }

    public void setAutoUpdateCheck(boolean bl) {
        if (bl) {
            // empty if block
        }
    }

    private void a(boolean bl) {
        if (bl) {
            this.c.setCollapsed(!TerminalConfig.isOrderFilterPanelVisible());
            this.l.setSelected(!this.c.isCollapsed());
        }
    }

    private void a(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + "*";
        }
        TerminalConfig.setTicketListViewHiddenColumns(string);
    }

    @Override
    public void dataAdded(Object object) {
        if (object == null) {
            return;
        }
        TicketListTableModel ticketListTableModel = this.getTableModel();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        arrayList.add((Ticket)object);
        arrayList.addAll(ticketListTableModel.getRows());
        ticketListTableModel.setRows(arrayList);
        ticketListTableModel.setNumRows(ticketListTableModel.getNumRows() + 1);
        this.updateButtonStatus();
    }

    @Override
    public void dataChanged(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        int n = this.a(ticket);
        if (!ticket.isClosed().booleanValue() && paymentStatusFilter == PaymentStatusFilter.OPEN) {
            if (n == -1) {
                this.dataAdded(ticket);
            }
        } else if (ticket.isClosed().booleanValue() && paymentStatusFilter != PaymentStatusFilter.CLOSED) {
            this.dataRemoved(ticket);
        } else {
            this.b.updateItem(n);
            this.a.getSelectionModel().addSelectionInterval(n, n);
        }
    }

    private int a(Ticket ticket) {
        List<Ticket> list = this.b.getRows();
        for (int i = 0; i < list.size(); ++i) {
            Ticket ticket2 = (Ticket)list.get(i);
            if (!ticket2.getId().equals(ticket.getId())) continue;
            list.set(i, ticket);
            return i;
        }
        return -1;
    }

    @Override
    public void dataRemoved(Object object) {
        if (object == null) {
            return;
        }
        this.b.deleteItem(object);
        this.b.setNumRows(this.b.getNumRows() - 1);
        this.b.fireTableDataChanged();
    }

    @Override
    public Object getSelectedData() {
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            GlobalInputDialog globalInputDialog = new GlobalInputDialog(Application.getPosWindow());
            globalInputDialog.setCaption(Messages.getString("TicketListView.20"));
            globalInputDialog.open();
            if (globalInputDialog.isCanceled()) {
                return null;
            }
            String string = globalInputDialog.getInput();
            ticket = TicketService.getTicket(string);
        }
        return ticket;
    }

    @Override
    public void dataSetUpdated() {
        this.updateTicketList();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        if (ticket.getId() == null) {
            return;
        }
        ticket = TicketDAO.getInstance().get(ticket.getId());
        this.dataChanged(ticket);
    }

    class CustomScrollbarUI
    extends BasicScrollBarUI {
        private ImageIcon b;
        private ImageIcon c = IconFactory.getIcon("/ui_icons/", "up.png");

        public CustomScrollbarUI() {
            this.b = IconFactory.getIcon("/ui_icons/", "down.png");
        }

        @Override
        protected JButton createDecreaseButton(int n) {
            PosButton posButton = new PosButton(this.a(n)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }
            };
            return posButton;
        }

        @Override
        protected JButton createIncreaseButton(int n) {
            PosButton posButton = new PosButton(this.a(n)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }
            };
            return posButton;
        }

        private ImageIcon a(int n) {
            switch (n) {
                case 5: {
                    return this.b;
                }
                case 1: {
                    return this.c;
                }
            }
            return this.c;
        }
    }

    private class TaskLastUpdateCheck
    implements ActionListener {
        private TaskLastUpdateCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            if (TicketListView.this.d.isBlinking()) {
                return;
            }
            DataUpdateInfo dataUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo();
            if (dataUpdateInfo == null) {
                return;
            }
            if (dataUpdateInfo.getLastUpdateTime().after(TicketListView.this.j)) {
                TicketListView.this.d.setBlinking(true);
            }
        }
    }
}

