/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardGeneratorView
extends POSDialog {
    private IntegerTextField a;
    private DoubleTextField b;
    private IntegerTextField c;
    private JComboBox d;
    private FixedLengthTextField e;
    private List<GiftCard> f;
    private FixedLengthTextField g;
    private boolean h;
    private POSTextField i;
    private JLabel j;
    private JLabel k;

    public GiftCardGeneratorView() {
        this(false);
    }

    public GiftCardGeneratorView(boolean bl) {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.h = bl;
        this.a();
    }

    public GiftCardGeneratorView(JFrame jFrame) {
        this.a();
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Gift Card Generation");
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,aligny center", "[][]", ""));
        this.j = new JLabel(Messages.getString("GiftCardGeneratorView.0"));
        this.i = new POSTextField();
        this.k = new JLabel(Messages.getString("GiftCardGeneratorView.4"));
        this.a = new IntegerTextField();
        JLabel jLabel = new JLabel(Messages.getString("GiftCardGeneratorView.5"));
        this.b = new DoubleTextField();
        JLabel jLabel2 = new JLabel(Messages.getString("GiftCardGeneratorView.6"));
        this.c = new IntegerTextField();
        this.d = new JComboBox();
        this.d.addItem("DAY");
        this.d.addItem("MONTH");
        this.d.addItem("YEAR");
        this.d.setSelectedItem("YEAR");
        this.e = new FixedLengthTextField(10);
        this.e.setLength(8);
        this.g = new FixedLengthTextField();
        this.g.setLength(32);
        this.c.setText("5");
        this.b.setText("0.00");
        String string = GiftCardGeneratorView.generateBatchNumber();
        this.g.setText("" + string);
        jPanel.add((Component)this.j, "alignx right");
        jPanel.add((Component)this.i, "growx,wrap");
        jPanel.add((Component)this.k, "alignx right");
        jPanel.add((Component)this.a, "growx,wrap");
        jPanel.add((Component)jLabel, "alignx right");
        jPanel.add((Component)this.b, "growx,wrap");
        jPanel.add((Component)new JLabel(Messages.getString("PinNumber")), "alignx right");
        jPanel.add((Component)this.e, "growx,wrap");
        jPanel.add((Component)new JLabel(Messages.getString("BatchNumber")), "alignx right");
        jPanel.add((Component)this.g, "growx,wrap");
        jPanel.add((Component)jLabel2, "alignx right");
        jPanel.add((Component)this.c, "growx");
        jPanel.add((Component)this.d, ",wrap");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton posButton = new PosButton(Messages.getString("Generate"));
        jPanel2.add((Component)posButton, "grow");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardGeneratorView.this.doGenerate();
            }
        });
        jPanel2.add(new PosButton(new CloseDialogAction(this)));
        this.add((Component)jPanel2, "South");
        this.b();
    }

    private void b() {
        this.j.setVisible(this.h);
        this.i.setVisible(this.h);
        this.k.setVisible(!this.h);
        this.a.setVisible(!this.h);
    }

    public static String generateBatchNumber() {
        String string = String.valueOf((long)(Math.random() * 1.0E8));
        String string2 = "00000000";
        string = string2.substring(string.length()) + string;
        if (GiftCardDAO.getInstance().hasBatchNo(string)) {
            return GiftCardGeneratorView.generateBatchNumber();
        }
        return string;
    }

    public void doGenerate() {
        try {
            if (this.c()) {
                GiftCardDAO.getInstance().saveAsList(this.f);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardGeneratorView.29"));
                this.dispose();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private boolean c() throws Exception {
        Object object;
        if (!(this.h || this.a.getText() != null && this.a.getInteger() != 0)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.30"));
            return false;
        }
        if (this.h) {
            String string = this.i.getText();
            if (string == null || string.isEmpty()) {
                POSMessageDialog.showError(this, Messages.getString("EnterCardNumber"));
                return false;
            }
            if (string.length() > 16) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.2"));
                return false;
            }
            object = GiftCardDAO.getInstance().get(string);
            if (object != null) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.3"));
                return false;
            }
        }
        if (StringUtils.isEmpty((String)this.b.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.31"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.c.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.32"));
            return false;
        }
        int n = this.c.getInteger();
        if (n == 0) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.33"));
            return false;
        }
        object = (String)this.d.getSelectedItem();
        if (StringUtils.isEmpty((String)object)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.34"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.e.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.35"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.g.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.36"));
            return false;
        }
        this.f = new ArrayList<GiftCard>();
        if (!this.h) {
            this.e();
        } else {
            this.d();
        }
        return true;
    }

    private void d() throws Exception {
        GiftCard giftCard = new GiftCard();
        giftCard.setCardNumber(this.i.getText());
        giftCard.setBalance(this.b.getDouble());
        giftCard.setPinNumber(this.e.getText());
        giftCard.setIssueDate(new Date());
        giftCard.setDuration(this.c.getInteger());
        giftCard.setDurationType((String)this.d.getSelectedItem());
        giftCard.setBatchNo(this.g.getText());
        this.f.add(giftCard);
    }

    private void e() throws Exception {
        int n = this.a.getInteger();
        for (int i = 0; i < n; ++i) {
            GiftCard giftCard = new GiftCard();
            String string = String.valueOf((long)(Math.random() * 1.0E16));
            String string2 = "0000000000000000";
            string = string2.substring(string.length()) + string;
            giftCard.setCardNumber(string);
            giftCard.setBalance(this.b.getDouble());
            giftCard.setPinNumber(this.e.getText());
            giftCard.setIssueDate(new Date());
            giftCard.setDuration(this.c.getInteger());
            giftCard.setDurationType((String)this.d.getSelectedItem());
            giftCard.setBatchNo(this.g.getText());
            this.f.add(giftCard);
        }
    }
}

