/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.util.CurrencyUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;

public class NumberUtil {
    private static final NumberFormat a = NumberFormat.getNumberInstance();
    private static final NumberFormat b = NumberFormat.getNumberInstance();
    private static final DecimalFormat c = new DecimalFormat("#.##");
    private static final NumberFormat d = new DecimalFormat("0.00");

    public static double round(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public static BigDecimal round(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public static double round(double d, int n) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToOneDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(1, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToTwoDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(2, 4);
        return bigDecimal.doubleValue();
    }

    public static double roundToThreeDigit(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        bigDecimal = bigDecimal.setScale(3, 4);
        return bigDecimal.doubleValue();
    }

    public static String format3DigitNumber(Double d) {
        if (d == null) {
            return b.format(0L);
        }
        String string = b.format(d);
        return string;
    }

    public static String formatNumber(Double d, boolean bl) {
        if (d == null) {
            return a.format(0L);
        }
        String string = a.format(d);
        if (!bl && string.startsWith("-")) {
            return a.format(0L);
        }
        return string;
    }

    public static String formatNumber(Double d) {
        return NumberUtil.formatNumber(d, false);
    }

    public static String trimDecilamIfNotNeeded(Double d) {
        return NumberUtil.trimDecilamIfNotNeeded(d, false);
    }

    public static String trimDecilamIfNotNeeded(Double d, boolean bl) {
        if (d == null) {
            return c.format(0L);
        }
        String string = c.format(d);
        if (bl) {
            return string;
        }
        if (string.startsWith("-")) {
            return c.format(0L);
        }
        return string;
    }

    public static String formatNumberAcceptNegative(Double d) {
        if (d == null) {
            return a.format(0L);
        }
        return a.format(d);
    }

    public static Number parse(String string) throws ParseException {
        if (StringUtils.isEmpty((String)string)) {
            return 0;
        }
        return a.parse(string);
    }

    public static Number parseOrGetZero(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                return 0;
            }
            return a.parse(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String getCurrencyFormat(Object object) {
        return CurrencyUtil.getCurrencySymbol() + d.format(object);
    }

    public static String getCurrencyFormatWithoutCurrencySymbol(Object object) {
        return d.format(object);
    }

    public static BigDecimal convertToBigDecimal(double d) {
        return new BigDecimal(Double.toString(d));
    }

    public static BigDecimal convertToBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public static boolean isZero(Double d) {
        String string = a.format(d);
        return string.equals("0.00") || string.equals("-0.00");
    }

    public static Boolean isFractional(String string) {
        try {
            return NumberUtil.isFractional(Double.parseDouble(string));
        }
        catch (Exception exception) {
            PosLog.error(NumberUtil.class, exception);
            return null;
        }
    }

    public static Boolean isFractional(Double d) {
        int n;
        if (d == null || d.isNaN()) {
            return null;
        }
        double d2 = d;
        return d2 > (d = new Double(n = (int)d2));
    }

    static {
        a.setMinimumFractionDigits(2);
        a.setMaximumFractionDigits(2);
        b.setMinimumFractionDigits(3);
        b.setMaximumFractionDigits(3);
        a.setGroupingUsed(false);
        b.setGroupingUsed(false);
        d.setGroupingUsed(true);
    }
}

