/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Discount;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.BaseUserDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.ComboGroupDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.InventoryStockUnitDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.ModifierMultiplierPriceDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PizzaModifierPriceDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.TicketItemModifierDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.dao._BaseRootDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.StoreUtil;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.ServiceUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.json.JSONArray;
import org.json.JSONObject;

public class BaseDataServiceDao {
    private static final String GSON_PARSING_DATE_FORMAT = "MMM dd, yyyy HH:mm:ss.SSS'Z'";
    public static final String DATA = "data";
    private static Logger LOGGER = Logger.getLogger(BaseDataServiceDao.class);
    private static BaseDataServiceDao instance;

    private BaseDataServiceDao() {
    }

    public void saveOrUpdateTickets(String string) throws Exception {
        this.saveOrUpdateTickets(string, true);
    }

    public void saveOrUpdateTickets(String string, boolean bl) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        this.debug("Request received: " + string);
        List<Ticket> list = this.populateTickets(jSONArray.toString());
        HashMap<String, CashDrawer> hashMap = new HashMap<String, CashDrawer>();
        for (Ticket comparable : list) {
            comparable.setShouldPublishMqtt(bl);
            HashSet<PosTransaction> hashSet = new HashSet<PosTransaction>();
            Set<PosTransaction> set = comparable.getTransactions();
            if (set == null || set.isEmpty()) continue;
            for (PosTransaction posTransaction : set) {
                try {
                    CashDrawer cashDrawer;
                    PosTransaction posTransaction2 = ServiceUtils.convertPosTransactionUsingClassType(posTransaction);
                    hashSet.add(posTransaction2);
                    if (!StringUtils.isNotEmpty((String)posTransaction2.getCashDrawerId()) || (cashDrawer = (CashDrawer)hashMap.get(posTransaction2.getCashDrawerId())) != null || (cashDrawer = posTransaction2.getCashDrawer()) == null) continue;
                    hashMap.put(cashDrawer.getId(), cashDrawer);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
            comparable.setTransactions(hashSet);
        }
        if (hashMap.size() > 0) {
            for (CashDrawer cashDrawer : hashMap.values()) {
                this.saveOrUpdateCashDrawer(cashDrawer);
            }
        }
        this.saveOrUpdateTickets(list);
        this.debug("Successfully saved ticket");
        if (jSONObject.has("linkedData")) {
            this.saveOrUpdateInventoryTransactions(jSONObject.getJSONArray("linkedData"));
        }
    }

    public void saveOrUpdateTickets(List<Ticket> list) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        GenericDAO genericDAO = new GenericDAO();
        Transaction transaction = null;
        Session session = null;
        try {
            session = genericDAO.createNewSession();
            transaction = session.beginTransaction();
            Iterator<Ticket> iterator = list.iterator();
            while (iterator.hasNext()) {
                Ticket ticket;
                TicketDAO ticketDAO = TicketDAO.getInstance();
                Ticket ticket2 = ticketDAO.loadFullTicket((ticket = iterator.next()).getId());
                if (ticket2 != null) {
                    ticket.mergeTicket(ticket2);
                }
                Gratuity gratuity = ticket.getGratuity();
                List<TicketItem> list2 = ticket.getTicketItems();
                Set<PosTransaction> set = ticket.getTransactions();
                ticket.setUpdateLastUpdateTime(true);
                ticket.setUpdateSyncTime(true);
                ticket.setTicketItems(null);
                ticket.setGratuity(null);
                ticket.setTransactions(null);
                this.saveOrUpdateTicket(session, ticket, ticket2);
                this.saveOrUpdateTicketItems(session, ticket, ticket2, list2);
                if (gratuity != null) {
                    String string = gratuity.getTicketId();
                    if (string == null) {
                        gratuity.setTicketId(ticket.getId());
                        this.saveOrUpdateGratuity(session, gratuity);
                    } else if (string.equalsIgnoreCase(ticket.getId())) {
                        this.saveOrUpdateGratuity(session, gratuity);
                    } else {
                        gratuity = null;
                    }
                }
                this.saveOrUpdatePosTransactions(session, ticket, ticket2, set);
                ticket.setTicketItems(list2);
                ticket.setGratuity(gratuity);
                ticket.setTransactions(set);
                ticket.setShouldUpdateTableStatus(ticket2 == null);
                this.saveCustomerIfNotExists(ticket, session);
                ticketDAO.saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            PosLog.error(this.getClass(), exception);
            throw exception;
        }
        finally {
            genericDAO.closeSession(session);
        }
    }

    private void saveOrUpdateTicket(Session session, Ticket ticket, Ticket ticket2) {
        if (ticket2 == null) {
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            if (ticket.getTokenNo() == 0) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            ticket.setVersion(0L);
            TicketDAO.getInstance().save(ticket, session);
        } else {
            ticket.setVersion(ticket2.getVersion());
        }
    }

    private void saveOrUpdateTicketItems(Session session, Ticket ticket, Ticket ticket2, List<TicketItem> list) {
        List<TicketItem> list2 = null;
        if (ticket2 != null) {
            list2 = ticket2.getTicketItems();
        }
        for (TicketItem ticketItem : list) {
            ticketItem.setTicket(ticket);
            this.saveOrUpdateTicketItem(ticketItem, list2, session);
        }
    }

    private void saveOrUpdatePosTransactions(Session session, Ticket ticket, Ticket ticket2, Set<PosTransaction> set) {
        ArrayList<PosTransaction> arrayList = null;
        if (ticket2 != null) {
            arrayList = new ArrayList<PosTransaction>(ticket2.getTransactions());
        }
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction : set) {
                posTransaction.setTicket(ticket);
                if (ticket2 == null || arrayList == null || arrayList.isEmpty()) {
                    posTransaction.setVersion(0L);
                    PosTransactionDAO.getInstance().save(posTransaction, session);
                    continue;
                }
                this.saveOrUpdatePosTransaction(posTransaction, arrayList, session);
            }
        }
    }

    private void saveCustomerIfNotExists(Ticket ticket, Session session) {
        Customer customer;
        if (StringUtils.isEmpty((String)ticket.getCustomerId())) {
            return;
        }
        Customer customer2 = CustomerDAO.getInstance().get(ticket.getCustomerId());
        if (customer2 == null && (customer = ticket.getCustomer()) != null) {
            customer.setVersion(0L);
            CustomerDAO.getInstance().save(customer, session);
        }
    }

    private void saveOrUpdateTicketItem(TicketItem ticketItem, List<TicketItem> list, Session session) {
        Object object;
        TicketItemDAO ticketItemDAO = new TicketItemDAO();
        TicketItem ticketItem2 = null;
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
        List<TicketItem> list3 = null;
        if (ticketItem.isComboItem().booleanValue()) {
            list3 = ticketItem.getComboItems();
        }
        ticketItem.setTicketItemModifiers(null);
        ticketItem.setSizeModifier(null);
        ticketItem.setComboItems(null);
        if (list == null || list.isEmpty()) {
            object = ticketItemDAO.get(ticketItem.getId());
            if (object == null) {
                ticketItem.setVersion(0L);
                ticketItemDAO.save(ticketItem, session);
            } else {
                ticketItem.setVersion(((BaseTicketItem)object).getVersion());
            }
        } else {
            int n = list.indexOf(ticketItem);
            if (n != -1) {
                ticketItem2 = list.get(n);
                if (ticketItem2 == null) {
                    ticketItem.setVersion(0L);
                    ticketItemDAO.save(ticketItem, session);
                } else {
                    ticketItem.setVersion(ticketItem2.getVersion());
                }
            } else {
                ticketItem.setVersion(0L);
                ticketItemDAO.save(ticketItem, session);
            }
        }
        object = null;
        if (ticketItem2 != null) {
            object = ticketItem2.getTicketItemModifiers();
        }
        if (list2 != null && list2.size() > 0) {
            for (TicketItemModifier object2 : list2) {
                object2.setTicketItem(ticketItem);
                if (ticketItem2 == null) {
                    object2.setVersion(0L);
                    TicketItemModifierDAO.getInstance().save(object2, session);
                    continue;
                }
                this.saveTicketItemModifier(object2, (List<TicketItemModifier>)object, session);
            }
        }
        Object object3 = null;
        if (ticketItem2 != null) {
            object3 = ticketItem2.getSizeModifier();
        }
        if (ticketItemModifier != null) {
            ticketItemModifier.setTicketItem(ticketItem);
            this.saveOrUpdateSizeModifier(ticketItemModifier, (TicketItemModifier)object3, session);
        }
        ticketItem.setTicketItemModifiers(list2);
        ticketItem.setSizeModifier(ticketItemModifier);
        if (ticketItem.isComboItem().booleanValue()) {
            if (list3 != null && list3.size() > 0) {
                for (TicketItem ticketItem3 : list3) {
                    ticketItem3.setParentTicketItem(ticketItem);
                    this.saveOrUpdateTicketItem(ticketItem3, ticketItem2 == null ? null : ticketItem2.getComboItems(), session);
                }
            }
            ticketItem.setComboItems(list3);
        }
    }

    private void saveOrUpdateSizeModifier(TicketItemModifier ticketItemModifier, TicketItemModifier ticketItemModifier2, Session session) {
        TicketItemModifierDAO ticketItemModifierDAO = TicketItemModifierDAO.getInstance();
        TicketItemModifier ticketItemModifier3 = ticketItemModifierDAO.get(ticketItemModifier.getId());
        if (ticketItemModifier3 == null) {
            ticketItemModifier.setVersion(0L);
            ticketItemModifierDAO.save(ticketItemModifier, session);
        } else {
            ticketItemModifier.setVersion(ticketItemModifier3.getVersion());
        }
    }

    private void saveTicketItemModifier(TicketItemModifier ticketItemModifier, List<TicketItemModifier> list, Session session) {
        TicketItemModifierDAO ticketItemModifierDAO = new TicketItemModifierDAO();
        if (list == null || list.isEmpty()) {
            return;
        }
        TicketItemModifier ticketItemModifier2 = null;
        int n = list.indexOf(ticketItemModifier);
        if (n != -1) {
            ticketItemModifier2 = list.get(n);
            if (ticketItemModifier2 == null) {
                ticketItemModifier.setVersion(0L);
                ticketItemModifierDAO.save(ticketItemModifier, session);
            } else {
                ticketItemModifier.setVersion(ticketItemModifier2.getVersion());
            }
        } else {
            ticketItemModifier.setVersion(0L);
            ticketItemModifierDAO.save(ticketItemModifier, session);
        }
    }

    private void saveOrUpdateGratuity(Session session, Gratuity gratuity) {
        if (gratuity == null || StringUtils.isEmpty((String)gratuity.getId())) {
            return;
        }
        Gratuity gratuity2 = GratuityDAO.getInstance().get(gratuity.getId());
        if (gratuity2 == null) {
            gratuity.setVersion(0L);
            GratuityDAO.getInstance().save(gratuity, session);
        } else {
            gratuity.setVersion(gratuity2.getVersion());
        }
    }

    private void saveOrUpdatePosTransaction(PosTransaction posTransaction, List<PosTransaction> list, Session session) {
        PosTransactionDAO posTransactionDAO = new PosTransactionDAO();
        if (list == null || list.size() == 0) {
            return;
        }
        PosTransaction posTransaction2 = null;
        int n = list.indexOf(posTransaction);
        if (n != -1) {
            posTransaction2 = list.get(n);
            if (posTransaction2 == null) {
                posTransaction.setVersion(0L);
                posTransactionDAO.save(posTransaction, session);
            } else {
                posTransaction.setVersion(posTransaction2.getVersion());
            }
        } else {
            posTransaction.setVersion(0L);
            posTransactionDAO.save(posTransaction, session);
        }
    }

    public void saveOrUpdateInventoryTransactions(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = new JSONArray(jSONObject.getJSONArray(DATA).toString());
        this.saveOrUpdateInventoryTransactions(jSONArray);
    }

    private void saveOrUpdateInventoryTransactions(JSONArray jSONArray) throws Exception {
        ArrayList<InventoryTransaction> arrayList = new ArrayList<InventoryTransaction>();
        if (jSONArray.length() > 0) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                InventoryTransaction inventoryTransaction = (InventoryTransaction)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), InventoryTransaction.class);
                if (inventoryTransaction == null) continue;
                arrayList.add(inventoryTransaction);
            }
        }
        this.saveOrUpdateInventoryTransactions(arrayList, false, true);
    }

    public void saveOrUpdateInventoryTransactions(List<InventoryTransaction> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        InventoryTransactionDAO inventoryTransactionDAO = new InventoryTransactionDAO();
        Transaction transaction = null;
        Session session = null;
        try {
            session = inventoryTransactionDAO.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryTransaction inventoryTransaction : list) {
                InventoryTransaction inventoryTransaction2 = null;
                if (StringUtils.isNotEmpty((String)inventoryTransaction.getId())) {
                    inventoryTransaction2 = inventoryTransactionDAO.get(inventoryTransaction.getId(), session);
                }
                if (inventoryTransaction2 != null) continue;
                inventoryTransaction.setUpdateLastUpdateTime(bl);
                inventoryTransaction.setUpdateSyncTime(bl2);
                inventoryTransactionDAO.save(inventoryTransaction, session);
                inventoryTransactionDAO.adjustInventoryStock(inventoryTransaction, session);
            }
            transaction.commit();
            this.debug("Successfully inventory adjusted");
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            inventoryTransactionDAO.closeSession(session);
        }
    }

    public void saveOrUpdateCashDrawers(String string) {
        this.saveOrUpdateCashDrawers(string, this.getOutletId(string));
    }

    private String getOutletId(String string) {
        String string2;
        JSONObject jSONObject = new JSONObject(string);
        String string3 = string2 = jSONObject.has("deviceId") ? jSONObject.getString("deviceId") : null;
        if (StringUtils.isNotEmpty((String)string2)) {
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(string2);
            return terminal.getOutletId();
        }
        return StoreDAO.getRestaurant().getDefaultOutletId();
    }

    public void saveOrUpdateCashDrawers(String string, String string2) {
        try {
            Gson gson;
            Object object;
            Object object2;
            JSONObject jSONObject;
            JSONObject jSONObject2 = new JSONObject(string);
            JSONArray jSONArray = jSONObject2.getJSONArray(DATA);
            if (jSONArray != null && jSONArray.length() > 0) {
                jSONObject = new ArrayList();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    object2 = jSONArray.getJSONObject(i);
                    object = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
                    CashDrawer cashDrawer = (CashDrawer)object.fromJson(object2.toString(), CashDrawer.class);
                    if (cashDrawer == null) continue;
                    jSONObject.add(cashDrawer);
                }
                gson = jSONObject.iterator();
                while (gson.hasNext()) {
                    object2 = (CashDrawer)gson.next();
                    ((BaseCashDrawer)object2).setOutletId(string2);
                    this.saveOrUpdateCashDrawer((CashDrawer)object2, true);
                }
            }
            JSONObject jSONObject3 = jSONObject = jSONObject2.has("linkedData") ? jSONObject2.getJSONObject("linkedData") : null;
            if (jSONObject != null && (object2 = (Terminal)(gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create()).fromJson(jSONObject.toString(), Terminal.class)) != null && (object = TerminalDAO.getInstance().get(((BaseTerminal)object2).getId())) != null) {
                ((Terminal)object).setAssignedUser(((Terminal)object2).getAssignedUser());
                ((BaseTerminal)object).setCurrentCashDrawer(((BaseTerminal)object2).getCurrentCashDrawer());
                TerminalDAO.getInstance().update((Terminal)object);
            }
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
        }
    }

    private void saveOrUpdateCashDrawer(CashDrawer cashDrawer) {
        this.saveOrUpdateCashDrawer(cashDrawer, false);
    }

    private void saveOrUpdateCashDrawer(CashDrawer cashDrawer, boolean bl) {
        Session session = null;
        Transaction transaction = null;
        CashDrawerDAO cashDrawerDAO = CashDrawerDAO.getInstance();
        try {
            session = cashDrawerDAO.createNewSession();
            transaction = session.beginTransaction();
            cashDrawer.setStoreSession(StoreUtil.getCurrentStoreSession());
            CashDrawer cashDrawer2 = CashDrawerDAO.getInstance().get(cashDrawer.getId());
            if (cashDrawer2 == null) {
                cashDrawerDAO.save(cashDrawer);
                this.debug("New cash drawer " + cashDrawer.getId() + ", asssignd user " + cashDrawer.getAssignedUserId() + " has been created.");
            } else {
                if (bl) {
                    cashDrawer.setVersion(cashDrawer2.getVersion());
                    cashDrawerDAO.update(cashDrawer);
                }
                BaseDataServiceDao.updateTerminal(session, cashDrawer.getTerminalId(), cashDrawer.getAssignedUser(), cashDrawer);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            cashDrawerDAO.closeSession(session);
        }
    }

    private static void updateTerminal(Session session, Integer n, User user, CashDrawer cashDrawer) {
        TerminalDAO terminalDAO = new TerminalDAO();
        Terminal terminal = terminalDAO.get(n, session);
        if (terminal != null) {
            CashDrawer cashDrawer2 = terminal.getCurrentCashDrawer();
            if (cashDrawer.isClosed() && cashDrawer2 != null && cashDrawer2.getId().equals(cashDrawer.getId())) {
                user = null;
                cashDrawer = null;
            }
            terminal.setAssignedUser(user);
            terminal.setCurrentCashDrawer(cashDrawer);
            terminal.setActive(true);
            terminalDAO.saveOrUpdate(terminal, session);
        }
    }

    public static BaseDataServiceDao get() {
        return BaseDataServiceDao.getInstance();
    }

    public void saveOrUpdateMenuItems(String string) throws Exception {
        this.saveOrUpdateDataList(string, MenuItem.class);
    }

    public void saveOrUpdateMenuGroups(String string) throws Exception {
        this.saveOrUpdateDataList(string, MenuGroup.class);
    }

    public void saveOrUpdateMenuCategories(String string) throws Exception {
        this.saveOrUpdateDataList(string, MenuCategory.class);
    }

    public void saveOrUpdateTerminals(String string) throws Exception {
        List list = this.getDataListFromJson(string, Terminal.class);
        if (list != null && list.size() > 0) {
            for (Terminal terminal : list) {
                Terminal terminal2 = TerminalDAO.getInstance().get(terminal.getId());
                if (terminal2 == null) {
                    TerminalDAO.getInstance().save(terminal);
                    continue;
                }
                terminal2.setName(terminal.getName());
                terminal2.setActive(terminal.isActive());
                terminal2.setDepartmentId(terminal.getDepartmentId());
                terminal2.setHasCashDrawer(terminal.isHasCashDrawer());
                TerminalDAO.getInstance().update(terminal2);
            }
        }
    }

    public List saveOrUpdateDataList(String string, Class clazz) throws Exception {
        TerminalDAO terminalDAO = new TerminalDAO();
        Session session = null;
        Transaction transaction = null;
        try {
            session = terminalDAO.createNewSession();
            transaction = session.beginTransaction();
            List list = this.saveOrUpdateDataList(string, clazz, session);
            transaction.commit();
            List list2 = list;
            return list2;
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            terminalDAO.closeSession(session);
        }
    }

    public List saveOrUpdateDataList(String string, Class clazz, Session session) throws Exception {
        List list = this.getDataListFromJson(string, clazz);
        for (Object e : list) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor("id", e.getClass());
            Object object = propertyDescriptor.getReadMethod().invoke(e, new Object[0]);
            Object object2 = this.getExistingData(e.getClass(), object);
            if (object2 == null) {
                session.save(e);
                continue;
            }
            PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor("version", e.getClass());
            long l = (Long)propertyDescriptor2.getReadMethod().invoke(object2, new Object[0]);
            propertyDescriptor2.getWriteMethod().invoke(e, l);
            session.update(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExistingData(Class<? extends Object> clazz, Object object) {
        TerminalDAO terminalDAO = new TerminalDAO();
        Session session = null;
        try {
            session = terminalDAO.createNewSession();
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)object));
            Object object2 = criteria.uniqueResult();
            return object2;
        }
        finally {
            terminalDAO.closeSession(session);
        }
    }

    public List getDataListFromJson(String string, Class clazz) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            arrayList.add(this.toObject(jSONObject2, clazz));
        }
        return arrayList;
    }

    public Object toObject(JSONObject jSONObject, Class<?> clazz) throws Exception {
        Gson gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create();
        return gson.fromJson(jSONObject.toString(), clazz);
    }

    private List<Ticket> populateTickets(String string) {
        try {
            if (string == null) {
                return null;
            }
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                this.populateMap(jSONObject, "orderType", hashMap, OrderType.class);
                this.populateMap(jSONObject, "terminal", hashMap3, Terminal.class);
                this.populateMap(jSONObject, "owner", hashMap2, User.class);
                HashMap<String, List<TicketItemModifier>> hashMap4 = new HashMap<String, List<TicketItemModifier>>();
                BaseDataServiceDao.populateTicketItemModifiers(jSONObject, hashMap4);
                Ticket ticket = (Ticket)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), Ticket.class);
                ticket.convertDiscountPropertyToList();
                StoreSession storeSession = StoreUtil.getCurrentStoreSession();
                if (storeSession != null) {
                    ticket.setStoreSessionId(storeSession.getId());
                }
                this.populateTicketItems(hashMap4, ticket);
                arrayList.add(ticket);
            }
            this.saveOrderTypesIfNotExists(new ArrayList<OrderType>(hashMap.values()));
            this.saveTerminalsIfNotExists(new ArrayList<Terminal>(hashMap3.values()));
            this.saveUserIfNotExists(new ArrayList<User>(hashMap2.values()));
            return arrayList;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    private void saveOrderTypesIfNotExists(List<OrderType> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (OrderType orderType : list) {
            OrderType orderType2 = DataProvider.get().getOrderType(orderType.getId());
            if (orderType2 != null) continue;
            OrderTypeDAO.getInstance().save(orderType);
            this.debug("New order type " + orderType.getId() + " " + orderType.getName() + " has been created.");
        }
    }

    private void saveTerminalsIfNotExists(List<Terminal> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Terminal terminal : list) {
            Terminal terminal2 = TerminalDAO.getInstance().getByTerminalKey(terminal.getTerminalKey());
            if (terminal2 != null) continue;
            terminal.setCurrentCashDrawer(null);
            TerminalDAO.getInstance().save(terminal);
            this.debug("New terminal " + terminal.getId() + " " + terminal.getName() + " has been created.");
        }
    }

    private void saveUserIfNotExists(List<User> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (User user : list) {
            User user2 = DataProvider.get().getUserById(user.getId());
            if (user2 != null) continue;
            UserDAO.getInstance().save(user);
            this.debug("New user " + user.getId() + " " + user.getFirstName() + " has been created.");
        }
    }

    private void debug(String string) {
        PosLog.debug(this.getClass(), string);
    }

    private void populateTicketItems(Map<String, List<TicketItemModifier>> map, Ticket ticket) {
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            List<TicketItemModifier> list = map.get(ticketItem.getId());
            if (list != null && list.size() > 0) {
                ModifiableTicketItem modifiableTicketItem = new ModifiableTicketItem(ticketItem.getId());
                try {
                    PropertyUtils.copyProperties((Object)modifiableTicketItem, (Object)ticketItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                modifiableTicketItem.setId(ticketItem.getId());
                modifiableTicketItem.setTicketItemModifiers(list);
                arrayList.add(modifiableTicketItem);
                continue;
            }
            arrayList.add(ticketItem);
        }
        ticket.setTicketItems(arrayList);
    }

    public static void populateTicketItemModifiers(JSONObject jSONObject, Map<String, List<TicketItemModifier>> map) throws NoSuchFieldException, ClassNotFoundException {
        if (!jSONObject.has("ticketItemModifiers")) {
            return;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("ticketItemModifiers");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            TicketItemModifier ticketItemModifier = (TicketItemModifier)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject2.toString(), TicketItemModifier.class);
            if (ticketItemModifier.getTicketItem() == null) continue;
            List<TicketItemModifier> list = map.get(ticketItemModifier.getTicketItem().getId());
            if (list == null) {
                list = new ArrayList<TicketItemModifier>();
                map.put(ticketItemModifier.getTicketItem().getId(), list);
            }
            list.add(ticketItemModifier);
        }
    }

    private void populateMap(JSONObject jSONObject, String string, Map map, Class clazz) throws Exception {
        if (!jSONObject.has(string)) {
            return;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(string);
        Object object = this.convertJson(jSONObject2.toString(), clazz);
        if (object != null) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor("id", object.getClass());
            map.put(propertyDescriptor.getReadMethod().invoke(object, new Object[0]), object);
        }
    }

    private Object convertJson(String string, Class clazz) throws Exception {
        return BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create().fromJson(string, clazz);
    }

    public void saveOrUpdateMenuModifiers(List<MenuModifier> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        MenuModifierDAO menuModifierDAO = MenuModifierDAO.getInstance();
        Transaction transaction = null;
        Session session = null;
        try {
            session = menuModifierDAO.createNewSession();
            transaction = session.beginTransaction();
            for (MenuModifier menuModifier : list) {
                MenuModifier menuModifier2 = menuModifierDAO.loadFullModifier(menuModifier.getId());
                List<PizzaModifierPrice> list2 = menuModifier.getPizzaModifierPriceList();
                List<ModifierMultiplierPrice> list3 = menuModifier.getMultiplierPriceList();
                List<ModifierGroup> list4 = menuModifier.getModifierGroups();
                menuModifier.setUpdateLastUpdateTime(bl);
                menuModifier.setUpdateSyncTime(bl2);
                menuModifier.setPizzaModifierPriceList(null);
                menuModifier.setMultiplierPriceList(null);
                menuModifier.setModifierGroups(null);
                this.saveOrUpdateVerMenuModifier(session, menuModifier, menuModifier2);
                this.saveOrUpdatePizzaModifierPrice(session, menuModifier2, list2);
                this.saveOrUpdateModifierMultiplierPrice(session, menuModifier, menuModifier2, list3);
                this.saveOrUpdateModifierGroup(session, menuModifier2, list4, bl, bl2);
                menuModifier.setPizzaModifierPriceList(list2);
                menuModifier.setMultiplierPriceList(list3);
                menuModifier.setModifierGroups(list4);
                menuModifierDAO.saveOrUpdate(menuModifier, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            menuModifierDAO.closeSession(session);
        }
    }

    private void saveOrUpdateModifierGroup(Session session, MenuModifier menuModifier, List<ModifierGroup> list, boolean bl, boolean bl2) {
        if (list == null) {
            return;
        }
        List<ModifierGroup> list2 = null;
        if (menuModifier != null) {
            list2 = menuModifier.getModifierGroups();
        }
        for (ModifierGroup modifierGroup : list) {
            this.saveOrUpdateModifierGroup(session, modifierGroup, list2, bl, bl2);
        }
    }

    private void saveOrUpdateModifierGroup(Session session, ModifierGroup modifierGroup, List<ModifierGroup> list, boolean bl, boolean bl2) {
        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
        ModifierGroup modifierGroup2 = null;
        modifierGroup.setUpdateLastUpdateTime(bl);
        modifierGroup.setUpdateSyncTime(bl2);
        if (list == null || list.isEmpty()) {
            this.saveOrSetVersionModifierGroup(session, modifierGroup, modifierGroupDAO);
        } else {
            int n = list.indexOf(modifierGroup);
            if (n != -1) {
                modifierGroup2 = list.get(n);
                if (modifierGroup2 == null) {
                    modifierGroupDAO.save(modifierGroup, session);
                } else {
                    modifierGroup.setVersion(modifierGroup2.getVersion());
                }
            } else {
                this.saveOrSetVersionModifierGroup(session, modifierGroup, modifierGroupDAO);
            }
        }
    }

    private void saveOrSetVersionModifierGroup(Session session, ModifierGroup modifierGroup, ModifierGroupDAO modifierGroupDAO) {
        ModifierGroup modifierGroup2 = modifierGroupDAO.get(modifierGroup.getId(), session);
        if (modifierGroup2 == null) {
            modifierGroupDAO.save(modifierGroup, session);
        } else {
            modifierGroup.setVersion(modifierGroup2.getVersion());
        }
    }

    private void saveOrUpdatePizzaModifierPrice(Session session, MenuModifier menuModifier, List<PizzaModifierPrice> list) {
        if (list == null) {
            return;
        }
        List<PizzaModifierPrice> list2 = null;
        if (menuModifier != null) {
            list2 = menuModifier.getPizzaModifierPriceList();
        }
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            PizzaModifierPrice pizzaModifierPrice2 = PizzaModifierPriceDAO.getInstance().get(pizzaModifierPrice.getId());
            List<ModifierMultiplierPrice> list3 = pizzaModifierPrice.getMultiplierPriceList();
            pizzaModifierPrice.setMultiplierPriceList(null);
            this.saveOrUpdateVerPizzaModifierPrice(session, pizzaModifierPrice, pizzaModifierPrice2);
            if (list3 != null) {
                this.saveOrUpdateModifierMultiplierPrice(session, pizzaModifierPrice, pizzaModifierPrice2, list3);
                pizzaModifierPrice.setMultiplierPriceList(list3);
            }
            this.saveOrUpdatePizzaModifierPrice(session, pizzaModifierPrice, list2);
        }
    }

    private void saveOrUpdateVerPizzaModifierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, PizzaModifierPrice pizzaModifierPrice2) {
        if (pizzaModifierPrice2 == null) {
            PizzaModifierPriceDAO.getInstance().save(pizzaModifierPrice, session);
        } else {
            pizzaModifierPrice.setVersion(pizzaModifierPrice2.getVersion());
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, PizzaModifierPrice pizzaModifierPrice2, List<ModifierMultiplierPrice> list) {
        List<ModifierMultiplierPrice> list2 = null;
        if (pizzaModifierPrice2 != null) {
            list2 = pizzaModifierPrice2.getMultiplierPriceList();
        }
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            modifierMultiplierPrice.setPizzaModifierPriceId(pizzaModifierPrice.getId());
            this.saveOrUpdateModifierMultiplierPrice(session, modifierMultiplierPrice, list2);
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, MenuModifier menuModifier, MenuModifier menuModifier2, List<ModifierMultiplierPrice> list) {
        if (list == null) {
            return;
        }
        List<ModifierMultiplierPrice> list2 = null;
        if (menuModifier2 != null) {
            list2 = menuModifier2.getMultiplierPriceList();
        }
        for (ModifierMultiplierPrice modifierMultiplierPrice : list) {
            modifierMultiplierPrice.setModifierId(menuModifier.getId());
            this.saveOrUpdateModifierMultiplierPrice(session, modifierMultiplierPrice, list2);
        }
    }

    private void saveOrUpdatePizzaModifierPrice(Session session, PizzaModifierPrice pizzaModifierPrice, List<PizzaModifierPrice> list) {
        PizzaModifierPriceDAO pizzaModifierPriceDAO = new PizzaModifierPriceDAO();
        PizzaModifierPrice pizzaModifierPrice2 = null;
        if (list == null || list.isEmpty()) {
            pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
        } else {
            int n = list.indexOf(pizzaModifierPrice);
            if (n != -1) {
                pizzaModifierPrice2 = list.get(n);
                if (pizzaModifierPrice2 == null) {
                    pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
                } else {
                    pizzaModifierPrice.setVersion(pizzaModifierPrice2.getVersion());
                }
            } else {
                pizzaModifierPriceDAO.save(pizzaModifierPrice, session);
            }
        }
    }

    private void saveOrUpdateModifierMultiplierPrice(Session session, ModifierMultiplierPrice modifierMultiplierPrice, List<ModifierMultiplierPrice> list) {
        ModifierMultiplierPriceDAO modifierMultiplierPriceDAO = new ModifierMultiplierPriceDAO();
        ModifierMultiplierPrice modifierMultiplierPrice2 = null;
        if (list == null || list.isEmpty()) {
            modifierMultiplierPrice.setVersion(0L);
            modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
        } else {
            int n = list.indexOf(modifierMultiplierPrice);
            if (n != -1) {
                modifierMultiplierPrice2 = list.get(n);
                if (modifierMultiplierPrice2 == null) {
                    modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
                } else {
                    modifierMultiplierPrice.setVersion(modifierMultiplierPrice2.getVersion());
                }
            } else {
                modifierMultiplierPriceDAO.save(modifierMultiplierPrice, session);
            }
        }
    }

    private void saveOrUpdateVerMenuModifier(Session session, MenuModifier menuModifier, MenuModifier menuModifier2) {
        if (menuModifier2 == null) {
            MenuModifierDAO.getInstance().save(menuModifier, session);
        } else {
            menuModifier.setVersion(menuModifier2.getVersion());
        }
    }

    public void saveOrUpdateUsers(List<User> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        ArrayList<User> arrayList2 = new ArrayList<User>();
        UserDAO userDAO = UserDAO.getInstance();
        for (User user : list) {
            if (user.isRoot().booleanValue()) {
                arrayList.add(user);
                continue;
            }
            arrayList2.add(user);
        }
        this.saveUser(arrayList, bl, bl2, userDAO);
        this.saveUser(arrayList2, bl, bl2, userDAO);
    }

    private void saveUser(List<User> list, boolean bl, boolean bl2, UserDAO userDAO) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = userDAO.createNewSession();
            transaction = session.beginTransaction();
            for (User user : list) {
                User user2 = userDAO.get(user.getId());
                if (user2 != null && !this.shouldSave(user.getLastUpdateTime(), user2.getLastUpdateTime())) {
                    LOGGER.info((Object)(user.getFullName() + " already updated"));
                    continue;
                }
                this.saveOrSetVersionUsers(bl, bl2, session, user, user2, userDAO);
                userDAO.saveOrUpdate(user, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            userDAO.closeSession(session);
        }
    }

    private void saveOrSetVersionUsers(boolean bl, boolean bl2, Session session, User user, User user2, UserDAO userDAO) {
        User user3 = user.getParentUser();
        user.setUpdateLastUpdateTime(bl);
        user.setUpdateSyncTime(bl2);
        user.setParentUser(null);
        this.saveOrSetVersionUsers(session, user, user2, userDAO);
        user.setParentUser(user3);
    }

    private void saveOrSetVersionUsers(Session session, User user, User user2, UserDAO userDAO) {
        if (user2 == null) {
            User user3 = userDAO.get(user.getId(), session);
            if (user3 == null) {
                userDAO.save(user, session);
            } else {
                user.setVersion(user3.getVersion());
            }
        } else {
            user.setVersion(user2.getVersion());
        }
    }

    public void saveOrUpdateMenuItems(List<MenuItem> list, boolean bl, boolean bl2) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        ArrayList<MenuItem> arrayList2 = new ArrayList<MenuItem>();
        MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
        for (MenuItem menuItem : list) {
            if (!menuItem.isVariant().booleanValue()) {
                arrayList.add(menuItem);
                continue;
            }
            arrayList2.add(menuItem);
        }
        this.saveMenuItem(arrayList, bl, bl2, menuItemDAO);
        this.saveMenuItem(arrayList2, bl, bl2, menuItemDAO);
    }

    private void saveMenuItem(List<MenuItem> list, boolean bl, boolean bl2, MenuItemDAO menuItemDAO) throws Exception {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = menuItemDAO.createNewSession();
            transaction = session.beginTransaction();
            for (MenuItem menuItem : list) {
                this.saveMenuItem(bl, bl2, menuItemDAO, session, menuItem);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            menuItemDAO.closeSession(session);
        }
    }

    public void saveMenuItem(boolean bl, boolean bl2, MenuItemDAO menuItemDAO, Session session, MenuItem menuItem) {
        String string = menuItem.getId();
        MenuItem menuItem2 = null;
        if (string != null) {
            menuItem2 = menuItemDAO.get(string);
        }
        if (menuItem2 != null && !this.shouldSave(menuItem.getLastUpdateTime(), menuItem2.getLastUpdateTime())) {
            LOGGER.info((Object)(menuItem.getDisplayName() + " already updated"));
            return;
        }
        this.saveOrSetVersionMenuItem(bl, bl2, session, menuItem, menuItem2, menuItemDAO);
        menuItemDAO.saveOrUpdate(menuItem, session);
    }

    private void saveOrSetVersionMenuItem(boolean bl, boolean bl2, Session session, MenuItem menuItem, MenuItem menuItem2, MenuItemDAO menuItemDAO) {
        menuItemDAO.initialize(menuItem2);
        List<Attribute> list = menuItem.getAttributes();
        List<Discount> list2 = menuItem.getDiscounts();
        List<MenuItemModifierSpec> list3 = menuItem.getMenuItemModiferSpecs();
        List<ComboGroup> list4 = menuItem.getComboGroups();
        List<ComboItem> list5 = menuItem.getComboItems();
        List<InventoryStockUnit> list6 = menuItem.getStockUnits();
        List<PizzaPrice> list7 = menuItem.getPizzaPriceList();
        List<MenuItem> list8 = menuItem.getVariants();
        menuItem.setUpdateLastUpdateTime(bl);
        menuItem.setUpdateSyncTime(bl2);
        menuItem.setAttributes(null);
        menuItem.setDiscounts(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setStockUnits(null);
        menuItem.setPizzaPriceList(null);
        menuItem.setVariants(null);
        this.saveOrSetVersionMenuItems(session, menuItem, menuItem2, menuItemDAO);
        this.saveOrSetVersionComboItems(session, menuItem, menuItem2, list5);
        this.saveOrSetVersionAttributes(session, menuItem2, list);
        this.saveOrSetVersionDiscounts(session, menuItem2, list2);
        this.saveOrSetVersionMenuItemModifierSpecs(session, menuItem2, list3, bl, bl2);
        this.saveOrSetVersionComboGroups(session, menuItem2, list4);
        this.saveOrSetVersionInvStockUnits(session, menuItem2, list6);
        this.saveOrSetVersionPizzaPrices(session, menuItem2, list7);
        if (menuItem.isHasVariant().booleanValue()) {
            this.saveOrSetVersionVariants(session, menuItem2, list8, menuItemDAO);
        }
        menuItem.setAttributes(list);
        menuItem.setDiscounts(list2);
        menuItem.setMenuItemModiferSpecs(list3);
        menuItem.setComboGroups(list4);
        menuItem.setComboItems(list5);
        menuItem.setStockUnits(list6);
        menuItem.setPizzaPriceList(list7);
        menuItem.setVariants(list8);
    }

    private void saveOrSetVersionVariants(Session session, MenuItem menuItem, List<MenuItem> list, MenuItemDAO menuItemDAO) {
        if (list == null) {
            return;
        }
        LOGGER.info((Object)(list.size() + " variants found"));
        for (MenuItem menuItem2 : list) {
            MenuItem menuItem3 = menuItemDAO.get(menuItem2.getId());
            if (menuItem3 != null && !this.shouldSave(menuItem2.getLastUpdateTime(), menuItem3.getLastUpdateTime())) {
                LOGGER.info((Object)(menuItem2.getDisplayName() + " already updated"));
                continue;
            }
            this.saveOrSetVersionMenuItem(false, false, session, menuItem2, menuItem3, menuItemDAO);
        }
    }

    private void saveOrSetVersionPizzaPrices(Session session, MenuItem menuItem, List<PizzaPrice> list) {
        if (list == null) {
            return;
        }
        LOGGER.info((Object)(list.size() + " PizzaPrices found"));
        List<PizzaPrice> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getPizzaPriceList();
        }
        for (PizzaPrice pizzaPrice : list) {
            this.saveOrSetVersionPizzaPrices(session, pizzaPrice, list2);
        }
    }

    private void saveOrSetVersionPizzaPrices(Session session, PizzaPrice pizzaPrice, List<PizzaPrice> list) {
        PizzaPriceDAO pizzaPriceDAO = new PizzaPriceDAO();
        PizzaPrice pizzaPrice2 = null;
        if (list == null || list.isEmpty()) {
            pizzaPrice2 = pizzaPriceDAO.get(pizzaPrice.getId());
            if (pizzaPrice2 == null) {
                pizzaPriceDAO.save(pizzaPrice, session);
            } else {
                pizzaPrice.setVersion(pizzaPrice2.getVersion());
            }
        } else {
            int n = list.indexOf(pizzaPrice);
            if (n != -1) {
                pizzaPrice2 = list.get(n);
                if (pizzaPrice2 == null) {
                    pizzaPriceDAO.save(pizzaPrice, session);
                } else {
                    pizzaPrice.setVersion(pizzaPrice2.getVersion());
                }
            } else {
                pizzaPriceDAO.save(pizzaPrice, session);
            }
        }
    }

    private void saveOrSetVersionInvStockUnits(Session session, MenuItem menuItem, List<InventoryStockUnit> list) {
        if (list == null) {
            return;
        }
        LOGGER.info((Object)(list.size() + " stockUnits found"));
        List<InventoryStockUnit> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getStockUnits();
        }
        for (InventoryStockUnit inventoryStockUnit : list) {
            this.saveOrSetVersionInvStockUnits(session, inventoryStockUnit, list2);
        }
    }

    private void saveOrSetVersionInvStockUnits(Session session, InventoryStockUnit inventoryStockUnit, List<InventoryStockUnit> list) {
        InventoryStockUnitDAO inventoryStockUnitDAO = new InventoryStockUnitDAO();
        InventoryStockUnit inventoryStockUnit2 = null;
        if (list == null || list.isEmpty()) {
            inventoryStockUnit2 = inventoryStockUnitDAO.get(inventoryStockUnit.getId());
            if (inventoryStockUnit2 == null) {
                inventoryStockUnitDAO.save(inventoryStockUnit, session);
            } else {
                inventoryStockUnit.setVersion(inventoryStockUnit2.getVersion());
            }
        } else {
            int n = list.indexOf(inventoryStockUnit);
            if (n != -1) {
                inventoryStockUnit2 = list.get(n);
                if (inventoryStockUnit2 == null) {
                    inventoryStockUnitDAO.save(inventoryStockUnit, session);
                } else {
                    inventoryStockUnit.setVersion(inventoryStockUnit2.getVersion());
                }
            } else {
                inventoryStockUnitDAO.save(inventoryStockUnit, session);
            }
        }
    }

    private void saveOrSetVersionComboItems(Session session, MenuItem menuItem, MenuItem menuItem2, List<ComboItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LOGGER.info((Object)(list.size() + " comboItems found"));
        List<ComboItem> list2 = null;
        if (menuItem2 != null) {
            list2 = menuItem2.getComboItems();
        }
        for (ComboItem comboItem : list) {
            comboItem.setItemId(menuItem.getId());
            this.saveOrSetVersionComboItems(session, comboItem, list2);
        }
    }

    private void saveOrSetVersionComboItems(Session session, ComboItem comboItem, List<ComboItem> list) {
        ComboItemDAO comboItemDAO = new ComboItemDAO();
        ComboItem comboItem2 = null;
        if (list == null || list.isEmpty()) {
            comboItem2 = comboItemDAO.get(comboItem.getId());
            if (comboItem2 == null) {
                comboItemDAO.save(comboItem, session);
            } else {
                comboItem.setVersion(comboItem2.getVersion());
            }
        } else {
            int n = list.indexOf(comboItem);
            if (n != -1) {
                comboItem2 = list.get(n);
                if (comboItem2 == null) {
                    comboItemDAO.save(comboItem, session);
                } else {
                    comboItem.setVersion(comboItem2.getVersion());
                }
            } else {
                comboItemDAO.save(comboItem, session);
            }
        }
    }

    private void saveOrSetVersionComboGroups(Session session, MenuItem menuItem, List<ComboGroup> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LOGGER.info((Object)(list.size() + " comboGroup found"));
        List<ComboGroup> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getComboGroups();
        }
        for (ComboGroup comboGroup : list) {
            this.saveOrSetVersionComboGroups(session, comboGroup, list2);
        }
    }

    private void saveOrSetVersionComboGroups(Session session, ComboGroup comboGroup, List<ComboGroup> list) {
        ComboGroupDAO comboGroupDAO = new ComboGroupDAO();
        ComboGroup comboGroup2 = null;
        if (list == null || list.isEmpty()) {
            comboGroup2 = comboGroupDAO.get(comboGroup.getId());
            if (comboGroup2 == null) {
                comboGroupDAO.save(comboGroup, session);
            } else {
                comboGroup.setVersion(comboGroup2.getVersion());
            }
        } else {
            int n = list.indexOf(comboGroup);
            if (n != -1) {
                comboGroup2 = list.get(n);
                if (comboGroup2 == null) {
                    comboGroupDAO.save(comboGroup, session);
                } else {
                    comboGroup.setVersion(comboGroup2.getVersion());
                }
            } else {
                comboGroupDAO.save(comboGroup, session);
            }
        }
    }

    private void saveOrSetVersionMenuItemModifierSpecs(Session session, MenuItem menuItem, List<MenuItemModifierSpec> list, boolean bl, boolean bl2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LOGGER.info((Object)(list.size() + " menuItemModiferSpec found"));
        List<MenuItemModifierSpec> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getMenuItemModiferSpecs();
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            this.saveOrSetVersionMenuItemModifierSpecs(session, bl, bl2, list2, menuItemModifierSpec);
        }
    }

    public void saveOrSetVersionMenuItemModifierSpecs(Session session, boolean bl, boolean bl2, List<MenuItemModifierSpec> list, MenuItemModifierSpec menuItemModifierSpec) {
        Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
        menuItemModifierSpec.setUpdateLastUpdateTime(bl);
        menuItemModifierSpec.setUpdateSyncTime(bl2);
        menuItemModifierSpec.setModifierPages(null);
        this.saveOrSetVersionMenuItemModifierSpec(session, menuItemModifierSpec);
        menuItemModifierSpec.setModifierPages(set);
        if (set != null && !set.isEmpty()) {
            for (MenuItemModifierPage menuItemModifierPage : set) {
                this.saveOrSetVersionMenuItemModiPage(session, menuItemModifierPage);
            }
        }
        this.saveOrSetVersionMenuItemModifierSpecs(session, menuItemModifierSpec, list);
    }

    public void saveOrSetVersionMenuItemModiPage(Session session, MenuItemModifierPage menuItemModifierPage) {
        List<MenuItemModifierPageItem> list = menuItemModifierPage.getPageItems();
        menuItemModifierPage.setPageItems(null);
        this.saveOrSetVersionMenuItemModifierPage(session, menuItemModifierPage);
        this.saveOrSetVersionMenuItemModifierPageItem(session, menuItemModifierPage, list);
        menuItemModifierPage.setPageItems(list);
    }

    private void saveOrSetVersionMenuItemModifierPageItem(Session session, MenuItemModifierPage menuItemModifierPage, List<MenuItemModifierPageItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = new MenuItemModifierPageItemDAO();
        MenuItemModifierPageItem menuItemModifierPageItem = null;
        for (MenuItemModifierPageItem menuItemModifierPageItem2 : list) {
            menuItemModifierPageItem = menuItemModifierPageItemDAO.get(menuItemModifierPageItem2.getId());
            menuItemModifierPageItem2.setParentPageId(menuItemModifierPage.getId());
            if (menuItemModifierPageItem == null) {
                menuItemModifierPageItemDAO.save(menuItemModifierPageItem2, session);
                continue;
            }
            menuItemModifierPageItem2.setVersion(menuItemModifierPageItem.getVersion());
        }
    }

    private void saveOrSetVersionMenuItemModifierSpec(Session session, MenuItemModifierSpec menuItemModifierSpec) {
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = MenuItemModifierSpecDAO.getInstance();
        MenuItemModifierSpec menuItemModifierSpec2 = menuItemModifierSpecDAO.get(menuItemModifierSpec.getId());
        if (menuItemModifierSpec2 == null) {
            menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
        } else {
            menuItemModifierSpec.setVersion(menuItemModifierSpec2.getVersion());
        }
    }

    private void saveOrSetVersionMenuItemModifierPage(Session session, MenuItemModifierPage menuItemModifierPage) {
        MenuItemModifierPageDAO menuItemModifierPageDAO = MenuItemModifierPageDAO.getInstance();
        MenuItemModifierPage menuItemModifierPage2 = menuItemModifierPageDAO.get(menuItemModifierPage.getId());
        if (menuItemModifierPage2 == null) {
            menuItemModifierPageDAO.save(menuItemModifierPage, session);
        } else {
            menuItemModifierPage.setVersion(menuItemModifierPage2.getVersion());
        }
    }

    private void saveOrSetVersionMenuItemModifierSpecs(Session session, MenuItemModifierSpec menuItemModifierSpec, List<MenuItemModifierSpec> list) {
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = new MenuItemModifierSpecDAO();
        MenuItemModifierSpec menuItemModifierSpec2 = null;
        if (list == null || list.isEmpty()) {
            menuItemModifierSpec2 = menuItemModifierSpecDAO.get(menuItemModifierSpec.getId());
            if (menuItemModifierSpec2 == null) {
                menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
            } else {
                menuItemModifierSpec.setVersion(menuItemModifierSpec2.getVersion());
            }
        } else {
            int n = list.indexOf(menuItemModifierSpec);
            if (n != -1) {
                menuItemModifierSpec2 = list.get(n);
                if (menuItemModifierSpec2 == null) {
                    menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
                } else {
                    menuItemModifierSpec.setVersion(menuItemModifierSpec2.getVersion());
                }
            } else {
                menuItemModifierSpecDAO.save(menuItemModifierSpec, session);
            }
        }
    }

    private void saveOrSetVersionDiscounts(Session session, MenuItem menuItem, List<Discount> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LOGGER.info((Object)(list.size() + " discount found"));
        List<Discount> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getDiscounts();
        }
        for (Discount discount : list) {
            this.saveOrSetVersionDiscounts(session, discount, list2);
        }
    }

    private void saveOrSetVersionDiscounts(Session session, Discount discount, List<Discount> list) {
        DiscountDAO discountDAO = new DiscountDAO();
        Discount discount2 = null;
        if (list == null || list.isEmpty()) {
            discount2 = discountDAO.get(discount.getId());
            if (discount2 == null) {
                discountDAO.save(discount, session);
            } else {
                discount.setVersion(discount2.getVersion());
            }
        } else {
            int n = list.indexOf(discount);
            if (n != -1) {
                discount2 = list.get(n);
                if (discount2 == null) {
                    discountDAO.save(discount, session);
                } else {
                    discount.setVersion(discount2.getVersion());
                }
            } else {
                discountDAO.save(discount, session);
            }
        }
    }

    private void saveOrSetVersionAttributes(Session session, MenuItem menuItem, List<Attribute> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        LOGGER.info((Object)(list.size() + " attribute found"));
        List<Attribute> list2 = null;
        if (menuItem != null) {
            list2 = menuItem.getAttributes();
        }
        for (Attribute attribute : list) {
            this.saveOrSetVersionAttributes(session, attribute, list2);
        }
    }

    private void saveOrSetVersionAttributes(Session session, Attribute attribute, List<Attribute> list) {
        AttributeDAO attributeDAO = new AttributeDAO();
        Attribute attribute2 = null;
        if (list == null || list.isEmpty()) {
            attribute2 = attributeDAO.get(attribute.getId(), session);
            if (attribute2 == null) {
                attributeDAO.save(attribute, session);
            } else {
                attribute.setVersion(attribute2.getVersion());
            }
        } else {
            int n = list.indexOf(attribute);
            if (n != -1) {
                attribute2 = list.get(n);
                if (attribute2 == null) {
                    attributeDAO.save(attribute, session);
                } else {
                    attribute.setVersion(attribute2.getVersion());
                }
            } else {
                attributeDAO.save(attribute, session);
            }
        }
    }

    private void saveOrSetVersionMenuItems(Session session, MenuItem menuItem, MenuItem menuItem2, MenuItemDAO menuItemDAO) {
        if (menuItem2 == null) {
            String string = menuItem.getId();
            MenuItem menuItem3 = null;
            if (string != null) {
                menuItem3 = menuItemDAO.get(string);
            }
            if (menuItem3 == null) {
                menuItemDAO.save(menuItem, session);
            } else {
                menuItem.setVersion(menuItem3.getVersion());
            }
        } else {
            menuItem.setVersion(menuItem2.getVersion());
        }
    }

    public boolean shouldSave(Date date, Date date2) {
        if (date == null || date2 == null) {
            return true;
        }
        return date.after(date2);
    }

    public static BaseDataServiceDao getInstance() {
        if (instance == null) {
            instance = new BaseDataServiceDao();
        }
        return instance;
    }

    public void saveOrUpdateKitchenTickets(String string) {
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = jSONObject.getJSONArray(DATA);
            this.debug("Request received: " + string);
            String string3 = string2 = jSONObject.has("deviceId") ? jSONObject.getString("deviceId") : null;
            if (StringUtils.isEmpty((String)string2)) {
                return;
            }
            Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(string2);
            Terminal terminal2 = DataProvider.get().getCurrentTerminal();
            if (terminal == null || terminal2 == null) {
                return;
            }
            if (terminal2.getId().equals(terminal.getId())) {
                return;
            }
            if (terminal2.isMasterTerminal().booleanValue()) {
                ArrayList<KitchenTicket> arrayList = new ArrayList<KitchenTicket>();
                if (jSONArray != null && jSONArray.length() > 0) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                        try {
                            KitchenTicket kitchenTicket = (KitchenTicket)BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class)}).create().fromJson(jSONObject2.toString(), KitchenTicket.class);
                            arrayList.add(kitchenTicket);
                            continue;
                        }
                        catch (Exception exception) {
                            PosLog.error(this.getClass(), exception);
                        }
                    }
                }
                this.saveOrUpdateKitTickets(arrayList);
            }
            this.debug("Successfully saved kitchen tickets");
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void saveOrUpdateKitTickets(List<KitchenTicket> list) {
        Transaction transaction = null;
        try (Session session = null;){
            KitchenTicketDAO kitchenTicketDAO = KitchenTicketDAO.getInstance();
            session = kitchenTicketDAO.createNewSession();
            transaction = session.beginTransaction();
            for (KitchenTicket kitchenTicket : list) {
                if (kitchenTicket == null || kitchenTicket.getId() == null) continue;
                KitchenStatus kitchenStatus = kitchenTicket.getKitchenStatusValue();
                if (kitchenStatus != null && kitchenStatus.equals((Object)KitchenStatus.DISPATCHED)) {
                    this.doPerformDispatchKitchenTicket(session, kitchenTicketDAO, kitchenTicket);
                    continue;
                }
                this.doSaveOrUpdateKitchenTicket(session, kitchenTicketDAO, kitchenTicket);
            }
            transaction.commit();
        }
    }

    private void doPerformDispatchKitchenTicket(Session session, KitchenTicketDAO kitchenTicketDAO, KitchenTicket kitchenTicket) {
        KitchenTicket kitchenTicket2 = kitchenTicketDAO.get(kitchenTicket.getId());
        if (kitchenTicket2 == null) {
            return;
        }
        kitchenTicketDAO.delete(kitchenTicket2, session);
    }

    private void doSaveOrUpdateKitchenTicket(Session session, KitchenTicketDAO kitchenTicketDAO, KitchenTicket kitchenTicket) {
        List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
        KitchenTicket kitchenTicket2 = kitchenTicketDAO.get(kitchenTicket.getId());
        kitchenTicket.setTicketItems(null);
        if (kitchenTicket2 == null) {
            kitchenTicketDAO.save(kitchenTicket, session);
        } else {
            kitchenTicket.setVersion(kitchenTicket2.getVersion());
        }
        List<KitchenTicketItem> list2 = null;
        if (kitchenTicket2 != null) {
            list2 = kitchenTicket2.getTicketItems();
        }
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (list2 == null || list2.isEmpty()) {
                KitchenTicketItemDAO.getInstance().save(kitchenTicketItem, session);
                continue;
            }
            int n = list2.indexOf(kitchenTicketItem);
            if (n != -1) {
                KitchenTicketItem kitchenTicketItem2 = list2.get(n);
                kitchenTicketItem.setVersion(kitchenTicketItem2.getVersion());
                continue;
            }
            KitchenTicketItemDAO.getInstance().save(kitchenTicketItem, session);
        }
        kitchenTicket.setTicketItems(list);
        kitchenTicketDAO.saveOrUpdate(kitchenTicket, session);
    }

    public void saveOrUpdateVoidItems(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        ArrayList<VoidItem> arrayList = new ArrayList<VoidItem>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            VoidItem voidItem = (VoidItem)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject2.toString(), VoidItem.class);
            if (voidItem == null) continue;
            arrayList.add(voidItem);
        }
        this.saveOrUpdateVoidItems(arrayList);
    }

    public void saveOrUpdateVoidItems(List<VoidItem> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            VoidItemDAO voidItemDAO = VoidItemDAO.getInstance();
            session = voidItemDAO.createNewSession();
            transaction = session.beginTransaction();
            for (VoidItem voidItem : list) {
                VoidItem voidItem2 = voidItemDAO.get(voidItem.getId());
                if (voidItem2 == null) {
                    voidItemDAO.save(voidItem, session);
                } else {
                    voidItem.setVersion(voidItem2.getVersion());
                    voidItemDAO.update(voidItem, session);
                }
                VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateAttendanceHistory(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(DATA);
        ArrayList<AttendenceHistory> arrayList = new ArrayList<AttendenceHistory>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            AttendenceHistory attendenceHistory = (AttendenceHistory)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject2.toString(), AttendenceHistory.class);
            if (attendenceHistory == null) continue;
            arrayList.add(attendenceHistory);
        }
        this.saveOrUpdateAttendanceHistory(arrayList);
    }

    public void saveOrUpdateAttendanceHistory(List<AttendenceHistory> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            AttendenceHistoryDAO attendenceHistoryDAO = AttendenceHistoryDAO.getInstance();
            session = attendenceHistoryDAO.createNewSession();
            transaction = session.beginTransaction();
            for (AttendenceHistory attendenceHistory : list) {
                AttendenceHistory attendenceHistory2 = attendenceHistoryDAO.get(attendenceHistory.getId());
                if (attendenceHistory2 == null) {
                    attendenceHistoryDAO.save(attendenceHistory, session);
                    continue;
                }
                attendenceHistory.setVersion(attendenceHistory2.getVersion());
                attendenceHistoryDAO.update(attendenceHistory, session);
            }
            transaction.commit();
        }
    }

    public void saveOrUpdateUsersClockInOutTime(String string) {
        Object object;
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject(string);
        JSONArray jSONArray = jSONObject2.getJSONArray(DATA);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject = jSONArray.getJSONObject(i);
            object = (User)BaseDataServiceDao.getGsonBuilder().create().fromJson(jSONObject.toString(), User.class);
            if (object == null) continue;
            arrayList.add(object);
        }
        jSONObject = null;
        try (Session session = null;){
            object = UserDAO.getInstance();
            session = ((_BaseRootDAO)object).createNewSession();
            jSONObject = session.beginTransaction();
            for (User user : arrayList) {
                User user2 = ((BaseUserDAO)object).get(user.getId());
                if (user2 == null) continue;
                user2.setClockedIn(user.isClockedIn());
                user2.setLastClockInTime(user.getLastClockInTime());
                user2.setLastClockOutTime(user.getLastClockOutTime());
                ((BaseUserDAO)object).update(user2);
            }
            jSONObject.commit();
        }
    }

    public static GsonBuilder getGsonBuilder() {
        return new GsonBuilder().setDateFormat(GSON_PARSING_DATE_FORMAT);
    }
}

