/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ForHereToGoAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JDialog;

public class SettleTicketAction
extends PosAction {
    private Ticket a;
    private User b;

    public SettleTicketAction(Ticket ticket) {
        this.a = ticket;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(Ticket ticket, User user) {
        this.a = ticket;
        this.b = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(DataChangeListener dataChangeListener) {
        super(POSConstants.SETTLE_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            this.performSettle();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public boolean performSettle() {
        PosTransaction posTransaction;
        Serializable serializable;
        Object object;
        User user = this.b;
        if (user == null) {
            user = Application.getCurrentUser();
        }
        if (this.a.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return false;
        }
        if (!POSUtil.checkDrawerAssignment(Application.getInstance().getTerminal(), user)) {
            return false;
        }
        TicketDAO.getInstance().loadFullTicket(this.a);
        if (this.a.isClosed().booleanValue()) {
            this.a.setClosed(false);
            this.a.setReOpened(true);
        }
        if (this.a.getOrderType().getHasForHereAndToGo().booleanValue() && (object = this.a.getSubOrderType()) == null) {
            serializable = new ForHereToGoAction(this.a);
            ((ForHereToGoAction)serializable).execute();
            if (!((ForHereToGoAction)serializable).isPerformed()) {
                return false;
            }
        }
        object = new SettleTicketDialog(this.a, user);
        ((Window)object).setSize(Application.getPosWindow().getSize());
        ((JDialog)object).setDefaultCloseOperation(2);
        serializable = this.a.getOrderType();
        if (((BaseOrderType)serializable).isBarTab().booleanValue() && (posTransaction = this.a.getBartabTransaction()) != null && !posTransaction.isCaptured().booleanValue() && !posTransaction.isVoided().booleanValue()) {
            ((Window)object).addWindowListener(new WindowAdapter((SettleTicketDialog)object){
                final /* synthetic */ SettleTicketDialog a;
                {
                    this.a = settleTicketDialog;
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    try {
                        this.a.settleBartab();
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                        this.a.setCanceled(true);
                        this.a.dispose();
                    }
                }
            });
        }
        ((POSDialog)object).openUndecoratedFullScreen();
        if (((POSDialog)object).isCanceled()) {
            return false;
        }
        if (this.listener != null) {
            this.listener.dataChanged(this.a);
        }
        return true;
    }

    @Override
    protected User getCurrentUser() {
        if (this.b == null) {
            return Application.getCurrentUser();
        }
        return this.b;
    }
}

