/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class TicketTransferAction
extends PosAction {
    private Ticket a;
    private boolean b = false;
    private User c;

    public TicketTransferAction() {
        super(Messages.getString("TicketTransferAction.0"));
    }

    public TicketTransferAction(Ticket ticket, User user) {
        super(Messages.getString("TicketTransferAction.0"));
        this.a = ticket;
        this.c = user;
    }

    public TicketTransferAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("TicketTransferAction.0"), dataChangeListener);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            User user;
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            if (this.a.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketTransferAction.3"), Messages.getString("TicketTransferAction.4"));
            if (n != 0) {
                return;
            }
            this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            User user2 = this.c;
            if (user2 == null) {
                user2 = Application.getCurrentUser();
            }
            if (!user2.equals(user = this.a.getOwner()) && !user2.hasPermission(UserPermission.TRANSFER_TICKET)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderInfoDialog.4") + this.a.getId());
                return;
            }
            UserListDialog userListDialog = new UserListDialog();
            userListDialog.hideUser(user);
            userListDialog.setTitle(Messages.getString("UserTransferDialog.0"));
            userListDialog.setCaption(Messages.getString("UserTransferDialog.1"));
            userListDialog.setSize(PosUIManager.getSize(400, 600));
            userListDialog.open();
            if (userListDialog.isCanceled()) {
                return;
            }
            User user3 = userListDialog.getSelectedUser();
            this.doTransferTickets(user3);
            POSMessageDialog.showMessage(Messages.getString("TicketTransferAction.5"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doTransferTickets(User user) {
        if (user == null) {
            return;
        }
        this.a.setOwner(user);
        TicketDAO.getInstance().saveOrUpdate(this.a);
        this.b = true;
    }

    public boolean isTransfered() {
        return this.b;
    }
}

