/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable a;
    private BeanTableModel<MenuGroup> b;

    public MenuGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(MenuGroup.class);
        this.b.addColumn(POSConstants.NAME, "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.b.addColumn(POSConstants.VISIBLE, "visible");
        this.b.addColumn(POSConstants.SORT_ORDER, "sortOrder");
        this.b.addColumn(POSConstants.BUTTON_COLOR, "buttonColor");
        this.b.addColumn(POSConstants.TEXT_COLOR, "textColor");
        this.a = new JXTable(this.b);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuGroupExplorer.this.c();
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)this.a(), "North");
        this.add(new JScrollPane((Component)this.a));
        this.b();
    }

    private JPanel a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Refresh")));
        JButton jButton = new JButton(POSConstants.REFRESH);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuGroupExplorer.this.initData();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.c();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuGroupForm menuGroupForm = new MenuGroupForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuGroup menuGroup = (MenuGroup)menuGroupForm.getBean();
                    MenuGroupExplorer.this.b.addRow(menuGroup);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuGroupExplorer.this.d();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuGroup menuGroup = this.b.getRow(n);
            MenuGroupForm menuGroupForm = new MenuGroupForm(menuGroup);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void initData() {
        this.b.setRows(MenuGroupDAO.getInstance().findAll());
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuGroup menuGroup = this.b.getRow(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            boolean bl = menuItemDAO.existsMenuItem(menuGroup);
            if (bl && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuGroupExplorer.0"), POSConstants.DELETE) != 0) {
                return;
            }
            MenuGroupDAO menuGroupDAO = new MenuGroupDAO();
            menuGroupDAO.delete(menuGroup);
            this.b.removeRow(menuGroup);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

