/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView {
    private MenuItemExplorerTable a;
    private BeanTableModel<MenuItem> b;
    private JComboBox c;
    private JTextField d;
    private JCheckBox e;
    private JButton f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JLabel j;
    private JComboBox k;
    private JComboBox l;
    private boolean m;
    private JPanel n;
    private JPanel o;
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnDuplicate;

    public MenuItemExplorer() {
        this(false);
    }

    public MenuItemExplorer(boolean bl) {
        this.m = bl;
        this.a();
    }

    private void a() {
        this.b = new BeanTableModel(MenuItem.class, 20);
        this.b.addColumn(POSConstants.NAME, "name");
        this.b.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.b.addColumn(Messages.getString("MenuItemExplorer.12"), "barcode");
        this.b.addColumn(Messages.getString("MenuItemExplorer.15"), MenuItem.PROP_COMBO_ITEM);
        this.b.addColumn(Messages.getString("MenuItemExplorer.27"), MenuItem.PROP_HAS_MODIFIERS);
        this.b.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price", 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("MenuItemExplorer.14"), "availableUnit", 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(Messages.getString("MenuItemExplorer.26"), "unitOnHand", 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(POSConstants.ACTIVE, "visible");
        this.b.addColumn(Messages.getString("MenuItemExplorer.29"), "taxGroup");
        this.b.addColumn(Messages.getString("MenuItemExplorer.21"), "sortOrder", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(Messages.getString("MenuItemExplorer.23"), "buttonColor");
        this.b.addColumn(Messages.getString("MenuItemExplorer.25"), "textColor");
        this.b.addColumn(POSConstants.IMAGE, "explorerImage");
        int n = PosUIManager.getSize(16);
        this.f = new JButton();
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_PREVIOUS, (float)n));
        this.h = new JButton();
        this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.i = new JButton();
        this.i.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.g = new JButton();
        this.g.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_NEXT, (float)n));
        this.j = new JLabel();
        this.a = new MenuItemExplorerTable(this.b);
        this.a.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.a.setSelectionMode(0);
        this.a.setAutoResizeMode(0);
        this.b.initTableRenderer((JTable)((Object)this.a));
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField integerTextField = new IntegerTextField();
        integerTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(integerTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(8), defaultCellEditor);
        this.a.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(45));
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemExplorer.this.f();
                }
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(MenuItemExplorer.this.b.getPreviousRowIndex());
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(MenuItemExplorer.this.b.getNextRowIndex());
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(0);
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = MenuItemExplorer.this.b.getNumRows() / MenuItemExplorer.this.b.getPageSize();
                MenuItemExplorer.this.a(n * MenuItemExplorer.this.b.getPageSize());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)((Object)this.a)));
        this.n = this.d();
        this.add((Component)this.n, "South");
        this.o = this.b();
        this.add((Component)this.o, "North");
        this.resizeColumnWidth((JTable)((Object)this.a));
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        try {
            Serializable serializable2;
            jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.c = new JComboBox();
            this.c.addItem(Messages.getString("MenuItemExplorer.5"));
            List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
            for (Serializable serializable2 : list) {
                this.c.addItem(serializable2);
            }
            this.c.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    MenuItemExplorer.this.a(itemEvent);
                }
            });
            JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.0"));
            serializable2 = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.k = new JComboBox();
            this.k.addItem(Messages.getString("MenuItemExplorer.5"));
            String[] stringArray = new String[]{Messages.getString("MenuItemExplorer.32"), Messages.getString("ACTIVE"), Messages.getString("MenuItemExplorer.34")};
            JLabel jLabel3 = new JLabel(Messages.getString("MenuItemExplorer.35"));
            this.l = new JComboBox<String>(stringArray);
            this.d = new JTextField(15);
            this.e = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton jButton = new JButton(Messages.getString("Search"));
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.d);
            jPanel.add(jLabel);
            jPanel.add(this.c);
            jPanel.add((Component)serializable2);
            jPanel.add(this.k);
            jPanel.add((Component)jLabel3, "split 2");
            jPanel.add(this.l);
            jPanel.add(this.e);
            jPanel.add(jButton);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuItemExplorer.this.c();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (MenuItemExplorer.this.d.getText().length() > 2) {
                        MenuItemExplorer.this.c();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        MenuItemExplorer.this.c();
                    }
                }
            };
            this.d.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    public void setMenuItems(List<MenuItem> list) {
        this.b.removeAll();
        this.n.setVisible(false);
        this.o.setVisible(false);
        this.b.addRows(list);
    }

    private void c() {
        this.a(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Integer n) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object object = this.c.getSelectedItem();
            Object object2 = this.k.getSelectedItem();
            Object object3 = this.l.getSelectedItem();
            String string = this.d.getText();
            Boolean bl = !this.e.isSelected();
            MenuGroup menuGroup = null;
            MenuCategory menuCategory = null;
            Boolean bl2 = null;
            if (object2 instanceof MenuGroup) {
                menuGroup = (MenuGroup)object2;
            }
            if (object instanceof MenuCategory) {
                menuCategory = (MenuCategory)object;
            }
            if (object3.equals("Active")) {
                bl2 = true;
            }
            if (object3.equals("Inactive")) {
                bl2 = false;
            }
            if (n != null) {
                this.b.setCurrentRowIndex(n);
            }
            MenuItemDAO.getInstance().loadMenuItems(this.b, bl, menuGroup, string, menuCategory, this.m, false, bl2);
            int n2 = this.b.getCurrentRowIndex() + 1;
            int n3 = this.b.getNextRowIndex();
            int n4 = this.b.getNumRows();
            if (n3 > n4) {
                n3 = n4;
            }
            this.j.setText(String.format(Messages.getString("MenuItemExplorer.40"), n2, n3, n4));
            this.f.setEnabled(this.b.hasPrevious());
            this.h.setEnabled(this.b.hasPrevious());
            this.i.setEnabled(this.b.hasNext());
            this.g.setEnabled(this.b.hasNext());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private JPanel d() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        this.btnAdd = explorerButtonPanel.getAddButton();
        this.btnDelete = explorerButtonPanel.getDeleteButton();
        this.btnAdd.setText(Messages.getString("MenuItemExplorer.17"));
        jButton.setText(Messages.getString("MenuItemExplorer.18"));
        this.btnDelete.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.f();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.g();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.h();
            }
        });
        this.btnDuplicate = new JButton(Messages.getString("MenuItemExplorer.41"));
        this.btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuItemExplorer.this.i();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        if (!this.m) {
            transparentPanel.add(this.btnAdd);
        }
        transparentPanel.add(jButton);
        if (!this.m) {
            transparentPanel.add(this.btnDelete);
            transparentPanel.add(this.btnDuplicate);
        }
        this.a(transparentPanel);
        jPanel.add((Component)transparentPanel, "");
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.add(this.j);
        jPanel2.add(this.f);
        jPanel2.add(this.h);
        jPanel2.add(this.i);
        jPanel2.add(this.g);
        jPanel.add((Component)jPanel2, "grow");
        return jPanel;
    }

    private void a(JPanel jPanel) {
        JButton jButton = new JButton(Messages.getString("MenuItemExplorer.46"));
        JButton jButton2 = new JButton(Messages.getString("MenuItemExplorer.47"));
        JButton jButton3 = new JButton(Messages.getString("MenuItemExplorer.48"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.IN);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.OUT, false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemExplorer.this.a(InventoryTransactionType.UNCHANGED, true);
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
    }

    private boolean a(InventoryTransactionType inventoryTransactionType, boolean bl) {
        MenuItem menuItem = this.e();
        if (menuItem == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.49"));
            return false;
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        if (bl) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 500));
        beanEditorDialog.open();
        return !beanEditorDialog.isCanceled();
    }

    private boolean a(InventoryTransactionType inventoryTransactionType) {
        Serializable serializable;
        MenuItem menuItem = this.e();
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        InventoryStockInForm inventoryStockInForm = null;
        if (menuItem == null) {
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            serializable = menuItem.getUnit();
            if (serializable == null) {
                POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
                return false;
            }
            Double d = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(d);
            Double d2 = menuItem.getCost();
            inventoryTransaction.setUnitCost(d2);
            inventoryTransaction.setTotal(d * d2);
            inventoryTransaction.setUnit(menuItem.getUnit().getCode());
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        }
        serializable = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)inventoryStockInForm);
        ((BeanEditorDialog)serializable).openWithScale(830, 630);
        if (((BeanEditorDialog)serializable).isCanceled()) {
            return false;
        }
        this.c();
        return true;
    }

    private MenuItem e() {
        int n = this.a.getSelectedRow();
        MenuItem menuItem = null;
        if (n >= 0) {
            n = this.a.convertRowIndexToModel(n);
            menuItem = this.b.getRow(n);
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        return menuItem;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setPreferredWidth(100);
        tableColumnModel.getColumn(4).setPreferredWidth(80);
    }

    private void f() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            MenuItem menuItem = this.b.getRow(n);
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem == null) {
                throw new PosException(Messages.getString("MenuItemExplorer.52"));
            }
            if (this.m) {
                VariantForm variantForm = new VariantForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)variantForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (!beanEditorDialog.isCanceled()) {
                    this.b.setRow(n, menuItem);
                    this.b.fireTableRowsUpdated(n, n);
                }
            } else {
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (!beanEditorDialog.isCanceled()) {
                    this.b.setRow(n, menuItem);
                    this.b.fireTableRowsUpdated(n, n);
                }
            }
        }
        catch (PosException posException) {
            BOMessageDialog.showError(this, posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void g() {
        try {
            Serializable serializable;
            MenuItem menuItem = new MenuItem();
            Object object = this.c.getSelectedItem();
            if (object instanceof OrderType) {
                serializable = new ArrayList<OrderType>();
                serializable.add((OrderType)object);
                menuItem.setOrderTypeList((List)((Object)serializable));
            }
            serializable = new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable, true);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem2 = (MenuItem)((BeanEditor)serializable).getBean();
            this.b.addRow(menuItem2);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void h() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem menuItem = this.b.getRow(n);
            MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
            menuItemDAO.delete(menuItem);
            this.b.removeRow(n);
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.57"));
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void initData() {
        this.c();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup menuGroup : list) {
            this.k.addItem(menuGroup);
        }
    }

    private void a(ItemEvent itemEvent) {
        try {
            Object object = itemEvent.getItem();
            this.k.removeAllItems();
            this.k.addItem(Messages.getString("MenuItemExplorer.5"));
            if (object instanceof MenuCategory) {
                MenuCategory menuCategory = (MenuCategory)object;
                List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
                for (MenuGroup menuGroup : list) {
                    this.k.addItem(menuGroup);
                }
            } else {
                List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
                for (MenuGroup menuGroup : list) {
                    this.k.addItem(menuGroup);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void i() throws Exception {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.59"));
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        MenuItem menuItem = this.b.getRow(n);
        MenuItemDAO.getInstance().initialize(menuItem);
        MenuItem menuItem2 = menuItem.clone();
        MenuItemForm menuItemForm = new MenuItemForm(menuItem2);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
        beanEditorDialog.openWithScale(1000, 700);
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuItem menuItem3 = (MenuItem)menuItemForm.getBean();
        this.b.addRow(menuItem3);
        this.a.getSelectionModel().addSelectionInterval(this.b.getRowCount() - 1, this.b.getRowCount() - 1);
        this.a.scrollRowToVisible(this.b.getRowCount() - 1);
    }

    private class MenuItemExplorerTable
    extends JXTable {
        public MenuItemExplorerTable(TableModel tableModel) {
            super(tableModel);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            super.changeSelection(n, n2, bl, bl2);
            MenuItemExplorer.this.a.editCellAt(n, n2);
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)MenuItemExplorer.this.a.getCellEditor(n, n2);
            if (defaultCellEditor.getComponent() instanceof IntegerTextField) {
                IntegerTextField integerTextField = (IntegerTextField)defaultCellEditor.getComponent();
                integerTextField.requestFocus();
                integerTextField.selectAll();
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            MenuItem menuItem = (MenuItem)MenuItemExplorer.this.b.getRow(n);
            Integer n3 = 0;
            if (object != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            super.setValueAt((Object)n3, n, n2);
            if (n2 == 10) {
                menuItem.setSortOrder(n3);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

