/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MenuShiftExplorer
extends TransparentPanel {
    private JTable a;
    private MenuShiftTableModel b;

    public MenuShiftExplorer() {
        List<MenuShift> list = new MenuShiftDAO().findAll();
        this.b = new MenuShiftTableModel(list);
        this.a = new JTable(this.b);
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuShiftExplorer.this.a();
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.a));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuShiftEntryDialog menuShiftEntryDialog = new MenuShiftEntryDialog();
                    menuShiftEntryDialog.open();
                    if (menuShiftEntryDialog.isCanceled()) {
                        return;
                    }
                    MenuShift menuShift = menuShiftEntryDialog.getCategoryShift();
                    MenuShiftExplorer.this.b.addItem(menuShift);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuShiftExplorer.this.a();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = MenuShiftExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuShiftExplorer.0"));
                        return;
                    }
                    MenuShift menuShift = (MenuShift)MenuShiftExplorer.this.b.getRowData(n);
                    if (ConfirmDeleteDialog.showMessage(MenuShiftExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        MenuShiftDAO.getInstance().delete(menuShift);
                        MenuShiftExplorer.this.b.deleteItem(n);
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuShiftExplorer.1"));
                return;
            }
            MenuShift menuShift = (MenuShift)this.b.getRowData(n);
            MenuShiftEntryDialog menuShiftEntryDialog = new MenuShiftEntryDialog();
            menuShiftEntryDialog.setMenuShift(menuShift);
            menuShiftEntryDialog.open();
            if (menuShiftEntryDialog.isCanceled()) {
                return;
            }
            this.b.updateItem(n);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class MenuShiftTableModel
    extends ListTableModel {
        MenuShiftTableModel(List list) {
            super(new String[]{POSConstants.NAME, POSConstants.DESCRIPTION, Messages.getString("MenuShiftExplorer.2"), POSConstants.START_TIME, POSConstants.END_TIME, Messages.getString("MenuShiftExplorer.3"), Messages.getString("MenuShiftExplorer.4"), Messages.getString("ACTIVE")}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MenuShift menuShift = (MenuShift)this.rows.get(n);
            if (menuShift == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return menuShift.getName();
                }
                case 1: {
                    return menuShift.getDescription();
                }
                case 2: {
                    return menuShift.getDayOfWeekAsString();
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(menuShift.getStartTime());
                }
                case 4: {
                    return ShiftUtil.buildShiftTimeRepresentation(menuShift.getEndTime());
                }
                case 5: {
                    return menuShift.getPriority();
                }
                case 6: {
                    return menuShift.isAnyDay();
                }
                case 7: {
                    return menuShift.isEnable();
                }
            }
            return null;
        }
    }
}

