/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class ModifierExplorer
extends TransparentPanel
implements ExplorerView {
    private String a;
    private JXTable b;
    private ModifierExplorerModel c;
    private JTextField d;

    public ModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.a = CurrencyUtil.getCurrencySymbol();
        this.c = new ModifierExplorerModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.add(new JScrollPane((Component)this.b));
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ModifierExplorer.this.c();
                }
            }
        });
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.b.setSelectionMode(0);
        this.b.getColumnModel().getColumn(8).setCellRenderer(new DefaultTableCellRenderer(){
            private Border b = null;
            private Border c = null;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModifierExplorerModel modifierExplorerModel = (ModifierExplorerModel)jTable.getModel();
                Object e = modifierExplorerModel.getRowData(n);
                if (this.c == null) {
                    this.c = BorderFactory.createMatteBorder(5, 5, 5, 5, jTable.getSelectionBackground());
                }
                if (this.b == null) {
                    this.b = BorderFactory.createMatteBorder(5, 5, 5, 5, jTable.getBackground());
                }
                if (e instanceof MenuModifier && object instanceof ImageIcon) {
                    JLabel jLabel = new JLabel(((MenuModifier)e).getImage());
                    if (bl) {
                        jLabel.setBorder(this.c);
                    } else {
                        jLabel.setBorder(this.b);
                    }
                    return jLabel;
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.b.setRowHeight(PosUIManager.getSize(60));
        this.a();
        this.add((Component)this.b(), "North");
    }

    private void a() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        explorerButtonPanel.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuModifierForm menuModifierForm = new MenuModifierForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuModifierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier = (MenuModifier)menuModifierForm.getBean();
                    ModifierExplorer.this.c.addModifier(menuModifier);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        explorerButtonPanel.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierExplorer.this.c();
            }
        });
        explorerButtonPanel.getDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = ModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = ModifierExplorer.this.b.convertRowIndexToModel(n);
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        MenuModifier menuModifier = (MenuModifier)ModifierExplorer.this.c.getRowData(n);
                        MenuModifierDAO menuModifierDAO = new MenuModifierDAO();
                        menuModifierDAO.delete(menuModifier);
                        ModifierExplorer.this.c.deleteModifier(menuModifier, n);
                    }
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton = new JButton(Messages.getString("ModifierExplorer.9"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = ModifierExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierExplorer.10"));
                        return;
                    }
                    n = ModifierExplorer.this.b.convertRowIndexToModel(n);
                    MenuModifier menuModifier = (MenuModifier)ModifierExplorer.this.c.getRowData(n);
                    MenuModifier menuModifier2 = new MenuModifier();
                    PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                    menuModifier2.setId(null);
                    String string = ModifierExplorer.this.a(menuModifier);
                    menuModifier2.setName(string);
                    MenuModifierForm menuModifierForm = new MenuModifierForm(menuModifier2);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuModifierForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier3 = (MenuModifier)menuModifierForm.getBean();
                    ModifierExplorer.this.c.addModifier(menuModifier3);
                    ModifierExplorer.this.b.getSelectionModel().addSelectionInterval(ModifierExplorer.this.c.getRowCount() - 1, ModifierExplorer.this.c.getRowCount() - 1);
                    ModifierExplorer.this.b.scrollRowToVisible(ModifierExplorer.this.c.getRowCount() - 1);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        explorerButtonPanel.add(jButton);
        this.add((Component)explorerButtonPanel, "South");
    }

    private String a(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        String string2 = new String();
        int n = string.lastIndexOf(" ");
        if (n == -1) {
            string2 = string + " 1";
        } else {
            String string3 = string.substring(n + 1, string.length());
            if (StringUtils.isNumeric((CharSequence)string3)) {
                Integer n2 = Integer.valueOf(string3);
                n2 = n2 + 1;
                string2 = string.replace(string3, String.valueOf(n2));
            } else {
                string2 = string + " 1";
            }
        }
        return string2;
    }

    private int b(MenuModifier menuModifier) {
        String string = menuModifier.getName();
        Pattern pattern = Pattern.compile(" .* ([0-9]+)");
        Matcher matcher = pattern.matcher(string);
        int n = 1;
        if (matcher.find()) {
            try {
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 + 1 > n) {
                    n = n2 + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]20[]"));
        JLabel jLabel = new JLabel(Messages.getString("NAME"));
        JLabel jLabel2 = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.d = new JTextField(15);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Messages.getString("ModifierExplorer.5"));
        JButton jButton = new JButton(Messages.getString("Search"));
        jPanel.add((Component)jLabel, "align label");
        jPanel.add(this.d);
        jPanel.add(jButton);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierExplorer.this.d();
            }
        });
        return jPanel;
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuModifier menuModifier = (MenuModifier)this.c.getRowData(n);
            MenuModifierDAO.getInstance().initialize(menuModifier);
            MenuModifierForm menuModifierForm = new MenuModifierForm(menuModifier);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuModifierForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        List<MenuModifier> list;
        String string = this.d.getText();
        if (this.c.getRowCount() > 0) {
            this.c.removeAll();
        }
        if ((list = MenuModifierDAO.getInstance().getMenuModifiers(string)) == null) {
            list = new ArrayList<MenuModifier>();
        }
        this.c.setRows(list);
    }

    @Override
    public void initData() {
        this.d();
    }

    private class ModifierExplorerModel
    extends ListTableModel {
        public ModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.PRICE + " (" + ModifierExplorer.this.a + ")", POSConstants.EXTRA_PRICE, Messages.getString("TAX_GROUP") + Messages.getString("ModifierExplorer.0"), POSConstants.BUTTON_COLOR, Messages.getString("TextColor"), POSConstants.SORT_ORDER, Messages.getString("ModifierExplorer.2")});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            List list = this.getRows();
            MenuModifier menuModifier = (MenuModifier)list.get(n);
            switch (n2) {
                case 0: {
                    return menuModifier.getName();
                }
                case 1: {
                    return menuModifier.getTranslatedName();
                }
                case 2: {
                    return (double)menuModifier.getPrice();
                }
                case 3: {
                    return (double)menuModifier.getExtraPrice();
                }
                case 4: {
                    if (menuModifier.getTaxGroup() == null) {
                        return "";
                    }
                    return menuModifier.getTaxGroup();
                }
                case 5: {
                    if (menuModifier.getButtonColor() != null) {
                        return new Color(menuModifier.getButtonColor());
                    }
                }
                case 6: {
                    if (menuModifier.getTextColor() != null) {
                        return new Color(menuModifier.getTextColor());
                    }
                    return null;
                }
                case 7: {
                    return menuModifier.getSortOrder();
                }
                case 8: {
                    return menuModifier.getImage();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier menuModifier) {
            int n = this.getRows().size();
            this.getRows().add(menuModifier);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifier(MenuModifier menuModifier, int n) {
            this.getRows().remove(menuModifier);
            this.fireTableRowsDeleted(n, n);
        }

        public void removeAll() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        public void addRows(List<MenuModifier> list) {
            if (list == null) {
                return;
            }
            for (MenuModifier menuModifier : list) {
                this.addModifier(menuModifier);
            }
            this.fireTableDataChanged();
        }
    }
}

