/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.UserTypeForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class UserTypeExplorer
extends TransparentPanel {
    private List<UserType> a;
    private JTable b;
    private UserTypeExplorerTableModel c;

    public UserTypeExplorer() {
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        this.a = userTypeDAO.findAll();
        this.c = new UserTypeExplorerTableModel();
        this.b = new JTable(this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.b));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserTypeExplorer.this.b();
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserTypeExplorer.this.c();
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserTypeExplorer.this.a();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    private void a() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.1"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                UserType userType = this.a.get(n);
                UserTypeDAO userTypeDAO = new UserTypeDAO();
                userTypeDAO.delete(userType);
                this.c.deleteCategory(userType, n);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        try {
            UserTypeForm userTypeForm = new UserTypeForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userTypeForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 450));
            beanEditorDialog.pack();
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            UserType userType = (UserType)userTypeForm.getBean();
            this.c.addType(userType);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.0"));
                return;
            }
            UserType userType = this.a.get(n);
            UserTypeForm userTypeForm = new UserTypeForm(userType);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)userTypeForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 450));
            beanEditorDialog.pack();
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    class UserTypeExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.TYPE_NAME, POSConstants.PERMISSIONS};

        UserTypeExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (UserTypeExplorer.this.a == null) {
                return 0;
            }
            return UserTypeExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (UserTypeExplorer.this.a == null) {
                return "";
            }
            UserType userType = (UserType)UserTypeExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return userType.getName();
                }
                case 1: {
                    return userType.getPermissions();
                }
            }
            return null;
        }

        public void addType(UserType userType) {
            int n = UserTypeExplorer.this.a.size();
            UserTypeExplorer.this.a.add(userType);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteCategory(UserType userType, int n) {
            UserTypeExplorer.this.a.remove(userType);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

