/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerListTableModel;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.customer.CustomerTable;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.QuickCustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DefaultCustomerListView
extends CustomerSelector {
    private PosButton a;
    private CustomerTable b;
    private POSTextField c;
    private PosButton d;
    protected Customer selectedCustomer;
    private Ticket e;
    private PosButton f;
    private QwertyKeyPad g;
    private PosButton h;
    private CustomerListTableModel i;
    private PosButton j;
    private PosButton k;
    private JLabel l;

    public DefaultCustomerListView() {
        this.initUI();
        this.c();
    }

    public DefaultCustomerListView(Ticket ticket) {
        this.e = ticket;
        this.initUI();
        this.a();
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.c = new POSTextField(120);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.c();
            }
        });
        PosButton posButton = new PosButton(Messages.getString("CustomerSelectionDialog.15"));
        posButton.setFocusable(false);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.c();
            }
        });
        PosButton posButton2 = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.g.setCollapsed(!DefaultCustomerListView.this.g.isCollapsed());
            }
        });
        jPanel.add((Component)this.c, "growy");
        jPanel.add((Component)posButton2, "growy,w " + PosUIManager.getSize(80) + "!,h " + PosUIManager.getSize(35) + "!");
        jPanel.add((Component)posButton, ",growy,h " + PosUIManager.getSize(35) + "!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setBorder(new TitledBorder(null, POSConstants.SELECT_CUSTOMER, 2, 2, null, null));
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.b = new CustomerTable();
        this.i = new CustomerListTableModel();
        this.b.setModel(this.i);
        this.b.setFocusable(false);
        this.b.setRowHeight(30);
        this.b.getTableHeader().setPreferredSize(new Dimension(100, 35));
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultCustomerListView.this.selectedCustomer = DefaultCustomerListView.this.b.getSelectedCustomer();
                if (DefaultCustomerListView.this.selectedCustomer == null) {
                    DefaultCustomerListView.this.d.setEnabled(false);
                }
            }
        });
        PosScrollPane posScrollPane = new PosScrollPane();
        posScrollPane.setFocusable(false);
        posScrollPane.setViewportView(this.b);
        jPanel3.add((Component)posScrollPane, "Center");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3", "[][center, grow][]", ""));
        this.d = new PosButton(Messages.getString("CustomerSelectionDialog.23"));
        this.d.setFocusable(false);
        jPanel4.add((Component)this.d, " skip 1, split 7");
        this.d.setEnabled(false);
        PosButton posButton3 = new PosButton(Messages.getString("CustomerSelectionDialog.24"));
        posButton3.setEnabled(false);
        jPanel4.add((Component)posButton3, "");
        this.a = new PosButton(Messages.getString("NEW"));
        this.a.setFocusable(false);
        jPanel4.add((Component)this.a, "");
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.doCreateNewCustomer();
            }
        });
        this.h = new PosButton(Messages.getString("EDIT"));
        this.h.setFocusable(false);
        jPanel4.add((Component)this.h, "");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.doEditCustomer();
            }
        });
        PosButton posButton4 = new PosButton(Messages.getString("CustomerSelectionDialog.28"));
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DefaultCustomerListView.this.getSelectedCustomer() == null) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DefaultCustomerListView.0"));
                    return;
                }
                if (DefaultCustomerListView.this.isCreateNewTicket()) {
                    DefaultCustomerListView.this.b();
                } else {
                    DefaultCustomerListView.this.a(false);
                }
            }
        });
        jPanel4.add((Component)posButton4, "");
        this.f = new PosButton(Messages.getString("CANCEL"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultCustomerListView.this.a(true);
            }
        });
        jPanel4.add((Component)this.f, "");
        this.j = new PosButton(Messages.getString("DefaultCustomerListView.1"));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DefaultCustomerListView.this.i.hasNext()) {
                    DefaultCustomerListView.this.i.setCurrentRowIndex(DefaultCustomerListView.this.i.getNextRowIndex());
                    DefaultCustomerListView.this.doSearchCustomer();
                }
            }
        });
        this.k = new PosButton(Messages.getString("DefaultCustomerListView.2"));
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DefaultCustomerListView.this.i.hasPrevious()) {
                    DefaultCustomerListView.this.i.setCurrentRowIndex(DefaultCustomerListView.this.i.getPreviousRowIndex());
                    DefaultCustomerListView.this.doSearchCustomer();
                }
                DefaultCustomerListView.this.updateButtonStatus();
            }
        });
        this.l = new JLabel();
        jPanel4.add(new JSeparator());
        jPanel4.add(this.l);
        jPanel4.add(this.k);
        jPanel4.add(this.j);
        jPanel3.add((Component)jPanel4, "South");
        jPanel2.add((Component)jPanel3, "Center");
        this.add(jPanel2);
        this.g = new QwertyKeyPad();
        this.g.setCollapsed(false);
        this.add((Component)((Object)this.g), "South");
        this.updateButtonStatus();
    }

    public void updateButtonStatus() {
        this.j.setEnabled(this.i.hasNext());
        this.k.setEnabled(this.i.hasPrevious());
    }

    private void a() {
        String string = this.e.getProperty("CUSTOMER_ID");
        if (StringUtils.isNotEmpty((String)string)) {
            Customer customer = CustomerDAO.getInstance().get(string);
            ArrayList<Customer> arrayList = new ArrayList<Customer>();
            arrayList.add(customer);
            this.b.setModel(new CustomerListTableModel(arrayList));
        }
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    protected void doSetCustomer(Customer customer) {
        if (this.e != null) {
            this.e.setCustomer(customer);
            TicketDAO.getInstance().saveOrUpdate(this.e);
        }
    }

    private void b() {
        try {
            Customer customer = this.getSelectedCustomer();
            if (customer == null) {
                return;
            }
            this.a(false);
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), null, customer);
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            POSMessageDialog.showError(this, ticketAlreadyExistsException.getMessage());
        }
    }

    protected void doRemoveCustomerFromTicket() {
        if (this.e == null) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("CustomerSelectionDialog.2"), Messages.getString("CONFIRM"));
        if (n != 0) {
            return;
        }
        this.e.removeCustomer();
        TicketDAO.getInstance().saveOrUpdate(this.e);
    }

    private void c() {
        this.i.setCurrentRowIndex(0);
        this.doSearchCustomer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSearchCustomer() {
        try {
            int n;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.g.setCollapsed(true);
            String string = this.c.getText();
            if (StringUtils.isEmpty((String)string)) {
                this.i.setNumRows(CustomerDAO.getInstance().getNumberOfCustomers());
                CustomerDAO.getInstance().loadCustomers(this.i);
            } else {
                CustomerDAO.getInstance().findByMobileLoyalityName(string, this.i);
            }
            if (this.i.getRows().size() == 0) {
                this.b.getSelectionModel().addSelectionInterval(0, 0);
            }
            int n2 = this.i.getCurrentRowIndex() + 1;
            int n3 = this.i.getNextRowIndex();
            if (n3 > (n = this.i.getNumRows())) {
                n3 = n;
            }
            this.l.setText(String.format(Messages.getString("DefaultCustomerListView.3"), n2, n3, n));
            this.i.fireTableDataChanged();
            this.b.repaint();
            this.updateButtonStatus();
        }
        catch (Exception exception) {
            PosLog.error(DefaultCustomerListView.class, exception);
            exception.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void doCreateNewCustomer() {
        boolean bl = true;
        QuickCustomerForm quickCustomerForm = new QuickCustomerForm(bl);
        quickCustomerForm.enableCustomerFields(true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(quickCustomerForm);
        beanEditorDialog.setResizable(false);
        beanEditorDialog.open();
        if (!beanEditorDialog.isCanceled()) {
            this.selectedCustomer = (Customer)quickCustomerForm.getBean();
            CustomerListTableModel customerListTableModel = (CustomerListTableModel)this.b.getModel();
            customerListTableModel.addItem(this.selectedCustomer);
        }
    }

    protected void doEditCustomer() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, Messages.getString("DefaultCustomerListView.4"));
            return;
        }
        CustomerListTableModel customerListTableModel = (CustomerListTableModel)this.b.getModel();
        Customer customer = (Customer)customerListTableModel.getRowData(n);
        if (customer == null) {
            return;
        }
        QuickCustomerForm quickCustomerForm = new QuickCustomerForm(customer);
        quickCustomerForm.enableCustomerFields(true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(quickCustomerForm);
        beanEditorDialog.setResizable(false);
        beanEditorDialog.open();
        if (!beanEditorDialog.isCanceled()) {
            customerListTableModel.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public String getName() {
        return "C";
    }

    @Override
    public Customer getSelectedCustomer() {
        return this.selectedCustomer;
    }

    @Override
    public void updateView(boolean bl) {
        Store store = Application.getInstance().getStore();
        this.a.setVisible(store.hasCreateMemberPermission());
        this.f.setVisible(bl);
        this.d();
    }

    private void d() {
        Customer customer = this.getCustomer();
        if (customer != null) {
            this.c();
        } else {
            this.c();
        }
    }

    @Override
    public void redererCustomers() {
    }
}

