/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OroLicenceActivationDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.LicenseValidationUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.PosWebService;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceRoyale;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.ConnectException;
import java.sql.SQLNonTransientConnectionException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import jiconfont.IconFont;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

public class Application {
    private static Log a = LogFactory.getLog(Application.class);
    private boolean b = false;
    private PosWindow c;
    private User d;
    private RootView e;
    private static Application f;
    private static SimpleDateFormat g;
    private static ImageIcon h;
    private boolean i;
    private boolean j;
    private boolean k = false;
    private static final String l = "OROPOS";
    private static final String m = "https://pos.orocube.com/pricing/";
    private static final String n = "https://pos.orocube.com/download/#section-2.-Request-Pin";
    public static final String OROPOS_LICENSE_PIN = "OROPOS.license.pin";
    private OroLicense o;
    private UpdateManager p;
    private boolean q;

    protected Application() {
    }

    public void start() {
        System.setProperty("data.provider.class", "com.floreantpos.model.dao.util.PosCacheManager");
        if (POSUtil.isWindowsOs()) {
            AppConfig.put("appLanucher", VersionInfo.getAppName().toLowerCase() + ".exe");
        } else {
            AppConfig.put("appLanucher", VersionInfo.getAppName().toLowerCase() + ".sh");
        }
        this.p = new UpdateManager();
        this.p.checkHasRemainingUpdates();
        this.c();
        h = new ImageIcon(this.getClass().getResource("/icons/icon.png"));
        this.c = new PosWindow();
        this.c.initComponents();
        this.c.initTimers();
        this.c.setTitle(Application.getTitle());
        this.c.setIconImage(h.getImage());
        this.c.setupSizeAndLocation();
        if (TerminalConfig.isKioskMode()) {
            this.c.enterFullScreenMode();
        }
        this.p.setParentWindow(this.c);
        this.c.setVisible(true);
        this.initLicense(TerminalUtil.getSystemUID());
        this.e = RootView.getInstance();
        this.e.initDefaultViews();
        this.c.getContentPane().add(this.e);
        this.initializeSystem();
        this.b();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.p.checkForUpdate();
        }
        this.a();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && terminal.isMasterTerminal().booleanValue()) {
            OroCronJobManager.getInstance().startScheduler();
        }
    }

    private void a() {
        AsyncAction.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PosResponse posResponse = PosWebService.get().checkConnection();
                    Application.this.q = posResponse != null && posResponse.getResponseCode() == 200;
                }
                catch (Exception exception) {
                    Application.this.q = false;
                }
            }
        });
    }

    private void b() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroMqttClient.getInstance().initMqttClient(Application.this.getMqttDeviceId());
                    Application.this.p.subscribeToUpdateService();
                    Application.this.p.publishIfNewUpdateAvailable();
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception.getMessage(), exception);
                }
            }
        }).start();
    }

    public String getMqttDeviceId() {
        String string = VersionInfo.getAppName().replaceAll("[^\\p{Alnum}]", "_") + TerminalUtil.getSystemUID();
        return AppConfig.getString("mqtt.deviceId", string);
    }

    public void checkForUpdate() {
        this.p.checkForUpdate();
    }

    public String getUpdateServerURL() {
        String string = TerminalConfig.getUpdateServerURL();
        if (StringUtils.isEmpty((String)string)) {
            string = "https://orodev.net/update/oropos";
        }
        return string;
    }

    public void initLicense(String string) {
        try {
            this.o = LicenseUtil.loadAndValidate((String)this.getProductName(), (String)this.getProductVersion(), (String)string);
            LicenseValidationUtil.doCheckPinNumber(this.o, OROPOS_LICENSE_PIN);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            if (string.equals(TerminalUtil.getSystemUID())) {
                this.initLicense(TerminalUtil.getOldSystemUID());
            } else {
                this.o = OroLicenceActivationDialog.showDialog(this.c, this.getProductName(), this.getProductVersion());
                LicenseValidationUtil.doCheckPinNumber(this.o, OROPOS_LICENSE_PIN);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public void startInvisible() {
        this.c();
        h = new ImageIcon(this.getClass().getResource("/icons/icon_updated.png"));
        this.c = new PosWindow();
        this.c.setTitle(Application.getTitle());
        this.c.setIconImage(h.getImage());
        this.e = RootView.getInstance();
        this.c.getContentPane().add(this.e);
        this.initializeSystem();
    }

    private void c() {
        try {
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceRoyale());
            UIManager.put("Button.background", new ColorUIResource(Color.WHITE));
            UIManager.put("ComboBox.background", new ColorUIResource(Color.WHITE));
            UIManager.put("ButtonUI", "com.floreantpos.swing.POSButtonUI");
            UIManager.put("ToggleButtonUI", "com.floreantpos.swing.POSToggleButtonUI");
            UIManager.put("OptionPane.yesButtonText", Messages.getString("Application.10"));
            UIManager.put("OptionPane.noButtonText", Messages.getString("Application.12"));
            UIManager.put("OptionPane.cancelButtonText", Messages.getString("Cancel"));
            UIManager.put("OptionPane.titleText", Messages.getString("Application.16"));
            UIManager.put("OptionPane.okButtonText", Messages.getString("Application.18"));
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            this.f();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeSystem() {
        if (this.isSystemInitialized()) {
            return;
        }
        try {
            this.c.setGlassPaneVisible(true);
            this.p.performDatabaseUpgrade();
            DatabaseUtil.initialize();
            DatabaseUtil.updateLegacyDatabase();
            DataProvider.get().initialize();
            if (!this.j) {
                this.d();
                this.j = true;
            }
            LoginView.getInstance().initializeOrderButtonPanel();
            Application.getPosWindow().updateView();
            this.setSystemInitialized(true);
        }
        catch (DatabaseConnectionException | ConnectException | SQLNonTransientConnectionException | HibernateException throwable) {
            int n = JOptionPane.showConfirmDialog(Application.getPosWindow(), Messages.getString("Application.0"), "PosMessage.Error", 0);
            if (n == 0) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            a.error((Object)exception);
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
    }

    public void initializeHeadless() {
        this.k = true;
        _RootDAO.initialize();
        DataProvider.get().initialize();
        this.e();
        this.refreshStore();
        this.setSystemInitialized(true);
    }

    private void d() {
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            floreantPlugin.initUI(Application.getPosWindow());
        }
    }

    private void e() {
        try {
            Store store = DataProvider.get().getStore();
            if (!this.k) {
                if (store.isItemPriceIncludesTax().booleanValue()) {
                    this.c.setStatus(Messages.getString("Application.41"));
                } else {
                    this.c.setStatus(Messages.getString("Application.42"));
                }
                this.c.setRestaurantName(store.getName());
            }
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(exception);
        }
    }

    public void refreshStore() {
        DataProvider.get().refreshStore();
    }

    public List<OrderType> getOrderTypes() {
        return DataProvider.get().getOrderTypes();
    }

    public static synchronized Application getInstance() {
        if (f == null) {
            f = new Application();
        }
        return f;
    }

    public static void setInstance(Application application) {
        f = application;
    }

    public synchronized void doLogin(User user) {
        this.initializeSystem();
        if (user == null) {
            return;
        }
        boolean bl = this.initCurrentUser(user);
        RootView rootView = this.getRootView();
        if (!rootView.hasView("ORDER_VIEW")) {
            rootView.addView(OrderView.getInstance());
        }
        if (bl) {
            rootView.showDefaultView();
        }
        this.c.rendererUserInfo();
        this.c.startAutoLogoffTimer();
    }

    public boolean initCurrentUser(User user) {
        if (!user.isClockedIn().booleanValue()) {
            ClockInOutDialog clockInOutDialog = ClockInOutDialog.getInstance(user, true);
            clockInOutDialog.openUndecoratedFullScreen();
            if (clockInOutDialog.isCanceled()) {
                return false;
            }
        }
        this.setCurrentUser(user);
        return true;
    }

    public void doLogout() {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (backOfficeWindow != null && backOfficeWindow.isVisible()) {
            backOfficeWindow.dispose();
        }
        this.setCurrentUser(null);
        RootView.getInstance().showView(LoginView.getInstance());
        this.c.rendererUserInfo();
        this.c.stopAutoLogoffTimer();
    }

    public void doAutoLogout() {
        this.doLogout();
    }

    public void doAutoLogin(User user) {
        this.setCurrentUser(user);
    }

    public static User getCurrentUser() {
        return Application.getInstance().d;
    }

    public void setCurrentUser(User user) {
        this.d = user;
    }

    public RootView getRootView() {
        return this.e;
    }

    public void setRootView(RootView rootView) {
        this.e = rootView;
    }

    public static PosWindow getPosWindow() {
        return Application.getInstance().c;
    }

    public Terminal getTerminal() {
        return DataProvider.get().getCurrentTerminal();
    }

    public synchronized Terminal refreshAndGetTerminal() {
        DataProvider.get().refreshCurrentTerminal();
        return DataProvider.get().getCurrentTerminal();
    }

    public static PosPrinters getPrinters() {
        return DataProvider.get().getPrinters();
    }

    public OrderType getCurrentOrderType() {
        return DataProvider.get().getOrderTypes().get(0);
    }

    public static String getTitle() {
        return VersionInfo.getAppName() + " " + VersionInfo.getVersion();
    }

    public static ImageIcon getApplicationIcon() {
        return h;
    }

    public static void setApplicationIcon(ImageIcon imageIcon) {
        h = imageIcon;
    }

    public static String formatDate(Date date) {
        return g.format(date);
    }

    public boolean isSystemInitialized() {
        return this.i;
    }

    public void setSystemInitialized(boolean bl) {
        this.i = bl;
    }

    public Store getStore() {
        return DataProvider.get().getStore();
    }

    public static Outlet getOutlet() {
        return DataProvider.get().getOutlet();
    }

    public static File getWorkingDir() {
        File file = new File(Application.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.getParentFile();
    }

    public boolean isDevelopmentMode() {
        return this.b;
    }

    public void setDevelopmentMode(boolean bl) {
        this.b = bl;
    }

    public boolean isPriceIncludesTax() {
        Store store = this.getStore();
        if (store == null) {
            return false;
        }
        return POSUtil.getBoolean(store.isItemPriceIncludesTax());
    }

    public String getLocation() {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return file.getParent();
    }

    private void f() {
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (object == null || !(object instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)object;
            String string = fontUIResource.getFontName();
            string = "Sans";
            Font font = new Font(string, fontUIResource.getStyle(), PosUIManager.getDefaultFontSize());
            UIManager.put(k, new FontUIResource(font));
        }
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        IconFontSwing.register((IconFont)GoogleMaterialDesignIcons.getIconFont());
    }

    public void shutdownPOS() {
        int n = POSMessageDialog.showYesNoQuestionDialog(this.c, POSConstants.CONFIRM_SHUTDOWN_MESSAGE, POSConstants.CONFIRM);
        if (n == 0) {
            this.c.saveSizeAndLocation();
            _RootDAO.releaseConnection();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            if (terminal != null && terminal.isMasterTerminal().booleanValue()) {
                OroCronJobManager.getInstance().shutdownScheduler();
            }
            System.exit(0);
        }
    }

    public OroLicense getLicense() {
        return this.o;
    }

    public String getProductName() {
        return l;
    }

    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    public void refreshCurrentUser() {
        if (this.d != null) {
            UserDAO.getInstance().refresh(this.d);
        }
    }

    public String getHibernateConfigurationFileName() {
        return "oropos.hibernate.cfg.xml";
    }

    @Deprecated
    public static String getLengthUnit() {
        return Messages.getString("Application.26");
    }

    public UpdateManager getUpdateManager() {
        return this.p;
    }

    public boolean isCloudConnected() {
        return this.q;
    }

    public void setCloudConnected(boolean bl) {
        this.q = bl;
    }

    public String getCurrentTerminalOutletId() {
        return StringUtils.isNotEmpty((String)this.getTerminal().getOutletId()) ? this.getTerminal().getOutletId() : this.getStore().getDefaultOutletId();
    }

    public static String getUrlPosPricing() {
        return m;
    }

    public static String getUrlRequestPin() {
        return n;
    }

    static {
        g = new SimpleDateFormat("dd MMM, yyyy");
    }
}

