/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.base.BaseMenuPageItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class MenuPageItem
extends BaseMenuPageItem {
    private static final long serialVersionUID = 1L;
    private transient MenuItem menuItem;
    private final String randomId = UUID.randomUUID().toString();

    public MenuPageItem() {
    }

    public MenuPageItem(String string) {
        super(string);
    }

    public MenuPageItem(Integer n, Integer n2) {
        super.setCol(n);
        super.setRow(n2);
    }

    public MenuPageItem(Integer n, Integer n2, MenuItem menuItem, MenuPage menuPage) {
        super.setCol(n);
        super.setRow(n2);
        this.setMenuItem(menuItem);
        this.setMenuPage(menuPage);
    }

    public void setMenuPage(MenuPage menuPage) {
        if (menuPage != null) {
            this.setMenuPageId(menuPage.getId());
        } else {
            this.setMenuPageId(null);
        }
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null && this.getMenuItemId() != null) {
            this.menuItem = MenuItemDAO.getInstance().get(this.getMenuItemId());
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            this.setMenuItemId(menuItem.getId());
            this.setMenuItemName(menuItem.getDisplayName());
            this.setTranslatedName(menuItem.getTranslatedName());
            this.setButtonColorCode(menuItem.getButtonColorCode());
            this.setTextColorCode(menuItem.getTextColorCode());
            this.setImageId(menuItem.getImageId());
            this.setShowImageOnly(menuItem.isShowImageOnly());
            this.setVariant(menuItem.isVariant());
            this.setHasVariant(menuItem.isHasVariant());
            this.setVisible(menuItem.isVisible());
        } else {
            this.setMenuItemId(null);
        }
    }

    public void setImage(ImageIcon imageIcon) {
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    @Override
    public Integer getButtonColorCode() {
        Integer n = super.getButtonColorCode();
        if (n == null || n == 0 || n == -1316371) {
            n = Color.WHITE.getRGB();
        }
        return n;
    }

    @XmlTransient
    public Color getButtonColor() {
        Integer n = this.getButtonColorCode();
        if (n == null) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public void setButtonColor(Color color) {
        if (color != null) {
            this.setButtonColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color color) {
        if (color != null) {
            this.setTextColorCode(color.getRGB());
        }
    }

    public String getRandomId() {
        return this.randomId;
    }

    @XmlTransient
    public String getDisplayName() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if ((terminal != null && terminal.isShowTranslatedName().booleanValue() || this.isVariant().booleanValue()) && StringUtils.isNotEmpty((String)super.getTranslatedName())) {
            return super.getTranslatedName();
        }
        String string = super.getMenuItemName();
        return string;
    }
}

